<?php
class Setup_model extends Model
{
	protected $user;

	function __construct()
	{
		parent::__construct();
		$this->user = Session::getSession('user');
	}
	

	function saveCompany(){

		try{
			$insertCompany = new TblCompany();
			$insertCompany->companyNo = $_POST['company_no'];
			$insertCompany->company = $_POST['company_name'];
			$insertCompany->status =  isset($_POST['status']) ? 'enabled' : 'disabled';
			$insertCompany->createdBy = $this->user['id'];
			$insertCompany->modifiedBy = '0';
			$insertCompany->dateCreated = date('Y-m-d H:i:s');
			DAOFactory::getTblCompanyDAO()->insert($insertCompany);
		} catch(Exception $e) {
			$emsg=$e->getMessage();
			echo $emsg;
		}	

	}

	function saveDepartment(){

		$insertDept = new TblDepartment();
		$insertDept->deptNo = $_POST['dept_no'];
		$insertDept->department = $_POST['dept_name'];
		$insertDept->status = isset($_POST['status']) ? 'enabled' : 'disabled';
		$insertDept->createdBy = $this->user['id'];
		$insertDept->modifiedBy = '0';
		$insertDept->dateCreated= date('Y-m-d H:i:s');
		$id = DAOFactory::getTblDepartmentDAO()->insert($insertDept);

		$data['id'] = $id;
		$data['dept_no'] = $_POST['dept_no'];
		$data['department'] = $_POST['dept_name'];
		$data['status'] = isset($_POST['status']) ? 'enabled' : 'disabled';
		$data['created_by'] = $this->user['id'];
		$data['modified_by'] = '0';
		$data['date_created'] = date('Y-m-d H:i:s');
		$data['date_modified'] = '';

		if(SERVERTYPE == 'local'){
			Db::insert(DATABASE_SUB_LOCAL,'tbl_department',$data);
		} else {
			$subdomain = DAOFactory::getTblSubdomainAccountsDAO()->queryAll();
			foreach ($subdomain as $key => $each) {
				Db::insert($each->database,'tbl_department',$data);
			}
		}


	}
	function savePosition(){

		$insertPos = new TblPosition();
		$insertPos->positionNo = $_POST['pos_no'];
		$insertPos->position = $_POST['position'];
		$insertPos->status = isset($_POST['status']) ? 'enabled' : 'disabled';
		$insertPos->createdBy = $this->user['id'];
		$insertPos->modifiedBy = '0';
		$insertPos->dateCreated = date('Y-m-d H:i:s');
		
		DAOFactory::getTblPositionDAO()->insert($insertPos);
	}
	function saveTBA(){

		$insertTba = new TblTba();
		$insertTba->tbaNo = $_POST['tba_no'];
		$insertTba->tba = $_POST['tba_name'];
		$insertTba->status = isset($_POST['status']) ? 'enabled' : 'disabled';
		$insertTba->createdBy = $this->user['id'];;
		$insertTba->modifiedBy ='0';
		$insertTba->dateCreated = date('Y-m-d H:i:s');
		print_r($insertTba);
		DAOFactory::getTblTbaDAO()->insert($insertTba);

	}
	function saveNBT(){

		$insert = new TblNbt();
		$insert->nbtNo=$_POST['nbt_no'];
		$insert->nbt = $_POST['nbt'];
		$insert->status=isset($_POST['status']) ? 'enabled' : 'disabled';
		$insert->createdBy= $this->user['id'];;
		$insert->modifiedBy ='0';
		$insert->dateCreated= date('Y-m-d H:i:s');

		DAOFactory::getTblNbtDAO()->insert($insert);
	}

	function saveLeave(){
		$insert = new TblLeave();
		$insert->leaveNo = $_POST['leave_no'];
		$insert->leave = $_POST['leave'];
		$insert->code = $_POST['code'];
		$insert->status =isset($_POST['status']) ? 'enabled' : 'disabled';
		$insert->createdBy= $this->user['id'];;
		$insert->modifiedBy ='0';
		$insert->dateCreated = date('Y-m-d H:i:s');
		$id = DAOFactory::getTblLeaveDAO()->insert($insert);

		$data['id'] = $id;
		$data['leave_no'] = $_POST['leave_no'];
		$data['leave'] = $_POST['leave'];
		$data['code'] =  $_POST['code'];
		$data['status'] = isset($_POST['status']) ? 'enabled' : 'disabled';
		$data['created_by'] = $this->user['id'];
		$data['date_created'] = date('Y-m-d H:i:s');
		$data['date_modified'] = '';
		$data['modified_by'] = $this->user['id'];


		if(SERVERTYPE == 'local'){
			Db::insert(DATABASE_SUB_LOCAL,'tbl_leave',$data);
		} else {
			$subdomain = DAOFactory::getTblLeaveDAO()->queryAll();
			foreach ($subdomain as $key => $each) {
				Db::insert($each->database,'tbl_leave',$data);
			}
		}
	}

	function saveHourCode(){

		$insert = new TblHourCode();
		$insert->hourCodeNo = $_POST['hour_code_no'];
		$insert->hourCode = $_POST['hour_code'];
		$insert->description = $_POST['description'];
		$insert->status = isset($_POST['status']) ? 'enabled' : 'disabled';
		$insert->createdBy= $this->user['id'];;
		$insert->modifiedBy ='0';
		$insert->dateCreated = date('Y-m-d H:i:s');
		$id = DAOFactory::getTblHourCodeDAO()->insert($insert);

		$data['id'] = $id;
		$data['hour_code_no'] = $_POST['hour_code_no'];
		$data['hour_code'] = $_POST['hour_code'];
		$data['description'] =  $_POST['description'];
		$data['status'] = isset($_POST['status']) ? 'enabled' : 'disabled';
		$data['created_by'] = $this->user['id'];
		$data['date_created'] = date('Y-m-d H:i:s');
		$data['date_modified'] = '';
		$data['modified_by'] = $this->user['id'];

		if(SERVERTYPE == 'local'){
			Db::insert(DATABASE_SUB_LOCAL,'tbl_hour_code',$data);
		} else {
			$subdomain = DAOFactory::getTblHourCodeDAO()->queryAll();
			foreach ($subdomain as $key => $each) {
				Db::insert($each->database,'tbl_hour_code',$data);
			}
		}
	}

	function saveLeaveType(){

		$insert = new TblLeaveType();
		$insert->leaveTypeNo =$_POST['leave_type_no'];
		$insert->leaveType = $_POST['leave_type'];
		$insert->description =$_POST['description'];
		$insert->status =isset($_POST['status']) ? 'enabled' : 'disabled';
		$insert->createdBy= $this->user['id'];;
		$insert->modifiedBy ='0';
		$insert->dateCreated = date('Y-m-d H:i:s');
		$id = DAOFactory::getTblLeaveTypeDAO()->insert($insert);

		$data['id'] = $id;
		$data['leave_type_no'] = $_POST['leave_type_no'];
		$data['leave_type'] = $_POST['leave_type'];
		$data['description'] =  $_POST['description'];
		$data['status'] = isset($_POST['status']) ? 'enabled' : 'disabled';
		$data['created_by'] = $this->user['id'];
		$data['date_created'] = date('Y-m-d H:i:s');
		$data['date_modified'] = '';
		$data['modified_by'] = $this->user['id'];

		if(SERVERTYPE == 'local'){
			Db::insert(DATABASE_SUB_LOCAL,'tbl_leave_type',$data);
		} else {
			$subdomain = DAOFactory::getTblLeaveTypeDAO()->queryAll();
			foreach ($subdomain as $key => $each) {
				Db::insert($each->database,'tbl_leave_type',$data);
			}
		}
	}

	function saveBloodType(){
		try{
			$insert = new TblBloodType();
			$insert->bloodTypeNo = $_POST['blood_type_no'];
			$insert->bloodType = $_POST['blood_type'];
			$insert->status = isset($_POST['status']) ? 'enabled' : 'disabled';
			$insert->createdBy= $this->user['id'];;
			$insert->modifiedBy ='0';
			$insert->dateCreated =date('Y-m-d H:i:s');
			DAOFactory::getTblBloodTypeDAO()->insert($insert);
		} catch(Exception $e) {
			$emsg = $e->getMessage();
			echo $emsg;
		}
	}

	function saveHoliday(){

		$insert = new TblHoliday();
		$insert->holidayNo = $_POST['holiday_no'];
		$insert->holiday = $_POST['holiday'];
		$insert->status = isset($_POST['status']) ? 'enabled' : 'disabled';
		$insert->createdBy= $this->user['id'];
		$insert->modifiedBy ='0';
		$insert->dateCreated = date('Y-m-d H:i:s');
		$id = DAOFactory::getTblHolidayDAO()->insert($insert);

		$data['id'] = $id;
		$data['holiday_no'] = $_POST['holiday_no'];
		$data['holiday'] = $_POST['holiday'];
		$data['status'] = isset($_POST['status']) ? 'enabled' : 'disabled';
		$data['created_by'] = $this->user['id'];
		$data['date_created'] = date('Y-m-d H:i:s');
		$data['date_modified'] = '';
		$data['modified_by'] = $this->user['id'];


		if(SERVERTYPE == 'local'){
			Db::insert(DATABASE_SUB_LOCAL,'tbl_holiday',$data);
		} else {
			$subdomain = DAOFactory::getTblHolidayDAO()->queryAll();
			foreach ($subdomain as $key => $each) {
				Db::insert($each->database,'tbl_holiday',$data);
			}
		}
	}

	function saveEmployment(){

		$insert = new TblEmploymentStatu();
		$insert->employmenNo = $_POST['employment_no'];
		$insert->employment =$_POST['employment'];
		$insert->status = isset($_POST['status']) ? 'enabled' : 'disabled';
		$insert->createdBy= $this->user['id'];;
		$insert->modifiedBy ='0';
		$insert->dateCreated = date('Y-m-d H:i:s');
		$id = DAOFactory::getTblEmploymentStatusDAO()->insert($insert);

		$data['id'] = $id;
		$data['employmen_no'] = $_POST['employment_no'];
		$data['employment'] =  $_POST['employment'];
		$data['status'] = isset($_POST['status']) ? 'enabled' : 'disabled';
		$data['modified_by'] = 0;
		$data['created_by'] = $this->user['id'];
		$data['date_created'] = date('Y-m-d H:i:s');
		$data['date_modified'] = '';


		if(SERVERTYPE == 'local'){
			Db::insert(DATABASE_SUB_LOCAL,'tbl_employment_status',$data);
		} else {
			$subdomain = DAOFactory::getTblEmploymentStatusDAO()->queryAll();
			foreach ($subdomain as $key => $each) {
				Db::insert($each->database,'tbl_employment_status',$data);
			}
		}
	}

	function saveEmployee(){

		$insert = new TblEmployeeStatu();

		$insert->empstatusNo = $_POST['employee_no'];
		$insert->empStatus = $_POST['employee'];
		$insert->status = isset($_POST['status']) ? 'enabled' : 'disabled';
		$insert->createdBy= $this->user['id'];;
		$insert->modifiedBy ='0';
		$insert->dateCreated = date('Y-m-d H:i:s');
		$id=DAOFactory::getTblEmployeeStatusDAO()->insert($insert);

		$data['id'] = $id;
		$data['empstatus_no'] = $_POST['employee_no'];
		$data['emp_status'] =  $_POST['employee'];
		$data['status'] = isset($_POST['status']) ? 'enabled' : 'disabled';
		$data['modified_by'] = 0;
		$data['created_by'] = $this->user['id'];
		$data['date_created'] = date('Y-m-d H:i:s');
		$data['date_modified'] = '';


		if(SERVERTYPE == 'local'){
			Db::insert(DATABASE_SUB_LOCAL,'tbl_employee_status',$data);
		} else {
			$subdomain = DAOFactory::getTblEmployeeStatusDAO()->queryAll();
			foreach ($subdomain as $key => $each) {
				Db::insert($each->database,'tbl_employee_status',$data);
			}
		}
	}

	function saveTransportation(){

		$insert = new TblTransportationMode();
		$insert->transportationNo = $_POST['transportaion_no'];
		$insert->transportation = $_POST['transportaion'];
		$insert->status = isset($_POST['status']) ? 'enabled' : 'disabled';
		$insert->createdBy = $this->user['id'];
		$insert->modifiedBy ='0';
		$insert->dateCreated = date('Y-m-d H:i:s');
		$id = DAOFactory::getTblTransportationModeDAO()->insert($insert);

		$data['id'] = $id;
		$data['transportation_no'] = $_POST['transportaion_no'];
		$data['transportation'] = $_POST['transportaion'];
		$data['status'] = isset($_POST['status']) ? 'enabled' : 'disabled';
		$data['modified_by'] = 0;
		$data['created_by'] = $this->user['id'];
		$data['date_created'] = date('Y-m-d H:i:s');
		$data['date_modified'] = '';


		if(SERVERTYPE == 'local'){
			Db::insert(DATABASE_SUB_LOCAL,'tbl_transportation_mode',$data);
		} else {
			$subdomain = DAOFactory::getTblTransportationModeDAO()->queryAll();
			foreach ($subdomain as $key => $each) {
				Db::insert($each->database,'tbl_transportation_mode',$data);
			}
		}

	}

	function saveNBTTime(){

		$insert = new TblNbtTime();
		$insert->nbtTimeNo = $_POST['nbt_time_no'];
		$insert->from =date("H:i", strtotime($_POST['from']));
		$insert->to =date("H:i", strtotime($_POST['to']));
		$insert->description =$_POST['description'];
		$insert->status =isset($_POST['status']) ? 'enabled' : 'disabled';
		$insert->createdBy = $this->user['id'];
		$insert->modifiedBy ='0';
		$insert->dateCreated = date('Y-m-d H:i:s');

		DAOFactory::getTblNbtTimeDAO()->insert($insert);

	}

	function saveEngType(){

		$insert = new TblEngagementType();
		$insert->engTypeNo = $_POST['eng_type_no']; 
		$insert->engType = $_POST['eng_type'];
		$insert->status = isset($_POST['status']) ? 'enabled' : 'disabled';
		$insert->createdBy= $this->user['id'];;
		$insert->modifiedBy ='0';
		$insert->dateCreated = date('Y-m-d H:i:s');

		DAOFactory::getTblEngagementTypeDAO()->insert($insert);
	}

	function saveEngagement(){
		$insert = new TblEngagement();
		$insert->engagementNo = $_POST['engagement_no']; 
		$insert->engagement = $_POST['engagement'];
		$insert->status = isset($_POST['status']) ? 'enabled' : 'disabled';
		$insert->type = $_POST['type'];
		$insert->createdBy= $this->user['id'];;
		$insert->modifiedBy ='0';
		$insert->dateCreated = date('Y-m-d H:i:s');
		DAOFactory::getTblEngagementDAO()->insert($insert);
	}

	function saveLeavePerType(){

		$insert = new TblLeavePerType();
		$insert->leaveTypeId = $_POST['leaveType'];
		$insert->leaveId = $_POST['leave'];
		$insert->defaultCredits = $_POST['default_credits'];
		$insert->createdBy= $this->user['id'];;
		$insert->modifiedBy ='0';
		$insert->dateCreated =date('Y-m-d H:i:s');
		$id = DAOFactory::getTblLeavePerTypeDAO()->insert($insert);
		
	}

	function saveShift(){

		$insert = new TblShift();

		$insert->shiftNo = $_POST['shift_no'];
		$insert->shift = $_POST['shift_name'];
		$insert->status = $_POST['status'];
		$insert->createdBy= $this->user['id'];;
		$insert->modifiedBy ='0';
		$insert->dateCreated =date('Y-m-d H:i:s');

		DAOFactory::getTblShiftDAO()->insert($insert);
		
	}


	function saveSubperDept(){

		foreach ($_POST['department'] as $key => $value) {
			

			$insert = new TblSubdomainPerDept();
			$insert->subdomainId = $_POST['subdomain'];
			$insert->departmentId = $_POST['department'][$key];
			$insert->createdBy = $this->user['id'];
			$insert->modifiedBy ='0';
			$insert->dateCreated = date('Y-m-d H:i:s');
			DAOFactory::getTblSubdomainPerDeptDAO()->insert($insert);

		}
	}

	

	function showBloodType(){
		$data = DAOFactory::getTblBloodTypeDAO()->queryAllOrderBy('id DESC');
		echo json_encode($data);
	}
	function countBloodType(){
		$data = DAOFactory::getTblBloodTypeDAO()->countBloodType();
		echo json_encode($data);
	}


	function showCompany(){
		$data = DAOFactory::getTblCompanyDAO()->queryAllOrderBy('id DESC');
		echo json_encode($data);
	}	
	function countCompany(){
		$data = DAOFactory::getTblCompanyDAO()->countCompany();
		echo json_encode($data);
	}


	function showDepartment(){
		$data = DAOFactory::getTblDepartmentDAO()->queryAllOrderBy('id DESC');
		echo json_encode($data);
	}
	function countDepartment(){
		$data = DAOFactory::getTblDepartmentDAO()->countDepartment();
		echo json_encode($data);
	}

	function countShift(){
		$data = DAOFactory::getTblShiftDAO()->countShift();
		echo json_encode($data);
	}
	function showShift(){
		$data = DAOFactory::getTblShiftDAO()->queryAllOrderBy('id DESC');
		echo json_encode($data);
	}


	function showEmployeeStatus(){
		$data = DAOFactory::getTblEmployeeStatusDAO()->queryAllOrderBy('id DESC');
		echo json_encode($data);
	}	
	function countEmployeeStatus(){
		$data = DAOFactory::getTblEmployeeStatusDAO()->countEmployeeStatus();
		echo json_encode($data);
	}


	function showEmploymentStatus(){
		$data = DAOFactory::getTblEmploymentStatusDAO()->queryAllOrderBy('id DESC');
		echo json_encode($data);
	}
	function countEmploymentStatus(){
		$data = DAOFactory::getTblEmploymentStatusDAO()->countEmploymentStatus();
		echo json_encode($data);
	}


	function showEngType(){
		$data = DAOFactory::getTblEngagementTypeDAO()->queryAllOrderBy('id DESC');
		echo json_encode($data);
	}
	function countEngType(){
		$data = DAOFactory::getTblEngagementTypeDAO()->countEngType();
		echo json_encode($data);
	}


	function showHoliday(){
		$data = DAOFactory::getTblHolidayDAO()->queryAllOrderBy('id DESC');
		echo json_encode($data);
	}
	function countHoliday(){
		$data = DAOFactory::getTblHolidayDAO()->countHoliday();
		echo json_encode($data);
	}


	function showHourCode(){
		$data = DAOFactory::getTblHourCodeDAO()->queryAllOrderBy('id DESC');
		echo json_encode($data);
	}
	function countHourCode(){
		$data = DAOFactory::getTblHourCodeDAO()->countHourCode();
		echo json_encode($data);
	}


	function showLeave(){
		$data = DAOFactory::getTblLeaveDAO()->queryAllOrderBy('id DESC');
		echo json_encode($data);
	}	
	function countLeave(){
		$data = DAOFactory::getTblLeaveDAO()->countLeave();
		echo json_encode($data);
	}


	function showLeaveType(){
		$data = DAOFactory::getTblLeaveTypeDAO()->queryAllOrderBy('id DESC');
		echo json_encode($data);
	}
	function countLeaveType(){
		$data = DAOFactory::getTblLeaveTypeDAO()->countLeaveType();
		echo json_encode($data);
	}


	function showNBT(){
		$data = DAOFactory::getTblNbtDAO()->queryAllOrderBy('id DESC');
		echo json_encode($data);
	}
	function countNBT(){
		$data = DAOFactory::getTblNbtDAO()->countNBT();
		echo json_encode($data);
	}


	function showNbtTime(){
		$data = DAOFactory::getTblNbtTimeDAO()->queryAllOrderBy('id DESC');
		echo json_encode($data);
	}
	function countNbtTime(){
		$data = DAOFactory::getTblNbtTimeDAO()->countNbtTime();
		echo json_encode($data);
	}


	function showPosition(){
		$data = DAOFactory::getTblPositionDAO()->queryAllOrderBy('id DESC');
		echo json_encode($data);
	}
	function countPosition(){
		$data = DAOFactory::getTblPositionDAO()->countPosition();
		echo json_encode($data);
	}


	function showTBA(){
		$data = DAOFactory::getTblTbaDAO()->queryAllOrderBy('id DESC');
		echo json_encode($data);
	}
	function countTBA(){
		$data = DAOFactory::getTblTbaDAO()->countTBA();
		echo json_encode($data);
	}


	function showTransportation(){
		$data = DAOFactory::getTblTransportationModeDAO()->queryAllOrderBy('id DESC');
		echo json_encode($data);
	}
	function countTransportation(){
		$data = DAOFactory::getTblTransportationModeDAO()->countTransportation();
		echo json_encode($data);	
	}


	function showEngagement(){
		$data = DAOFactory::getTblEngagementDAO()->queryAllOrderBy('id DESC');
		echo json_encode($data);
	}
	function countEngagement(){
		$data = DAOFactory::getTblEngagementDAO()->countEngagement();
		echo json_encode($data);	
	}


	function getEnabledLeave(){

		$data = DAOFactory::getTblLeaveDAO()->queryByStatus('enabled');
		echo json_encode($data);
	}

	function getEnabledLeaveType(){

		$data = DAOFactory::getTblLeaveTypeDAO()->queryByStatus('enabled');

		echo json_encode($data);
	}

	function countLeavePerType(){

		$data = DAOFactory::getTblLeavePerTypeDAO()->countLeavePerType();

		echo json_encode($data);

	}

	function showLeavePerType(){

		$data = DAOFactory::getTblLeavePerTypeDAO()->showLeavePerType('id DESC');

		echo json_encode($data);
	}

	function getDepartment(){

		$data = DAOFactory::getTblDepartmentDAO()->queryByStatus('enabled');
		echo json_encode($data);
	}

	function getSubdomainAccounts(){

		$data = DAOFactory::getTblSubdomainAccountsDAO()->queryAll();

		echo json_encode($data);
	}

	function getSubdomainAndDept(){

		$data = DAOFactory::getTblSubdomainPerDeptDAO()->getSubdomainAndDept();
		echo json_encode($data);
	}
	 function showNbtTimePerPos(){
	 	$data = DAOFactory::getTblNbtPerPositionTimeDAO()->showNbtTimePerPos();
		echo json_encode($data);
	 }

	 function updateNbtTimePerPos(){
	 	$check = DAOFactory::getTblNbtPerPositionTimeDAO()->queryByPositionId($_POST['pos_id']);
		if(empty($check))
		{
			$insert = new tblNbtPerPositionTime;
			$insert->positionId = $_POST['pos_id'];
			$insert->assignedTime = $_POST['time'];
			$insert->dateCreated = date('Y-m-d H:i:s');
			$insert->createdBy = 1;
			$insert->modifiedBy = 1;
			DAOFactory::getTblNbtPerPositionTimeDAO()->insert($insert);
		} else {
			$update = DAOFactory::getTblNbtPerPositionTimeDAO()->queryByPositionId($_POST['pos_id']);
			$update[0]->assignedTime = $_POST['time'];
			$update[0]->dateModified =  date('Y-m-d H:i:s');
			$update[0]->modifiedBy = 1;
			DAOFactory::getTblNbtPerPositionTimeDAO()->update($update[0]);
		}
	 }
	
	function updateCompany(){
		try{

		$update = DAOFactory::getTblCompanyDAO()->load($_POST['company_id']);
		$update->company = $_POST['company_name'];
		$update->status = isset($_POST['status']) ? 'enabled' : 'disabled';
		$update->dateModified = date('Y-m-d H:i:s');
		$update->modifiedBy = $this->user['id'];
		DAOFactory::getTblCompanyDAO()->update($update);
		}catch(Exception $e){
			$emsg = $e->getMessage();
			echo $emsg;
		}
	}
	
	function updateDept(){

		$update = DAOFactory::getTblDepartmentDAO()->load($_POST['dept_id']);
		$update->department = $_POST['dept_name'];
		$update->status = isset($_POST['status']) ? 'enabled' : 'disabled';
		$update->dateModified = date('Y-m-d H:i:s');
		$update->modifiedBy = $this->user['id'];
		DAOFactory::getTblDepartmentDAO()->update($update);


		$data['dept_no'] = $update->deptNo;
		$data['department'] = $_POST['dept_name'];
		$data['status'] = isset($_POST['status']) ? 'enabled' : 'disabled';
		$data['created_by'] = $update->createdBy;
		$data['modified_by'] = $this->user['id'];
		$data['date_created'] = $update->dateCreated;
		$data['date_modified'] = date('Y-m-d H:i:s');
		$data['id'] = $update->id;

		if(SERVERTYPE == 'local'){
			Db::update(DATABASE_SUB_LOCAL,'tbl_department',$data);
		} else {
			$subdomain = DAOFactory::getTblSubdomainAccountsDAO()->queryAll();
			foreach ($subdomain as $key => $each) {
				Db::update($each->database,'tbl_department',$data);
			}
		}
	}

	function updatePosition(){
		$update = DAOFactory::getTblPositionDAO()->load($_POST['pos_id']);
		$update->position = $_POST['position'];
		$update->status = isset($_POST['status']) ? 'enabled' : 'disabled';
		$update->dateModified = date('Y-m-d H:i:s');
		$update->modifiedBy = $this->user['id'];
		DAOFactory::getTblPositionDAO()->update($update);
	}

	function updateEngagement(){
		$update = DAOFactory::getTblEngagementDAO()->load($_POST['engagement_id']);
		$update->engagement = $_POST['engagement'];
		$update->status = isset($_POST['status']) ? 'enabled' : 'disabled';
		$update->dateModified = date('Y-m-d H:i:s');
		$update->modifiedBy = $this->user['id'];
		DAOFactory::getTblEngagementDAO()->update($update);
	}

	function updateTBA(){
		$update = DAOFactory::getTblTbaDAO()->load($_POST['tba_id']);
		$update->tba = $_POST['tba_name'];
		$update->status = isset($_POST['status']) ? 'enabled' : 'disabled';
		$update->dateModified = date('Y-m-d H:i:s');
		$update->modifiedBy = $this->user['id'];
		DAOFactory::getTblTbaDAO()->update($update);
	}

	function updateNBT(){
		$update = DAOFactory::getTblNbtDAO()->load($_POST['nbt_id']);
		$update->nbt = $_POST['nbt'];
		$update->status = isset($_POST['status']) ? 'enabled' : 'disabled';
		$update->dateModified = date('Y-m-d H:i:s');
		$update->modifiedBy = $this->user['id'];
		DAOFactory::getTblNbtDAO()->update($update);
	}

	function updateLeave(){
		$update = DAOFactory::getTblLeaveDAO()->load($_POST['leave_id']);
		$update->leave = $_POST['leave'];
		$update->code = $_POST['code'];
		$update->status = isset($_POST['status']) ? 'enabled' : 'disabled';
		$update->dateModified = date('Y-m-d H:i:s');
		$update->modifiedBy = $this->user['id'];
		DAOFactory::getTblLeaveDAO()->update($update);

		$data['leave_no'] = $_POST['leave_no'];
		$data['leave'] = $_POST['leave'];
		$data['code'] =  $_POST['code'];
		$data['status'] = isset($_POST['status']) ? 'enabled' : 'disabled';
		$data['created_by'] = $this->user['id'];
		$data['date_created'] = $update->dateCreated;
		$data['date_modified'] = date('Y-m-d H:i:s');
		$data['modified_by'] = $this->user['id'];
		$data['id'] = $update->id;


		if(SERVERTYPE == 'local'){
			Db::update(DATABASE_SUB_LOCAL,'tbl_leave',$data);
		} else {
			$subdomain = DAOFactory::getTblLeaveDAO()->queryAll();
			foreach ($subdomain as $key => $each) {
				Db::update($each->database,'tbl_leave',$data);
			}
		}
	}

	function updateLeaveType(){
		$update = DAOFactory::getTblLeaveTypeDAO()->load($_POST['leave_type_id']);
		$update->leaveType = $_POST['leave_type'];
		$update->description = $_POST['description'];
		$update->status = isset($_POST['status']) ? 'enabled' : 'disabled';
		$update->dateModified = date('Y-m-d H:i:s');
		$update->modifiedBy = $this->user['id'];
		DAOFactory::getTblLeaveTypeDAO()->update($update);

		$data['leave_type_no'] = $update->leaveTypeNo;
		$data['leave_type'] = $_POST['leave_type'];
		$data['description'] =  $_POST['description'];
		$data['status'] = isset($_POST['status']) ? 'enabled' : 'disabled';
		$data['created_by'] = $this->user['id'];
		$data['date_created'] = $update->dateCreated;
		$data['date_modified'] = date('Y-m-d H:i:s');
		$data['modified_by'] = $this->user['id'];
		$data['id'] = $update->id;

		if(SERVERTYPE == 'local'){
			Db::update(DATABASE_SUB_LOCAL,'tbl_leave_type',$data);
		} else {
			$subdomain = DAOFactory::getTblLeaveTypeDAO()->queryAll();
			foreach ($subdomain as $key => $each) {
				Db::update($each->database,'tbl_leave_type',$data);
			}
		}
	}

	function updateBloodType(){
		try{
			$update = DAOFactory::getTblBloodTypeDAO()->load($_POST['blood_type_id']);
			$update->bloodType = $_POST['blood_type'];
			$update->status = isset($_POST['status']) ? 'enabled' : 'disabled';
			$update->dateModified = date('Y-m-d H:i:s');
			$update->modifiedBy = $this->user['id'];
			DAOFactory::getTblBloodTypeDAO()->update($update);
		}catch(Exception $e){
			$emsg = $e->getMessage();
			echo $emsg;
		}
	}

	function updateHourCode(){
		$update = DAOFactory::getTblHourCodeDAO()->load($_POST['hour_code_id']);
		$update->hourCode = $_POST['hour_code'];
		$update->description = $_POST['description'];
		$update->status = isset($_POST['status']) ? 'enabled' : 'disabled';
		$update->dateModified = date('Y-m-d H:i:s');
		$update->modifiedBy = $this->user['id'];
		DAOFactory::getTblHourCodeDAO()->update($update);

		$data['hour_code_no'] = $update->hourCodeNo;
		$data['hour_code'] = $_POST['hour_code'];
		$data['description'] =  $_POST['description'];
		$data['status'] = isset($_POST['status']) ? 'enabled' : 'disabled';
		$data['created_by'] = $this->user['id'];
		$data['date_created'] = $update->dateCreated;
		$data['date_modified'] =date('Y-m-d H:i:s');
		$data['modified_by'] = $this->user['id'];
		$data['id'] = $update->id;

		if(SERVERTYPE == 'local'){
			Db::update(DATABASE_SUB_LOCAL,'tbl_hour_code',$data);
		} else {
			$subdomain = DAOFactory::getTblHourCodeDAO()->queryAll();
			foreach ($subdomain as $key => $each) {
				Db::update($each->database,'tbl_hour_code',$data);
			}
		}
	}

	function updateHoliday(){
		$update = DAOFactory::getTblHolidayDAO()->load($_POST['holiday_id']);
		$update->holiday = $_POST['holiday'];
		$update->status = isset($_POST['status']) ? 'enabled' : 'disabled';
		$update->dateModified = date('Y-m-d H:i:s');
		$update->modifiedBy = $this->user['id'];
		DAOFactory::getTblHolidayDAO()->update($update);

		$data['holiday_no'] =$update->holidayNo;
		$data['holiday'] = $_POST['holiday'];
		$data['status'] = isset($_POST['status']) ? 'enabled' : 'disabled';
		$data['created_by'] = $this->user['id'];
		$data['date_created'] = $udpate->dateCreated;
		$data['date_modified'] = date('Y-m-d H:i:s');
		$data['modified_by'] = $this->user['id'];
		$data['id'] = $update->id;

		if(SERVERTYPE == 'local'){
			Db::update(DATABASE_SUB_LOCAL,'tbl_holiday',$data);
		} else {
			$subdomain = DAOFactory::getTblEmploymentStatusDAO()->queryAll();
			foreach ($subdomain as $key => $each) {
				Db::update($each->database,'tbl_holiday',$data);
			}
		}
	}

	function updateEmployment(){
		$update = DAOFactory::getTblEmploymentStatusDAO()->load($_POST['employment_id']);
		$update->employment = $_POST['employment'];
		$update->status = isset($_POST['status']) ? 'enabled' : 'disabled';
		$update->dateModified = date('Y-m-d H:i:s');
		$update->modifiedBy = $this->user['id'];
		DAOFactory::getTblEmploymentStatusDAO()->update($update);

		$data['employmen_no'] = $update->employmenNo;
		$data['employment'] =  $_POST['employment'];
		$data['status'] = isset($_POST['status']) ? 'enabled' : 'disabled';
		$data['modified_by'] =$this->user['id'];
		$data['created_by'] = $this->user['id'];
		$data['date_created'] = $update->dateCreated;
		$data['date_modified'] = '';
		$data['id'] = $update->id;

		if(SERVERTYPE == 'local'){
			Db::update(DATABASE_SUB_LOCAL,'tbl_employment_status',$data);
		} else {
			$subdomain = DAOFactory::getTblEmploymentStatusDAO()->queryAll();
			foreach ($subdomain as $key => $each) {
				Db::update($each->database,'tbl_employment_status',$data);
			}
		}
	}

	function updateEmployeeStatus(){
		$update = DAOFactory::getTblEmployeeStatusDAO()->load($_POST['employee_id']);
		$update->empStatus = $_POST['employee'];
		$update->status = isset($_POST['status']) ? 'enabled' : 'disabled';
		$update->dateModified = date('Y-m-d H:i:s');
		$update->modifiedBy = $this->user['id'];
		DAOFactory::getTblEmployeeStatusDAO()->update($update);


		$data['empstatus_no'] = $_POST['employee_no'];
		$data['emp_status'] =  $_POST['employee'];
		$data['status'] = isset($_POST['status']) ? 'enabled' : 'disabled';
		$data['modified_by'] = $this->user['id'];
		$data['created_by'] =  $this->user['id'];
		$data['date_created'] = $update->dateCreated;
		$data['date_modified'] = date('Y-m-d H:i:s');
		$data['id']= $update->id;

		if(SERVERTYPE == 'local'){
			Db::update(DATABASE_SUB_LOCAL,'tbl_employee_status',$data);
		} else {
			$subdomain = DAOFactory::getTblEmploymentStatusDAO()->queryAll();
			foreach ($subdomain as $key => $each) {
				Db::update($each->database,'tbl_employee_status',$data);
			}
		}
	}

	function updateTransportation(){
		$update = DAOFactory::getTblTransportationModeDAO()->load($_POST['transpo_id']);
		$update->transportation = $_POST['transportation'];
		$update->status = isset($_POST['status']) ? 'enabled' : 'disabled';
		$update->dateModified = date('Y-m-d H:i:s');
		$update->modifiedBy = $this->user['id'];
		DAOFactory::getTblTransportationModeDAO()->update($update);

		$data['transportation_no'] = $update->transportationNo;
		$data['transportation'] = $_POST['transportation'];
		$data['status'] = isset($_POST['status']) ? 'enabled' : 'disabled';
		$data['modified_by'] = 0;
		$data['created_by'] = $this->user['id'];
		$data['date_created'] = $update->dateCreated;
		$data['date_modified'] = date('Y-m-d H:i:s');
		$data['id'] = $update->id;

		if(SERVERTYPE == 'local'){
			Db::update(DATABASE_SUB_LOCAL,'tbl_transportation_mode',$data);
		} else {
			$subdomain = DAOFactory::getTblTransportationModeDAO()->queryAll();
			foreach ($subdomain as $key => $each) {
				Db::update($each->database,'tbl_transportation_mode',$data);
			}
		}
	}

	function updateEngType(){
		$update = DAOFactory::getTblEngagementTypeDAO()->load($_POST['eng_type_id']);
		$update->engType = $_POST['eng_type'];
		$update->status = isset($_POST['status']) ? 'enabled' : 'disabled';
		$update->dateModified = date('Y-m-d H:i:s');
		$update->modifiedBy = $this->user['id'];
		DAOFactory::getTblEngagementTypeDAO()->update($update);
	}

	function updateNbtTime(){
		$update = DAOFactory::getTblNbtTimeDAO()->load($_POST['nbt_time_id']);
		$update->from =date("H:i", strtotime($_POST['from']));
		$update->to =date("H:i", strtotime($_POST['to']));
		$update->description = $_POST['description'];
		$update->status = isset($_POST['status']) ? 'enabled' : 'disabled';
		$update->dateModified = date('Y-m-d H:i:s');
		$update->modifiedBy = $this->user['id'];
		DAOFactory::getTblNbtTimeDAO()->update($update);
	}
	function updateShift(){
		$update = DAOFactory::getTblShiftDAO()->load($_POST['shift_id']);
		$update->shift = $_POST['shift_name'];
		$update->status = isset($_POST['status']) ? 'enabled' : 'disabled';
		$update->dateModified = date('Y-m-d H:i:s');
		$update->modifiedBy = $this->user['id'];
		DAOFactory::getTblShiftDAO()->update($update);
	}

}
?>