<?php
/**
 * Class that operate on table 'tbl_engagement_type_per_dept_access'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2017-12-06 06:34
 */
class TblEngagementTypePerDeptAccessMySqlDAO implements TblEngagementTypePerDeptAccessDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @return TblEngagementTypePerDeptAccessMySql 
	 */
	public function load($id){
		$sql = 'SELECT * FROM tbl_engagement_type_per_dept_access WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($id);
		return $this->getRow($sqlQuery);
	}

	/**
	 * Get all records from table
	 */
	public function queryAll(){
		$sql = 'SELECT * FROM tbl_engagement_type_per_dept_access';
		$sqlQuery = new SqlQuery($sql);
		return $this->getList($sqlQuery);
	}
	
	/**
	 * Get all records from table ordered by field
	 *
	 * @param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn){
		$sql = 'SELECT * FROM tbl_engagement_type_per_dept_access ORDER BY '.$orderColumn;
		$sqlQuery = new SqlQuery($sql);
		return $this->getList($sqlQuery);
	}
	
	/**
 	 * Delete record from table
 	 * @param tblEngagementTypePerDeptAcces primary key
 	 */
	public function delete($id){
		$sql = 'DELETE FROM tbl_engagement_type_per_dept_access WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($id);
		return $this->executeUpdate($sqlQuery);
	}
	
	/**
 	 * Insert record to table
 	 *
 	 * @param TblEngagementTypePerDeptAccessMySql tblEngagementTypePerDeptAcces
 	 */
	public function insert($tblEngagementTypePerDeptAcces){
		$sql = 'INSERT INTO tbl_engagement_type_per_dept_access (engagement_type_id, department_id, position_id, created_by, modified_by, date_created, date_modified) VALUES (?, ?, ?, ?, ?, ?, ?)';
		$sqlQuery = new SqlQuery($sql);
		
		$sqlQuery->setNumber($tblEngagementTypePerDeptAcces->engagementTypeId);
		$sqlQuery->setNumber($tblEngagementTypePerDeptAcces->departmentId);
		$sqlQuery->setNumber($tblEngagementTypePerDeptAcces->positionId);
		$sqlQuery->setNumber($tblEngagementTypePerDeptAcces->createdBy);
		$sqlQuery->setNumber($tblEngagementTypePerDeptAcces->modifiedBy);
		$sqlQuery->set($tblEngagementTypePerDeptAcces->dateCreated);
		$sqlQuery->set($tblEngagementTypePerDeptAcces->dateModified);

		$id = $this->executeInsert($sqlQuery);	
		$tblEngagementTypePerDeptAcces->id = $id;
		return $id;
	}
	
	/**
 	 * Update record in table
 	 *
 	 * @param TblEngagementTypePerDeptAccessMySql tblEngagementTypePerDeptAcces
 	 */
	public function update($tblEngagementTypePerDeptAcces){
		$sql = 'UPDATE tbl_engagement_type_per_dept_access SET engagement_type_id = ?, department_id = ?, position_id = ?, created_by = ?, modified_by = ?, date_created = ?, date_modified = ? WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		
		$sqlQuery->setNumber($tblEngagementTypePerDeptAcces->engagementTypeId);
		$sqlQuery->setNumber($tblEngagementTypePerDeptAcces->departmentId);
		$sqlQuery->setNumber($tblEngagementTypePerDeptAcces->positionId);
		$sqlQuery->setNumber($tblEngagementTypePerDeptAcces->createdBy);
		$sqlQuery->setNumber($tblEngagementTypePerDeptAcces->modifiedBy);
		$sqlQuery->set($tblEngagementTypePerDeptAcces->dateCreated);
		$sqlQuery->set($tblEngagementTypePerDeptAcces->dateModified);

		$sqlQuery->setNumber($tblEngagementTypePerDeptAcces->id);
		return $this->executeUpdate($sqlQuery);
	}

	/**
 	 * Delete all rows
 	 */
	public function clean(){
		$sql = 'DELETE FROM tbl_engagement_type_per_dept_access';
		$sqlQuery = new SqlQuery($sql);
		return $this->executeUpdate($sqlQuery);
	}

	public function queryByEngagementTypeId($value){
		$sql = 'SELECT * FROM tbl_engagement_type_per_dept_access WHERE engagement_type_id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByDepartmentId($value){
		$sql = 'SELECT * FROM tbl_engagement_type_per_dept_access WHERE department_id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByPositionId($value){
		$sql = 'SELECT * FROM tbl_engagement_type_per_dept_access WHERE position_id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByCreatedBy($value){
		$sql = 'SELECT * FROM tbl_engagement_type_per_dept_access WHERE created_by = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByModifiedBy($value){
		$sql = 'SELECT * FROM tbl_engagement_type_per_dept_access WHERE modified_by = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByDateCreated($value){
		$sql = 'SELECT * FROM tbl_engagement_type_per_dept_access WHERE date_created = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByDateModified($value){
		$sql = 'SELECT * FROM tbl_engagement_type_per_dept_access WHERE date_modified = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}


	public function deleteByEngagementTypeId($value){
		$sql = 'DELETE FROM tbl_engagement_type_per_dept_access WHERE engagement_type_id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByDepartmentId($value){
		$sql = 'DELETE FROM tbl_engagement_type_per_dept_access WHERE department_id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByPositionId($value){
		$sql = 'DELETE FROM tbl_engagement_type_per_dept_access WHERE position_id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByCreatedBy($value){
		$sql = 'DELETE FROM tbl_engagement_type_per_dept_access WHERE created_by = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByModifiedBy($value){
		$sql = 'DELETE FROM tbl_engagement_type_per_dept_access WHERE modified_by = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByDateCreated($value){
		$sql = 'DELETE FROM tbl_engagement_type_per_dept_access WHERE date_created = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByDateModified($value){
		$sql = 'DELETE FROM tbl_engagement_type_per_dept_access WHERE date_modified = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}


	
	/**
	 * Read row
	 *
	 * @return TblEngagementTypePerDeptAccessMySql 
	 */
	protected function readRow($row){
		$tblEngagementTypePerDeptAcces = new TblEngagementTypePerDeptAcces();
		
		$tblEngagementTypePerDeptAcces->id = $row['id'];
		$tblEngagementTypePerDeptAcces->engagementTypeId = $row['engagement_type_id'];
		$tblEngagementTypePerDeptAcces->departmentId = $row['department_id'];
		$tblEngagementTypePerDeptAcces->positionId = $row['position_id'];
		$tblEngagementTypePerDeptAcces->createdBy = $row['created_by'];
		$tblEngagementTypePerDeptAcces->modifiedBy = $row['modified_by'];
		$tblEngagementTypePerDeptAcces->dateCreated = $row['date_created'];
		$tblEngagementTypePerDeptAcces->dateModified = $row['date_modified'];

		return $tblEngagementTypePerDeptAcces;
	}
	
	protected function getList($sqlQuery){
		$tab = QueryExecutor::execute($sqlQuery);
		$ret = array();
		for($i=0;$i<count($tab);$i++){
			$ret[$i] = $this->readRow($tab[$i]);
		}
		return $ret;
	}
	
	/**
	 * Get row
	 *
	 * @return TblEngagementTypePerDeptAccessMySql 
	 */
	protected function getRow($sqlQuery){
		$tab = QueryExecutor::execute($sqlQuery);
		if(count($tab)==0){
			return null;
		}
		return $this->readRow($tab[0]);		
	}
	
	/**
	 * Execute sql query
	 */
	protected function execute($sqlQuery){
		return QueryExecutor::execute($sqlQuery);
	}
	
		
	/**
	 * Execute sql query
	 */
	protected function executeUpdate($sqlQuery){
		return QueryExecutor::executeUpdate($sqlQuery);
	}

	/**
	 * Query for one row and one column
	 */
	protected function querySingleResult($sqlQuery){
		return QueryExecutor::queryForString($sqlQuery);
	}

	/**
	 * Insert row to table
	 */
	protected function executeInsert($sqlQuery){
		return QueryExecutor::executeInsert($sqlQuery);
	}
}
?>