<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2017-12-06 06:34
 */
interface TblSubdomainPerDeptDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return TblSubdomainPerDept 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param tblSubdomainPerDept primary key
 	 */
	public function delete($id);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param TblSubdomainPerDept tblSubdomainPerDept
 	 */
	public function insert($tblSubdomainPerDept);
	
	/**
 	 * Update record in table
 	 *
 	 * @param TblSubdomainPerDept tblSubdomainPerDept
 	 */
	public function update($tblSubdomainPerDept);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryBySubdomainId($value);

	public function queryByDepartmentId($value);

	public function queryByCreatedBy($value);

	public function queryByModifiedBy($value);

	public function queryByDateCreated($value);

	public function queryByDateModified($value);


	public function deleteBySubdomainId($value);

	public function deleteByDepartmentId($value);

	public function deleteByCreatedBy($value);

	public function deleteByModifiedBy($value);

	public function deleteByDateCreated($value);

	public function deleteByDateModified($value);


}
?>