<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2017-12-06 06:34
 */
interface TblNbtPerPositionTimeDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return TblNbtPerPositionTime 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param tblNbtPerPositionTime primary key
 	 */
	public function delete($id);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param TblNbtPerPositionTime tblNbtPerPositionTime
 	 */
	public function insert($tblNbtPerPositionTime);
	
	/**
 	 * Update record in table
 	 *
 	 * @param TblNbtPerPositionTime tblNbtPerPositionTime
 	 */
	public function update($tblNbtPerPositionTime);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryByPositionId($value);

	public function queryByAssignedTime($value);

	public function queryByCreatedBy($value);

	public function queryByModifiedBy($value);

	public function queryByDateCreated($value);

	public function queryByDateModified($value);


	public function deleteByPositionId($value);

	public function deleteByAssignedTime($value);

	public function deleteByCreatedBy($value);

	public function deleteByModifiedBy($value);

	public function deleteByDateCreated($value);

	public function deleteByDateModified($value);


}
?>