$(function(){
	show();
	seriesLastNum('tbl_nbt','NBT-','#formNBT','input[name="nbt_no"]');
	$('.sample').click(function(){
		$('#sampleModal').modal({
		  	backdrop: 'static', 
		    keyboard: false,
		    toggle: true
		 });
	});
	$('#formNBT').submit(function(){
		var data = $(this).serialize();
		saveAlert('You want to add this data?', function(){
			$.post(URL +'setup/saveNBT', data)
			.done(function(returnData){
				if(returnData == ''){
					toastr.success('Data Successfully Saved!');
					setTimeout(function(){
						location.reload();
					},1000)
				}else{
					toastr.error(returnData);
					$('#saveAlertModal').modal('hide');
				}
			});
			return false;
		})
		return false;
	});
	$('#nbt_table').on('click','.updateNBT',function(){
		$('#sampleModalUpdate').modal({
		  	backdrop: 'static', 
		    keyboard: false,
		    toggle: true
		 });
		var id = $(this).attr('nbtId');
		var nbt_no = $(this).closest('tr').find('td:nth-child(1)').html();
		var nbt = $(this).closest('tr').find('td:nth-child(2)').html();
		var status = $(this).closest('tr').find('td:nth-child(3)').html();

		$('#updateNBT').find('input[name="nbt_id"]').val(id);
		$('#updateNBT').find('input[name="nbt_no"]').val(nbt_no);
		$('#updateNBT').find('input[name="nbt"]').val(nbt);

		if(status == 'enabled'){
			$('#updateNBT').find('input[name="status"]').bootstrapToggle('on');
		}else{
			$('#updateNBT').find('input[name="status"]').bootstrapToggle('off');
		}
	})
	$('#updateNBT').submit(function(){
		var data = $(this).serialize();
		saveAlert('You want to update this data?',function(){
			$.post(URL+'setup/updateNBT', data)
			.done(function(returnData){
				if(returnData == ''){
					toastr.success('Data Successfully Updated!');
					setTimeout(function(){
						location.reload();
					},1000)
				}else{
					toastr.error(returnData);
					$('#saveAlertModal').modal('hide');
				}
			})
			return false;
		})
		return false;
	})
});

function show(){
	tableLoader('#nbt_table');
	$.post(URL+'setup/showNBT')
	.done(function(returnData){
		var data = $.parseJSON(returnData);
		var append = "";
		$.each(data,function(key,a){
			append += "<tr>"+
							"<td>"+a.nbtNo+"</td>"+
							"<td>"+a.nbt+"</td>"+
							"<td>"+a.status+"</td>"+
							"<td>"+
								"<a nbtId='"+a.id+"' class='updateNBT btn-edit-standard'><i class='fa fa-pencil-square-o'></i></a>"+
							"</td>"+
						"</tr>";	
		});
		$('.nbtData').html(append);
		$('#nbt_table').DataTable({
			    "ordering": false
		});
	})
}