
	$(function(){
		getLeaveType();

		$('.sample').click(function(){
			getRegularUser()
			$('#sampleModal').modal({
			  	backdrop: 'static', 
			    keyboard: false,
			    toggle: true
			 });
		});

		$('#formLeaveCredits').submit(function(){

		var data = $(this).serialize();
		var count = $('#leaveTypeTable tbody tr').length;
		if(count > 0){

			saveAlert('You want to add this data?', function(){
				$.post(URL + 'employee/saveLeaveCredits', data)
				.done(function(returnData){
					toastr.success('Data successfully saved!');
					setTimeout(function(){
						location.reload();
					},1000)
				});
				return false;
			
			});

		} else {
			toastr.warning('No Leave Code! Please setup Leave per Leave Type');
		}
			return false;
		});

		$('#leaveType').change(function(){

			var id = $(this).val();

			$.post(URL + 'employee/getCredits',{'id':id})
			.done(function(returnData){

				var data = $.parseJSON(returnData);
				var append = '';
				$.each(data, function(key, a){

					append +=  
						'<tr>'+
						'<td>'+a.leave+'</td>'+
						'<td><input type="text" name="credits[]" required class="form-control" value='+a.default_credits+'><input type="text" hidden name="leave_per_type_id[]" value='+a.leave_per_type_id+'></td>'+
						'</tr>';



				});

				$('#leaveTypeTable tbody').html(append);
			});

		});
		$('.updateLeaveCredits').click(function(){
			var userid = $(this).attr('userId');
			$('#updateLeaveCreditsModal').modal('toggle');
			getCreditsPerUser(userid);

		})
		$('#updateLeaveCreditsForm').submit(function(){
			var form = $(this).serialize();

			$.post(URL + 'employee/updateLeaveCredit', form)
			.done(function(returnData){
				toastr.success('Updated successfully!');
				setTimeout(function(){
					location.reload();
				},1000)
			})
			return false;
		})
	});

	function updateCreditSelectNew(){
		$('.updateCredit').unbind('keyup');
		$('.updateCredit').bind('keyup', function(){
			var value = $(this).val();
			var that = $(this);
			var type = $(this).parent('div').find('select').val();
			var currentVal = $(this).closest('div.row').children('div.currentDiv').find('input.currentCredit');
			var current = $(this).closest('div.row').children('div.currentDiv').find('input.currentCredit').attr('data-current');

			var total = 0;
			if(type=='add'){
				total = parseFloat(current)+parseFloat(value);
				$(this).closest('div.row').children('div.currentDiv').find('input.currentCredit').val(total.toFixed(2));
			} else {
				if(current>=value){
					total = parseFloat(current)-parseFloat(value);
					$(this).closest('div.row').children('div.currentDiv').find('input.currentCredit').val(total.toFixed(2));	
				} else {
					toastr.error("Can't subtract greater than current credits");
					that.val(0);
					currentVal.val(current);
				}
			}
		})

		$('.updateCreditSelect').unbind('change');
		$('.updateCreditSelect').bind('change', function(){
			var value = $(this).closest('div.input-group').find('input').val();
			var type = $(this).val();
			var that = $(this).closest('div.input-group').find('input');
			var currentVal = $(this).closest('div.row').children('div.currentDiv').find('input.currentCredit');
			var current = $(this).closest('div.row').children('div.currentDiv').find('input.currentCredit').attr('data-current');

			var total = 0;
			if(type=='add'){
				total = parseFloat(current)+parseFloat(value);
				$(this).closest('div.row').children('div.currentDiv').find('input.currentCredit').val(total.toFixed(2));
			} else {
				if(current>=value){
					total = parseFloat(current)-parseFloat(value);
					$(this).closest('div.row').children('div.currentDiv').find('input.currentCredit').val(total.toFixed(2));	
				} else {
					toastr.error("Can't subtract greater than current credits");
					that.val(0);
					currentVal.val(current);
				}
			}
		})

	}
	function getLeaveType(){

		$.post(URL + 'employee/getEnabledLeaveType')
		.done(function(returnData){

			var data = $.parseJSON(returnData);
			var append ='<option value="" selected disabled>Select Leave Type</option> ';

			$.each(data, function(key, a){

				append += '<option value='+a.id+'>'+a.leaveType+'</option>';

			});

			$('#leaveType').html(append);
			$('#leaveType').selectpicker('refresh');
		});

	}
	function getRegularUser(){

		$.post(URL + 'employee/getUserRegularWithoutCredits')
		.done(function(returnData){
			var data = $.parseJSON(returnData);
			var append ='';

			$.each(data, function(key, a){

				append += '<option value='+a.id+'>'+a.name+'</option>';

			});

			$('select[name="user"]').html(append);
			$('select[name="user"]').selectpicker('refresh');
		});

	}
	function getCreditsPerUser(id){

		$.post(URL + 'employee/getCreditsPerUser', {'id':id})
		.done(function(returnData){
			var data = $.parseJSON(returnData);
			var append ='';
			// return false;
			$('#leaveCreditId').val(data[0].leave_credits_id);
			$('#leaveUserId').val(data[0].user_id);
			$('.returnLeaveCredits').html('');
			$.each(data, function(key, a){

				append +=  '<div class="row mt-20">'+
						  		'<div class="col-lg-5 col-lg-offset-1">'+
									'<label>'+a.leave+' - '+a.code+'</label>'+
									'<input name="leaveCreditPerTypeId[]" type="hidden" value="'+a.leave_credits_per_type_id+'">'+
								'</div>'+
						  		'<div class="col-lg-5 text-right">'+
									'<label>Current Credits:  <strong>'+a.credits+'</strong></label>'+
								'</div>'+
						  		'<div class="col-lg-5 col-lg-offset-1 updateCreditSelectDiv">'+
									'<div class="input-group">'+
									     	'<select class="selectpicker updateCreditSelect" name="typeupdate'+a.code+'">'+
											'</select>'+
									    '<input type="text" class="form-control updateCredit" name="update'+a.code+'Trans" id="update'+a.code+'Trans" value="0">'+
								  	'</div>'+
								'</div>'+
								'<div class="col-lg-5 currentDiv">'+
									'<div class="input-group">'+
										'<span class="input-group-addon" style="background: #fff!important; color: #000;">Credits:</span>'+
									    '<input type="text" class="form-control currentCredit" name="update'+a.code+'" data-current="'+a.credits+'" value="'+a.credits+'" id="updateSIL" readonly="">'+
								  	'</div>'+
								'</div>'+
							'</div>';
			});

				var thisAppend = $(append).appendTo('.returnLeaveCredits');
				updateCreditSelectNew();
		        thisAppend.queue(function(){
			        var thisThat = $(this);
					updateCreditSelect(thisThat);
	    		});


			// $('.returnLeaveCredits').html(append);
		});


	}
	function updateCreditSelect(thisThat){
		// alert()
		// thisThat.find('select[name="updateCreditSelect"]').html('dd');
		thisThat.find('.updateCreditSelect').html('<option value="add">Add</option><option value="less">Less</option>');
		thisThat.find('.updateCreditSelect').selectpicker('refresh');


	}