<?php

class Mapping_model extends Model
{

	function __construct()
	{
		parent::__construct();
	}
	function getDepartment(){
		$data = DAOFactory::getTblDepartmentDAO()->queryByStatus('enabled');
		echo json_encode($data);
	}
	function showEngType(){
		$data = DAOFactory::getTblEngagementTypeDAO()->queryByStatus('enabled');
		echo json_encode($data);
	}
	
	public function getUnmappedEngagement(){
		$deptId = $_POST['department'];
		$data = DAOFactory::getTblEngagementPerDeptDAO()->getUnmapped($deptId);
		echo json_encode($data);
	}	
	public function getMappedEngagement(){
		$deptId = $_POST['department'];
		$data = DAOFactory::getTblEngagementPerDeptDAO()->getMapped($deptId);
		echo json_encode($data);
	}
	public function saveMappedEngagement(){

		$deptid = $_POST['deptid'];
		if(isset($_POST['mapped']) && !empty($_POST['mapped'])){
			$mapped = $_POST['mapped'];
			$check = DAOFactory::getTblEngagementPerDeptDAO()->getMapped($deptid);
			if(empty($check)){
				foreach ($mapped as $key=> $each) {
					$insert = new TblEngagementPerDept;
					$insert->engagementId = $each;
					$insert->deptId = $deptid;
					$insert->createdBy = 1;
					$insert->modifiedBy = 1;
					$insert->dateCreated = date('Y-m-d H:i:s');
					$insert->dateModified = "0000-00-00 00:00:00";
					$epd = DAOFactory::getTblEngagementPerDeptDAO()->insert($insert);

					$data_post['tblEngagementPerDept'][] = DAOFactory::getTblEngagementPerDeptDAO()->load($epd);
					$data_post['tblEngagement'][] = DAOFactory::getTblEngagementDAO()->load($each);
				}
			} else {
				foreach ($mapped as $key=> $each) {
					$checkEach = DAOFactory::getTblEngagementPerDeptDAO()->checkAdd($deptid,$each);
					if(empty($checkEach)){
						$insert = new TblEngagementPerDept;
						$insert->engagementId = $each;
						$insert->deptId = $deptid;
						$insert->createdBy = 1;
						$insert->modifiedBy = 1;
						$insert->dateCreated = date('Y-m-d H:i:s');
						$insert->dateModified = "0000-00-00 00:00:00";
						$epd = DAOFactory::getTblEngagementPerDeptDAO()->insert($insert);

						$data_post['tblEngagementPerDept'][] = DAOFactory::getTblEngagementPerDeptDAO()->load($epd);
						$data_post['tblEngagement'][] = DAOFactory::getTblEngagementDAO()->load($each);

					} else {
						$data_post['tblEngagementPerDept'][] = $checkEach[0];
						$data_post['tblEngagement'][] = DAOFactory::getTblEngagementDAO()->load($each);
					}

				}
			}
		}

		if(isset($_POST['unmapped']) && !empty($_POST['unmapped'])){
			$unmapped = $_POST['unmapped'];
			foreach ($unmapped as $key=> $each) {
				$checkEach = DAOFactory::getTblEngagementPerDeptDAO()->checkAdd($deptid,$each);
				if(!empty($checkEach)){
					DAOFactory::getTblEngagementPerDeptDAO()->delete($checkEach[0]->id);

					$data_post['deptid'] = $deptid;
				 	$data_post['engid'][] = $each;
				 	$data_post['unmapped'] = 'yes';
				}
			}
		}

		if(SERVERTYPE=='local'){
			$url = DOMAIN_MAIN.'/api/mapEngagement/';
			Controller::send($url,$data_post);
		}
		else{
			$subdomains = DAOFactory::getTblSubdomainAccountsDAO()->getSubdomains($deptid);
			foreach ($subdomains as $each) {
				$url = 'http://'.$each['subdomain'].'/api/mapEngagement/';
				Controller::send($url, $data_post);
			}
		}

	}


	public function getEngagementByDept(){
		$deptId = $_POST['department'];
		$data = DAOFactory::getTblEngagementPerDeptDAO()->getEngagementByDept($deptId);
		echo json_encode($data);
	}
	public function getUnmappedTba(){
		$deptId = $_POST['department'];
		$engid = $_POST['engagement'];
		$engtype = $_POST['engtype'];
		$data = DAOFactory::getTblTbaPerEngDAO()->getUnmapped($deptId,$engid,$engtype);
		echo json_encode($data);
	}
	public function getMappedTba(){
		$deptId = $_POST['department'];
		$engid = $_POST['engagement'];
		$engtype = $_POST['engtype'];
		$data = DAOFactory::getTblTbaPerEngDAO()->getMapped($deptId,$engid,$engtype);
		echo json_encode($data);
	}
	public function saveMappedTba(){

		$deptid = $_POST['deptid'];
		$engid = $_POST['engid']; //eng_per_dept_id
		$engtype = $_POST['engtypeid'];
		if(isset($_POST['mapped']) && !empty($_POST['mapped'])){
			$mapped = $_POST['mapped'];
			$check = DAOFactory::getTblTbaPerEngDAO()->getMapped($deptid,$engid,$engtype);
			if(empty($check)){
				foreach ($mapped as $key=> $each) {
					$insert = new TblTbaPerEng;
					$insert->engPerDeptId = $engid;
					$insert->engTypeId = $engtype;
					$insert->tbaId = $each;
					$insert->createdBy = 1;
					$insert->modifiedBy = 1;
					$insert->dateCreated = date('Y-m-d H:i:s');
					$insert->dateModified = "0000-00-00 00:00:00";
					$tpe = DAOFactory::getTblTbaPerEngDAO()->insert($insert);

					$data_post['tblTbaPerEng'][] = DAOFactory::getTblTbaPerEngDAO()->load($tpe);
					$data_post['tblTba'][] = DAOFactory::getTblTbaDAO()->load($each);
				}
			} else {
				foreach ($mapped as $key=> $each) {
					$checkEach = DAOFactory::getTblTbaPerEngDAO()->checkAdd($engid,$engtype,$each);
					if(empty($checkEach)){
						$insert = new TblTbaPerEng;
						$insert->engPerDeptId = $engid;
						$insert->engTypeId = $engtype;
						$insert->tbaId = $each;
						$insert->createdBy = 1;
						$insert->modifiedBy = 1;
						$insert->dateCreated = date('Y-m-d H:i:s');
						$insert->dateModified = "0000-00-00 00:00:00";
						$tpe = DAOFactory::getTblTbaPerEngDAO()->insert($insert);

						$data_post['tblTbaPerEng'][] = DAOFactory::getTblTbaPerEngDAO()->load($tpe);
						$data_post['tblTba'][] = DAOFactory::getTblTbaDAO()->load($each);

					} else {
						$data_post['tblTbaPerEng'][] = $checkEach[0];
						$data_post['tblTba'][] = DAOFactory::getTblTbaDAO()->load($each);
					}

				}
			}
		}

		if(isset($_POST['unmapped']) && !empty($_POST['unmapped'])){
			$unmapped = $_POST['unmapped'];
			foreach ($unmapped as $key=> $each) {
				$checkEach = DAOFactory::getTblTbaPerEngDAO()->checkAdd($engid,$engtype,$each);
				if(!empty($checkEach)){
					DAOFactory::getTblTbaPerEngDAO()->delete($checkEach[0]->id);

					$data_post['engid'] = $engid;
				 	$data_post['tbaid'][] = $each;
				 	$data_post['engtypeid'] = $engtype;
				 	$data_post['unmapped'] = 'yes';
				}
			}
		}

		if(SERVERTYPE=='local'){
			$url = DOMAIN_MAIN.'/api/mapTba/';
			Controller::send($url,$data_post);
		}
		else{
			$subdomains = DAOFactory::getTblSubdomainAccountsDAO()->getSubdomains($deptid);
			foreach ($subdomains as $each) {
				$url = 'http://'.$each['subdomain'].'/api/mapTba/';
				Controller::send($url, $data_post);
			}
		}

	}


	public function getTbaByEngagement(){
		$deptId = $_POST['department'];
		$engid = $_POST['engagement'];
		$engtype = $_POST['engtype'];
		$data = DAOFactory::getTblTbaPerEngDAO()->getTbaByEngagement($deptId,$engid,$engtype);
		echo json_encode($data);
	}
	public function getUnmappedNbt(){
		$deptId = $_POST['department'];
		$engid = $_POST['engagement'];
		$engtype = $_POST['engtype'];
		$tbaid = $_POST['tba'];
		$data = DAOFactory::getTblNbtPerTbaDAO()->getUnmapped($tbaid,$engtype,$engid,$deptId);
		echo json_encode($data);
	}
	public function getMappedNbt(){
		$deptId = $_POST['department'];
		$engid = $_POST['engagement'];
		$engtype = $_POST['engtype'];
		$tbaid = $_POST['tba'];
		$data = DAOFactory::getTblNbtPerTbaDAO()->getMapped($tbaid,$engtype,$engid,$deptId);
		echo json_encode($data);
	}
	public function saveMappedNbt(){

		$deptid = $_POST['deptid'];
		$engid = $_POST['engid']; //eng_per_dept_id
		$engtype = $_POST['engtypeid'];
		$tbaid = $_POST['tbaid'];//tba_per_eng_id
		if(isset($_POST['mapped']) && !empty($_POST['mapped'])){
			$mapped = $_POST['mapped'];
			$check = DAOFactory::getTblNbtPerTbaDAO()->getMapped($tbaid,$engtype,$engid,$deptid);
			if(empty($check)){
				foreach ($mapped as $key=> $each) {
					$insert = new TblNbtPerTba;
					$insert->nbtId = $each;
					$insert->tbaPerEngId = $tbaid;
					$insert->createdBy = 1;
					$insert->modifiedBy = 1;
					$insert->dateCreated = date('Y-m-d H:i:s');
					$insert->dateModified = "0000-00-00 00:00:00";
					$npt = DAOFactory::getTblNbtPerTbaDAO()->insert($insert);

					$data_post['tblNbtPerTba'][] = DAOFactory::getTblNbtPerTbaDAO()->load($npt);
					$data_post['tblNbt'][] = DAOFactory::getTblNbtDAO()->load($each);
				}
			} else {
				foreach ($mapped as $key=> $each) {
					$checkEach = DAOFactory::getTblNbtPerTbaDAO()->checkAdd($each,$tbaid);
					if(empty($checkEach)){
						$insert = new TblNbtPerTba;
						$insert->nbtId = $each;
						$insert->tbaPerEngId = $tbaid;
						$insert->createdBy = 1;
						$insert->modifiedBy = 1;
						$insert->dateCreated = date('Y-m-d H:i:s');
						$insert->dateModified = "0000-00-00 00:00:00";
						$npt = DAOFactory::getTblNbtPerTbaDAO()->insert($insert);

						$data_post['tblNbtPerTba'][] = DAOFactory::getTblNbtPerTbaDAO()->load($npt);
						$data_post['tblNbt'][] = DAOFactory::getTblNbtDAO()->load($each);

					} else {
						$data_post['tblNbtPerTba'][] = $checkEach[0];
						$data_post['tblNbt'][] = DAOFactory::getTblNbtDAO()->load($each);
					}

				}
			}
		}

		if(isset($_POST['unmapped']) && !empty($_POST['unmapped'])){
			$unmapped = $_POST['unmapped'];
			foreach ($unmapped as $key=> $each) {
				$checkEach = DAOFactory::getTblNbtPerTbaDAO()->checkAdd($each,$tbaid);
				if(!empty($checkEach)){
					DAOFactory::getTblNbtPerTbaDAO()->delete($checkEach[0]->id);

					$data_post['tbaid'] = $tbaid;
				 	$data_post['nbtid'][] = $each;
				 	$data_post['unmapped'] = 'yes';
				}
			}
		}

		if(SERVERTYPE=='local'){
			$url = DOMAIN_MAIN.'/api/mapNbt/';
			Controller::send($url,$data_post);
		}
		else{
			$subdomains = DAOFactory::getTblSubdomainAccountsDAO()->getSubdomains($deptid);
			foreach ($subdomains as $each) {
				$url = 'http://'.$each['subdomain'].'/api/mapNbt/';
				Controller::send($url, $data_post);
			}
		}


	}
}

?>