<?php
class Employee_model extends Model
{
	protected $user;

	function __construct()
	{
		parent::__construct();
		$this->user = Session::getSession('user');
	}

	public function getDepartment(){

		$data = DAOFactory::getTblDepartmentDAO()->queryByStatus('enabled');

		echo json_encode($data);
	}

	public function getPosition(){

		$data = DAOFactory::getTblPositionDAO()->queryByStatus('enabled');

		echo json_encode($data);
	}

	public function getLocation(){

		$data = DAOFactory::getTblProvincesDAO()->queryAll();

		echo json_encode($data);
	}

	public function getEmploymentStatus(){

		$data = DAOFactory::getTblEmploymentStatusDAO()->queryByStatus('enabled');

		echo json_encode($data);
	}

	public function getEmployeeStatus(){

		$data = DAOFactory::getTblEmployeeStatusDAO()->queryByStatus('enabled');

		echo json_encode($data);
	}
	public function getEmployeeDetails(){

		$data = DAOFactory::getTblUserDAO()->load($_POST['id']);
		echo json_encode($data);
	}
	public function getUserRegularWithoutCredits(){

		$data = DAOFactory::getTblUserDAO()->getUserRegularWithoutCredits();
		echo json_encode($data);
	}

	public function saveEmployee(){

		$insertUser = new TblUser();
		$insertUser->username = $_POST['username'];
		$insertUser->password = $_POST['password'];
		$insertUser->userType = $_POST['user_type'];
		$insertUser->subdomain = $_POST['subdomain'];
		$insertUser->createdBy = '1';
		$insertUser->modifiedBy = '1';
		$insertUser->dateCreated = date('Y-m-d H:i:s');

		$userId = DAOFactory::getTblUserDAO()->insert($insertUser);

		$insertInfo = new TblUserInfo();
		$insertInfo->userId = $userId;
		$insertInfo->positionId = $_POST['position'];
		$insertInfo->departmentId = $_POST['department'];
		$insertInfo->companyIdentification = $_POST['company_id'];
		$insertInfo->fname = $_POST['fname'];
		$insertInfo->mname = $_POST['mname'];
		$insertInfo->lname = $_POST['lname'];
		$insertInfo->email = $_POST['email'];
		$insertInfo->shift = $_POST['shift'];
		$insertInfo->userDesc = $_POST['user_description'];
		$insertInfo->assignedLocation = $_POST['location'];
		$insertInfo->employmentStatus = $_POST['employment'];
		$insertInfo->employeeStatus = $_POST['employee_status'];
		$insertInfo->dateHired = $_POST['date_hired'];
		$insertInfo->dateRegularization = $_POST['date_regularization'];
		$insertInfo->dateResigned = '0000-00-00 00:00:00';
		$insertInfo->createdBy = '1';
		$insertInfo->modifiedBy = '1';
		$insertInfo->dateCreated = date('Y-m-d H:i:s');

		
		$data = DAOFactory::getTbluserInfoDAO()->insert($insertInfo);


	}
	function saveLeaveCredits(){

		$credits = array_sum($_POST['credits']);


		$insert = new TblLeaveCredit();
		$insert->userId = $_POST['user'];
		$insert->leaveTypeId = $_POST['leave_type'];
		$insert->totalCredits = $credits;
		$insert->createdBy = '1';
		$insert->modifiedBy = '1';
		$insert->dateCreated = date('Y-m-d H:i:s');
	
		$leaveCreditId = DAOFactory::getTblLeaveCreditsDAO()->insert($insert);

		$data['id'] = $leaveCreditId;
		$data['user_id'] = $_POST['user'];
		$data['leave_type_id'] = $_POST['leave_type'];
		$data['total_credits'] = $credits;
		$data['created_by'] = '1';
		$data['modified_by'] = '1';
		$data['date_created'] = date('Y-m-d H:i:s');
		$data['date_modified'] = '0000-00-00 00:00:00';

		if(SERVERTYPE == 'local'){
			Db::insert(DATABASE_SUB_LOCAL,'tbl_leave_credits',$data);
		} else {
			$user = DAOFactory::getTblUserDAO()->load($_POST['user']);
			$subdomain = DAOFactory::getTblSubdomainAccountsDAO()->load($user->subdomain);
			Db::insert($subdomain->database,'tbl_leave_credits',$data);
		}

		foreach ($_POST['leave_per_type_id'] as $key => $value) {

			$insert1 = new TblLeaveCreditsPerType();
			$insert1->credits = $_POST['credits'][$key];
			$insert1->leaveCreditsId = $leaveCreditId;
			$insert1->leavePerTypeId = $_POST['leave_per_type_id'][$key];
			$insert1->createdBy ='1';
			$insert1->modifiedBy ='1';
			$insert1->dateCreated =date('Y-m-d H:i:s');
			$id = DAOFactory::getTblLeaveCreditsPerTypeDAO()->insert($insert1);

			$data['id'] = $id;
			$data['credits'] = $_POST['credits'][$key];
			$data['leave_credits_id'] = $leaveCreditId;
			$data['leave_per_type_id'] = $_POST['leave_per_type_id'][$key];
			$data['created_by'] = '1';
			$data['modified_by'] = '1';
			$data['date_created'] = date('Y-m-d H:i:s');
			$data['date_modified'] = '0000-00-00 00:00:00';

			if(SERVERTYPE == 'local'){
				Db::insert(DATABASE_SUB_LOCAL,'tbl_leave_credits_per_type',$data);
			} else {
				$user = DAOFactory::getTblUserDAO()->load($_POST['user']);
				$subdomain = DAOFactory::getTblSubdomainAccountsDAO()->load($user->subdomain);
				Db::insert($subdomain->database,'tbl_leave_credits_per_type',$data);
			}
		}
	}

	function updateUser2(){

		$user = DAOFactory::getTblUserDAO()->load($_POST['userId']);
		$user->username = $_POST['username'];
		$user->password = $_POST['password'];
		$user->userType = $_POST['user_type'];
		$user->subdomain = $_POST['subdomain'];
		$user->createdBy = '2';
		$user->modifiedBy = '2';
		$user->dateModified =date('Y-m-d H:i:s');
		DAOFactory::getTblUserDAO()->update($user);


		$userinfo = DAOFactory::getTbluserInfoDAO()->load($_POST['userInfoId']);
		$userinfo->positionId = $_POST['position'];
		$userinfo->departmentId = $_POST['department'];
		$userinfo->companyIdentification =$_POST['company_id'];
		$userinfo->fname =$_POST['fname'];
		$userinfo->mname = $_POST['mname'];
		$userinfo->lname =$_POST['lname'];
		$userinfo->email =$_POST['email'];
		$userinfo->shift =$_POST['shift'];
		$userinfo->userDesc =$_POST['user_description'];
		$userinfo->assignedLocation =$_POST['location'];
		$userinfo->employmentStatus =$_POST['employment'];
		$userinfo->employeeStatus =$_POST['employee_status'];
		$userinfo->dateHired =$_POST['date_hired'];
		$userinfo->dateRegularization =$_POST['date_regularization'];
		$userinfo->createdBy ='2';
		$userinfo->modifiedBy = '2';
		$userinfo->dateModified =date('Y-m-d H:i:s');
		DAOFactory::getTbluserInfoDAO()->update($userinfo);

		
	}

	function addUserInfo(){

		$info = DAOFactory::getTblUserInfoOtherDAO()->load($_POST['userInfoOtherId']);

		if(empty($info)){

			$insert = new TblUserInfoOther();
			$insert->userId = $_POST['userId'];
			$insert->bdate = $_POST['birthday'];
			$insert->gender = $_POST['gender'];
			$insert->phoneNo = $_POST['phone_no'];
			$insert->mobileNo = $_POST['mobile_no'];
			$insert->currentAddress = $_POST['current_address'];
			$insert->currentCity = $_POST['current_city'];
			$insert->currentProvince = $_POST['current_province'];
			$insert->permanentAddress = $_POST['permanent_address'];
			$insert->permanentCity = $_POST['permanent_city'];
			$insert->permanentProvince = $_POST['permanent_province'];
			$insert->civilStatus = $_POST['civil_status'];
			$insert->contactPerson = $_POST['contact_person'];
			$insert->contactNumber = $_POST['contact_number'];
			$insert->contactAddress = $_POST['contact_address'];
			$insert->sss = $_POST['sss'];
			$insert->tin = $_POST['tin'];
			$insert->philhealth = $_POST['philhealth'];
			$insert->hdmf = $_POST['hdmf'];
			$insert->bloodTypeId = $_POST['blood_type'];
			$insert->createdBy = '2';
			$insert->modifiedBy = '2';
			$insert->dateCreated = date('Y-m-d H:i:s');
			DAOFactory::getTblUserInfoOtherDAO()->insert($insert);

		} else {

			$info->userId = $_POST['userId'];
			$info->bdate = $_POST['birthday'];
			$info->gender = $_POST['gender'];
			$info->phoneNo = $_POST['phone_no'];
			$info->mobileNo = $_POST['mobile_no'];
			$info->currentAddress = $_POST['current_address'];
			$info->currentCity = $_POST['current_city'];
			$info->currentProvince = $_POST['current_province'];
			$info->permanentAddress = $_POST['permanent_address'];
			$info->permanentCity = $_POST['permanent_city'];
			$info->permanentProvince = $_POST['permanent_province'];
			$info->civilStatus = $_POST['civil_status'];
			$info->contactPerson = $_POST['contact_person'];
			$info->contactNumber = $_POST['contact_number'];
			$info->contactAddress = $_POST['contact_address'];
			$info->sss = $_POST['sss'];
			$info->tin = $_POST['tin'];
			$info->philhealth = $_POST['philhealth'];
			$info->hdmf = $_POST['hdmf'];
			$info->bloodTypeId = $_POST['blood_type'];
			$info->createdBy = '2';
			$info->modifiedBy = '2';
			$info->dateModified = date('Y-m-d H:i:s');

			DAOFactory::getTblUserInfoOtherDAO()->update($info);


		}
	}

	public function showUserOtherInfo(){

		$data = DAOFactory::getTblUserInfoOtherDAO()->queryByUserId($_POST['userId']); 

		echo json_encode($data);
	}


	public function showEmployee(){

		$data = DAOFactory::getTblUserDAO()->getUserInfo();

		echo json_encode($data);
	}

	function getEnabledLeaveType(){

		$data = DAOFactory::getTblLeaveTypeDAO()->queryByStatus('enabled');

		echo json_encode($data);
	}

	function getLeaveCredits(){

		$data = DAOFactory::getTblLeaveCreditsDAO()->getLeaveCredits();

		echo json_encode($data);
	}

	function getCredits(){

		$data = DAOFactory::getTblLeavePerTypeDAO()->getCredits($_POST['id']);

		echo json_encode($data);
	}

	function showEmployeelist(){

		$data = DAOFactory::getTblUserDAO()->getUserInfo();
		echo json_encode($data);
	}	
	function showEmployeeListUser(){

		$data = DAOFactory::getTblUserDAO()->getUser();
		echo json_encode(self::convert_from_latin1_to_utf8_recursively($data));
	}
	function showUser(){

		$data = DAOFactory::getTblUserDAO()->showUser($_POST['userId']);

		echo json_encode($data);
	}

	function showShift(){
		$data = DAOFactory::getTblShiftDAO()->queryByStatus('enabled');
		echo  json_encode($data);
	}

	function showProvince(){
		$data = DAOFactory::getTblProvincesDAO()->queryAll();
		echo  json_encode($data);
	}

	function showCity(){
		$data = DAOFactory::getTblCityDAO()->queryAll();
		echo json_encode($this->convert_from_latin1_to_utf8_recursively($data));
	}
	public static function convert_from_latin1_to_utf8_recursively($dat)
    {
       if (is_string($dat)) {
          return utf8_encode($dat);
       } elseif (is_array($dat)) {
          $ret = [];
          foreach ($dat as $i => $d) $ret[ $i ] = self::convert_from_latin1_to_utf8_recursively($d);

          return $ret;
       } elseif (is_object($dat)) {
          foreach ($dat as $i => $d) $dat->$i = self::convert_from_latin1_to_utf8_recursively($d);

          return $dat;
       } else {
          return $dat;
       }
    }
	function showAllUsers(){
		$data = DAOFactory::getTblUserDAO()->showUserNames();
		echo json_encode($data);
	}

	function showSubdomains(){
		$data = DAOFactory::getTblSubdomainAccountsDAO()->queryAll();
		echo json_encode($data);
	}

	function showDepartment(){
		$data = DAOFactory::getTblDepartmentDAO()->queryByStatus('enabled');
		echo json_encode($data);
	}
	 function showPosition(){
		$data = DAOFactory::getTblPositionDAO()->queryByStatus('enabled');
		echo json_encode($data);
	}

	function showEmployeeStatus(){
		$data = DAOFactory::getTblEmployeeStatusDAO()->queryByStatus('enabled');
		echo json_encode($data);
	}
	function showEmploymentStatus(){
		$data = DAOFactory::getTblEmploymentStatusDAO()->queryByStatus('enabled');
		echo json_encode($data);
	}
	function showBloodType(){
		$data = DAOFactory::getTblBloodTypeDAO()->queryByStatus('enabled');
		echo json_encode($data);
	}
	function showCompany(){
		$data = DAOFactory::getTblCompanyDAO()->queryByStatus('enabled');
		echo json_encode($data);
	}

	function addUser(){

		$accountId = 0;
		$checkUsername = DAOFactory::getTblUserDAO()->queryByUsername($_POST['username']);
		$checkEmail = DAOFactory::getTblUserInfoDAO()->queryByEmail($_POST['email']);
		if(empty($checkUsername)){

			$accountForm = new Tbluser;
			$accountForm->username = $_POST['username'];
			$accountForm->password = $_POST['password'];
			$accountForm->userType = $_POST['user_type'];
			$accountForm->subdomain = $_POST['subdomain'];
			$accountForm->createdBy = 1;
			$accountForm->modifiedBy = 1;
			$accountForm->dateCreated = date('Y-m-d H:i:s');

				if(empty($checkEmail)){
					$accountId = DAOFactory::getTblUserDAO()->insert($accountForm);
						$data['id'] = $accountId;
						$data['username'] = $_POST['username'];
						$data['password'] =  $_POST['password'];
						$data['user_type'] = $_POST['user_type'];
						$data['subdomain'] = $_POST['subdomain'];
						$data['created_by'] = $this->user['id'];
						$data['modified_by'] = 0;
						$data['date_created'] = date('Y-m-d H:i:s');
						$data['date_modified'] = '';
						if(SERVERTYPE == 'local'){
							Db::insert(DATABASE_SUB_LOCAL,'tbl_user',$data);
							Db2::insert(DATABASE_DTCENTRAL_LOCAL,'tbl_user',$data);
							Db2::insert(DATABASE_SUBDT_LOCAL,'tbl_user',$data);
						} else {
							$subdomain = DAOFactory::getTblSubdomainAccountsDAO()->load($_POST['subdomain']);
							Db::insert($subdomain->database,'tbl_user',$data);

							$subdomainDT = Db2::load(DATABASE_DT_NAME,'tbl_subdomain_accounts',$_POST['subdomain']);
							Db2::insert($subdomainDT['database'],'tbl_user',$data);
							Db2::insert(DATABASE_DT_NAME,'tbl_user',$data);
						}
					echo 1; // success account form
				} else{
					echo 5; exit;			
				}

			

		} else{
			echo 2; exit ; //username exist
		}
		 
		if(empty($checkEmail)){
			$userInfo = new TblUserInfo;
			$userInfo->userId = $accountId;
			$userInfo->positionId = $_POST['position_id'];
			$userInfo->departmentId = $_POST['department'];
			$userInfo->companyIdentification = $_POST['company_id'];
			$userInfo->fname = $_POST['fname'];
			$userInfo->mname = $_POST['mname'];
			$userInfo->lname = $_POST['lname'];
			$userInfo->email = $_POST['email'];
			$userInfo->shiftId = $_POST['schedtype'];
			$userInfo->userDesc = $_POST['user_description'];
			$userInfo->assignedLocation = $_POST['ass_location'];
			$userInfo->employmentStatus = $_POST['employment_status'];
			$userInfo->employeeStatus = $_POST['employee_status'];
			$userInfo->dateHired = $_POST['date_hired'];
			$userInfo->dateRegularization = $_POST['date_regularization'];
			$userInfo->dateResigned = $_POST['date_resigned'];
			$userInfo->createdBy = 1;
			$userInfo->modifiedBy = 1;
			$userInfo->dateCreated = date('Y-m-d H:i:s');
			$id = DAOFactory::getTblUserInfoDAO()->insert($userInfo);

			$data['id'] = $id;
			$data['user_id'] = $accountId;
			$data['position_id'] = $_POST['position_id'];
			$data['department_id'] =  $_POST['department'];
			$data['company_identification'] = $_POST['company_id'];
			$data['fname'] = $_POST['fname'];
			$data['mname'] = $_POST['mname'];
			$data['lname'] = $_POST['lname'];
			$data['email'] =$_POST['email'];
			$data['shift_id'] = $_POST['schedtype'];
			$data['user_desc'] = $_POST['user_description'];
			$data['assigned_location'] = $_POST['ass_location'];
			$data['employment_status'] = $_POST['employment_status'];
			$data['employee_status'] = $_POST['employee_status'];
			$data['date_hired'] = $_POST['date_hired'];
			$data['date_regularization'] = $_POST['date_regularization'];
			$data['date_resigned'] =  $_POST['date_resigned'];
			$data['created_by'] = $this->user['id'];
			$data['modified_by'] = 0;
			$data['date_created'] = date ('Y-m-d H:i:s');
			$data['date_modified'] = '';

			if(SERVERTYPE == 'local'){
				Db::insert(DATABASE_SUB_LOCAL,'tbl_user_info',$data);
				Db2::insert(DATABASE_DTCENTRAL_LOCAL,'tbl_user_info',$data);
				Db2::insert(DATABASE_SUBDT_LOCAL,'tbl_user_info',$data);
			} else {
				$subdomain = DAOFactory::getTblSubdomainAccountsDAO()->load($_POST['subdomain']);
				Db::insert($subdomain->database,'tbl_user_info',$data);

				$subdomainDT = Db2::load(DATABASE_DT_NAME,'tbl_subdomain_accounts',$_POST['subdomain']);
				Db2::insert($subdomainDT['database'],'tbl_user_info',$data);
				Db2::insert(DATABASE_DT_NAME,'tbl_user_info',$data);
			}

			echo 4; //success user info form

		} else {
			echo 5; exit;//email exist
		} 	
		$otherInfoForm = new TblUserInfoOther;
		$otherInfoForm->userId = $accountId;
		$otherInfoForm->bdate = isset($_POST['birth_date']) ? $_POST['birth_date'] : '' ;
		$otherInfoForm->gender = isset($_POST['gender']) ? $_POST['gender'] : '';
		$otherInfoForm->phoneNo = isset($_POST['phone_no']) ? $_POST['phone_no'] : '';
		$otherInfoForm->mobileNo = isset($_POST['mobile_no']) ? $_POST['mobile_no'] : '';
		$otherInfoForm->currentAddress = isset($_POST['current_address']) ? $_POST['current_address'] : '';
		$otherInfoForm->currentCity = isset($_POST['current_city']) ? $_POST['current_city'] : 0;
		$otherInfoForm->currentProvince = isset($_POST['current_province']) ? $_POST['current_province'] : 0;
		$otherInfoForm->permanentAddress = isset($_POST['permanent_address']) ? $_POST['permanent_address'] : 0;
		$otherInfoForm->permanentCity = isset($_POST['permanent_city']) ? $_POST['permanent_city'] : 0;
		$otherInfoForm->permanentProvince = isset($_POST['permanent_province']) ? $_POST['permanent_province'] : 0;
		$otherInfoForm->civilStatus = isset($_POST['civil_status']) ? $_POST['civil_status'] : '' ;
		$otherInfoForm->contactPerson = isset($_POST['contact_person']) ? $_POST['contact_person'] : '' ;
		$otherInfoForm->contactNumber = isset($_POST['contact_number']) ? $_POST['contact_number'] : '';
		$otherInfoForm->contactAddress = isset($_POST['contact_address']) ? $_POST['contact_address'] : '' ;
		$otherInfoForm->sss = isset($_POST['sss']) ? $_POST['sss'] : '';
		$otherInfoForm->tin = isset($_POST['tin_number']) ?  $_POST['tin_number'] : '';
		$otherInfoForm->philhealth = isset($_POST['philhealth']) ? $_POST['philhealth'] : '' ;
		$otherInfoForm->hdmf = isset($_POST['hmdf']) ? $_POST['hmdf'] : '' ;
		$otherInfoForm->bloodTypeId = isset($_POST['blood_type']) ? $_POST['blood_type'] : 0;
		$otherInfoForm->createdBy = 1 ;
		$otherInfoForm->modifiedBy = 1 ;
		$otherInfoForm->dateCreated = date('Y-m-d H:i:s') ;
		$othersId = DAOFactory::getTblUserInfoOtherDAO()->insert($otherInfoForm);

		$data3['id'] = $othersId;
		$data3['user_id'] = $accountId;
		$data3['bdate'] = isset($_POST['birth_date']) ? $_POST['birth_date'] : '' ;
		$data3['gender'] =  isset($_POST['gender']) ? $_POST['gender'] : '';
		$data3['phone_no'] = isset($_POST['phone_no']) ? $_POST['phone_no'] : '';
		$data3['mobile_no'] = isset($_POST['mobile_no']) ? $_POST['mobile_no'] : '';
		$data3['current_address'] = isset($_POST['current_address']) ? $_POST['current_address'] : '';
		$data3['current_city'] = isset($_POST['current_city']) ? $_POST['current_city'] : 0;
		$data3['current_province'] = isset($_POST['current_province']) ? $_POST['current_province'] : '';
		$data3['permanent_address'] = isset($_POST['permanent_address']) ? $_POST['permanent_address'] : 0;
		$data3['permanent_city'] =isset($_POST['permanent_city']) ? $_POST['permanent_city'] : 0;
		$data3['permanent_province'] = isset($_POST['permanent_province']) ? $_POST['permanent_province'] : 0;
		$data3['civil_status'] = isset($_POST['civil_status']) ? $_POST['civil_status'] : '' ;
		$data3['contact_person'] =isset($_POST['contact_person']) ? $_POST['contact_person'] : '' ;
		$data3['contact_number'] =isset($_POST['contact_number']) ? $_POST['contact_number'] : '';
		$data3['contact_address'] = isset($_POST['contact_address']) ? $_POST['contact_address'] : '' ;
		$data3['sss'] = isset($_POST['sss']) ?  $_POST['sss'] : '';
		$data3['tin'] =isset($_POST['tin_number']) ?  $_POST['tin_number'] : '';
		$data3['philhealth'] = isset($_POST['philhealth']) ? $_POST['philhealth'] : '' ;
		$data3['blood_type_id'] = isset($_POST['blood_type']) ? $_POST['blood_type'] : 0;
		$data3['hdmf'] = isset($_POST['hmdf']) ? $_POST['hmdf'] : '' ;
		$data3['created_by'] = $this->user['id'];
		$data3['modified_by'] = 0;
		$data3['date_created'] = date ('Y-m-d H:i:s');
		$data3['date_modified'] = '';
		
		if(SERVERTYPE == 'local'){
			Db::insert(DATABASE_SUB_LOCAL,'tbl_user_info_other',$data3);
		} else {
			$subdomain = DAOFactory::getTblSubdomainAccountsDAO()->load($_POST['subdomain']);
			Db::insert($subdomain->database,'tbl_user_info_other',$data3);
		}

		if(isset($_POST['superior'])){	
			$insertSuperior = new TblSubordinate;
			$insertSuperior->superiorId =  $_POST['superior'];
			$insertSuperior->subordinateId =  $accountId;
			$insertSuperior->createdBy = 1;
			$insertSuperior->modifiedBy = 1;
			$insertSuperior->dateCreated = date('Y-m-d H:i:s');
			$idsub = DAOFactory::getTblSubordinateDAO()->insert($insertSuperior);

			$data4['id'] = $idsub;
			$data4['superior_id'] = $_POST['superior'];
			$data4['subordinate_id'] =  $accountId;
			$data4['created_by'] = $this->user['id'];
			$data4['modified_by'] = 0;
			$data4['date_created'] = date ('Y-m-d H:i:s');
			$data4['date_modified'] = '';

			if(SERVERTYPE == 'local'){
				Db::insert(DATABASE_SUB_LOCAL,'tbl_subordinate',$data4);
			} else {
				$subdomain = DAOFactory::getTblSubdomainAccountsDAO()->load($_POST['subdomain']);
				Db::insert($subdomain->database,'tbl_subordinate',$data4);
			}
		}

		$insertSched = new TblUserSchedule;
		$insertSched->userId = $accountId;
		$insertSched->timeIn =  date("H:i", strtotime($_POST['time_in']));
		$insertSched->timeOut = date("H:i", strtotime($_POST['time_out']));
		$insertSched->schedType = $_POST['schedtype'];
		$insertSched->createdBy = 1;
		$insertSched->modifiedBy = 1;
		$insertSched->dateCreated = date('Y-m-d H:i:s');
		$idSched = DAOFactory::getTblUserScheduleDAO()->insert($insertSched);

		$data5['id'] = $idSched;
		$data5['user_id'] = $accountId;
		$data5['time_in'] = date("H:i", strtotime($_POST['time_in']));
		$data5['time_out'] = date("H:i", strtotime($_POST['time_out']));
		$data5['sched_type'] =$_POST['schedtype'];
		$data5['created_by'] = $this->user['id'];
		$data5['modified_by'] = 0;
		$data5['date_created'] = date ('Y-m-d H:i:s');
		$data5['date_modified'] = '';

		if(SERVERTYPE == 'local'){
			Db::insert(DATABASE_SUB_LOCAL,'tbl_user_schedule',$data5);
			Db2::insert(DATABASE_DTCENTRAL_LOCAL,'tbl_user_schedule',$data5);
			Db2::insert(DATABASE_SUBDT_LOCAL,'tbl_user_schedule',$data5);
		} else {
			$subdomain = DAOFactory::getTblSubdomainAccountsDAO()->load($_POST['subdomain']);
			Db::insert($subdomain->database,'tbl_user_schedule',$data5);

			$subdomainDT = Db2::load(DATABASE_DT_NAME,'tbl_subdomain_accounts',$_POST['subdomain']);
			Db2::insert($subdomainDT['database'],'tbl_user_schedule',$data5);
			Db2::insert(DATABASE_DT_NAME,'tbl_user_schedule',$data5);
		}

		
		// $this->insertUserToDT($_POST,$accountId);

	}
	function insertUserToDT($post,$id){

		$data = array();
		$data['userId'] = $id;
		$data['companyId'] = $post['company_id'];
		$data['username'] = $post['username'];
		$data['password'] = $post['password'];
		$data['firstname'] = $post['fname'];
		$data['midname'] = $post['mname'];
		$data['lastname'] = $post['lname'];
		$data['position'] = $post['user_description'];
		$data['email'] = $post['email'];
		$data['assignedLocation'] = $post['ass_location'];
		$data['userStatus'] = 0;
		$data['department'] = 0;
		$data['costCenter'] = 0;
		$data['company'] = 0;
		$data['dateRegistered'] = date('Y-m-d H:i:s');
		$data['updatedAt'] = "0000-00-00 00:00:00";
		$dataposted['tblUser'] = $data;

		if(SERVERTYPE == 'local'){
			// Db::insert(DATABASE_SUB_LOCAL,'tbl_user_schedule',$data5);
		} else {
			$subdomain = DAOFactory::getTblSubdomainAccountsDAO()->load($post['subdomain']);
			Controller::send('http://'.$subdomain->username.'.'.DOMAIN_DT.'/user/apiInsertUser',$dataposted);
		}
	}

	function updateUserToDT($post){

		$data = array();
		$data['userId'] = $post['userId'];
		$data['companyId'] = $post['company_id'];
		$data['firstname'] = $post['fname'];
		$data['midname'] = $post['mname'];
		$data['lastname'] = $post['lname'];
		$data['position'] = $post['user_description'];
		$data['email'] = $post['email'];
		$data['assignedLocation'] = $post['ass_location'];
		$dataposted['tblUser'] = $data;

		if(SERVERTYPE == 'local'){
			// Db::insert(DATABASE_SUB_LOCAL,'tbl_user_schedule',$data5);
		} else {
			$subdomain = DAOFactory::getTblSubdomainAccountsDAO()->load($post['subdomain']);
			Controller::send('http://'.$subdomain->username.'.'.DOMAIN_DT.'/user/apiUpdateUser',$dataposted);
		}
	}

	function updateUser(){

		$user = DAOFactory::getTblUserDAO()->load($_POST['userId']);
		$user->password = $_POST['password'];
		$user->subdomain = $_POST['subdomain'];
		$user->userType = $_POST['user_type'];
		$user->modifiedBy = 1;
		$user->dateModified = date('Y-m-d H:i:s');
		DAOFactory::getTblUserDAO()->update($user);

		$data['username'] = $_POST['username'];
		$data['password'] =  $_POST['password'];
		$data['user_type'] = $_POST['user_type'];
		$data['subdomain'] = $_POST['subdomain'];
		$data['created_by'] = $this->user['id'];
		$data['modified_by'] = $this->user['id'];
		$data['date_created'] = $user->dateCreated;
		$data['date_modified'] = date('Y-m-d H:i:s');
		$data['id'] = $user->id;

		if(SERVERTYPE == 'local'){
			Db::update(DATABASE_SUB_LOCAL,'tbl_user',$data);
			Db2::update(DATABASE_DTCENTRAL_LOCAL,'tbl_user',$data);
			Db2::update(DATABASE_SUBDT_LOCAL,'tbl_user',$data);
		} else {
			$subdomain = DAOFactory::getTblSubdomainAccountsDAO()->load($_POST['subdomain']);
			Db::update($subdomain->database,'tbl_user',$data);

			$subdomainDT = Db2::load(DATABASE_DT_NAME,'tbl_subdomain_accounts',$_POST['subdomain']);
			Db2::update($subdomainDT['database'],'tbl_user',$data);
			Db2::update(DATABASE_DT_NAME,'tbl_user',$data);
		}




		$userInfo = DAOFactory::getTblUserInfoDAO()->queryByUserId($_POST['userId']);
		if(!empty($userInfo)){
			$userInfo[0]->positionId = $_POST['position_id'];
			$userInfo[0]->departmentId = $_POST['department'];
			$userInfo[0]->company_id = $_POST['company_id'];
			$userInfo[0]->fname = $_POST['fname'];
			$userInfo[0]->mname = $_POST['mname'];
			$userInfo[0]->lname = $_POST['lname'];
			$userInfo[0]->email = $_POST['email'];
			$userInfo[0]->dep = $_POST['email'];
			$userInfo[0]->userDesc = $_POST['user_description'];
			$userInfo[0]->shiftId = $_POST['schedtype'];
			$userInfo[0]->assignedLocation = $_POST['ass_location'];
			$userInfo[0]->employmentStatus = $_POST['employment_status'];
			$userInfo[0]->employeeStatus = $_POST['employee_status'];
			$userInfo[0]->dateHired = $_POST['date_hired'];
			$userInfo[0]->dateRegularization = $_POST['date_regularization'];
			$userInfo[0]->dateResigned = $_POST['date_resigned'];
			$userInfo[0]->modifiedBy = 1;
			$userInfo[0]->dateModified = date('Y-m-d H:i:s');
			DAOFactory::getTblUserInfoDAO()->update($userInfo[0]);

			$data['user_id'] = $userInfo[0]->userId;
			$data['position_id'] = $_POST['position_id'];
			$data['department_id'] =  $_POST['department'];
			$data['company_identification'] = $_POST['company_id'];
			$data['fname'] = $_POST['fname'];
			$data['mname'] = $_POST['mname'];
			$data['lname'] = $_POST['lname'];
			$data['email'] =$_POST['email'];
			$data['shift_id'] = $_POST['schedtype'];
			$data['user_desc'] = $_POST['user_description'];
			$data['assigned_location'] = $_POST['ass_location'];
			$data['employment_status'] = $_POST['employment_status'];
			$data['employee_status'] = $_POST['employee_status'];
			$data['date_hired'] = $_POST['date_hired'];
			$data['date_regularization'] = $_POST['date_regularization'];
			$data['date_resigned'] =  $_POST['date_resigned'];
			$data['created_by'] = $this->user['id'];
			$data['modified_by'] = $this->user['id'];
			$data['date_created'] = $userInfo[0]->dateCreated;
			$data['date_modified'] =  date ('Y-m-d H:i:s');
			$data['id'] = $userInfo[0]->id;

			if(SERVERTYPE == 'local'){
				Db::update(DATABASE_SUB_LOCAL,'tbl_user_info',$data);
				Db2::update(DATABASE_DTCENTRAL_LOCAL,'tbl_user_info',$data);
				Db2::update(DATABASE_SUBDT_LOCAL,'tbl_user_info',$data);
			} else {
				$subdomain = DAOFactory::getTblSubdomainAccountsDAO()->load($_POST['subdomain']);
				Db::update($subdomain->database,'tbl_user_info',$data);

				$subdomainDT = Db2::load(DATABASE_DT_NAME,'tbl_subdomain_accounts',$_POST['subdomain']);
				Db2::update($subdomainDT['database'],'tbl_user_info',$data);
				Db2::update(DATABASE_DT_NAME,'tbl_user_info',$data);
			}
		} else {
			$userInfo = new TblUserInfo;
			$userInfo->userId = $_POST['userId'];
			$userInfo->positionId = $_POST['position_id'];
			$userInfo->departmentId = $_POST['department'];
			$userInfo->companyIdentification = $_POST['company_id'];
			$userInfo->fname = $_POST['fname'];
			$userInfo->mname = $_POST['mname'];
			$userInfo->lname = $_POST['lname'];
			$userInfo->email = $_POST['email'];
			$userInfo->shiftId = $_POST['schedtype'];
			$userInfo->userDesc = $_POST['user_description'];
			$userInfo->assignedLocation = $_POST['ass_location'];
			$userInfo->employmentStatus = $_POST['employment_status'];
			$userInfo->employeeStatus = $_POST['employee_status'];
			$userInfo->dateHired = $_POST['date_hired'];
			$userInfo->dateRegularization = $_POST['date_regularization'];
			$userInfo->dateResigned = $_POST['date_resigned'];
			$userInfo->createdBy = 1;
			$userInfo->modifiedBy = 1;
			$userInfo->dateCreated = date('Y-m-d H:i:s');
			$id = DAOFactory::getTblUserInfoDAO()->insert($userInfo);

			$data['id'] = $id;
			$data['user_id'] = $_POST['userId'];
			$data['position_id'] = $_POST['position_id'];
			$data['department_id'] =  $_POST['department'];
			$data['company_identification'] = $_POST['company_id'];
			$data['fname'] = $_POST['fname'];
			$data['mname'] = $_POST['mname'];
			$data['lname'] = $_POST['lname'];
			$data['email'] =$_POST['email'];
			$data['shift_id'] = $_POST['schedtype'];
			$data['user_desc'] = $_POST['user_description'];
			$data['assigned_location'] = $_POST['ass_location'];
			$data['employment_status'] = $_POST['employment_status'];
			$data['employee_status'] = $_POST['employee_status'];
			$data['date_hired'] = $_POST['date_hired'];
			$data['date_regularization'] = $_POST['date_regularization'];
			$data['date_resigned'] =  $_POST['date_resigned'];
			$data['created_by'] = $this->user['id'];
			$data['modified_by'] = 0;
			$data['date_created'] = date ('Y-m-d H:i:s');
			$data['date_modified'] = '';

			if(SERVERTYPE == 'local'){
				Db::insert(DATABASE_SUB_LOCAL,'tbl_user_info',$data);
				Db2::insert(DATABASE_DTCENTRAL_LOCAL,'tbl_user_info',$data);
				Db2::insert(DATABASE_SUBDT_LOCAL,'tbl_user_info',$data);
			} else {
				$subdomain = DAOFactory::getTblSubdomainAccountsDAO()->load($_POST['subdomain']);
				Db::insert($subdomain->database,'tbl_user_info',$data);

				$subdomainDT = Db2::load(DATABASE_DT_NAME,'tbl_subdomain_accounts',$_POST['subdomain']);
				Db2::insert($subdomainDT['database'],'tbl_user_info',$data);
				Db2::insert(DATABASE_DT_NAME,'tbl_user_info',$data);
			}
		}




		$otherInfoForm = DAOFactory::getTblUserInfoOtherDAO(0)->queryByUserId($_POST['userId']);
		if(!empty($otherInfoForm)){

			$otherInfoForm[0]->bdate = isset($_POST['birth_date']) ? $_POST['birth_date'] : '' ;
			$otherInfoForm[0]->gender = isset($_POST['gender']) ? $_POST['gender'] : '';
			$otherInfoForm[0]->phoneNo = isset($_POST['phone_no']) ? $_POST['phone_no'] : '';
			$otherInfoForm[0]->mobileNo = isset($_POST['mobile_no']) ? $_POST['mobile_no'] : '';
			$otherInfoForm[0]->currentAddress = isset($_POST['current_address']) ? $_POST['current_address'] : '';
			$otherInfoForm[0]->currentCity = isset($_POST['current_city']) ? $_POST['current_city'] : 0;
			$otherInfoForm[0]->currentProvince = isset($_POST['current_province']) ? $_POST['current_province'] : 0;
			$otherInfoForm[0]->permanentAddress = isset($_POST['permanent_address']) ? $_POST['permanent_address'] : 0;
			$otherInfoForm[0]->permanentCity = isset($_POST['permanent_city']) ? $_POST['permanent_city'] : 0;
			$otherInfoForm[0]->permanentProvince = isset($_POST['permanent_province']) ? $_POST['permanent_province'] : 0;
			$otherInfoForm[0]->civilStatus = isset($_POST['civil_status']) ? $_POST['civil_status'] : '' ;
			$otherInfoForm[0]->contactPerson = isset($_POST['contact_person']) ? $_POST['contact_person'] : '' ;
			$otherInfoForm[0]->contactNumber = isset($_POST['contact_number']) ? $_POST['contact_number'] : '';
			$otherInfoForm[0]->contactAddress = isset($_POST['contact_address']) ? $_POST['contact_address'] : '' ;
			$otherInfoForm[0]->sss = isset($_POST['sss']) ? $_POST['sss'] : '';
			$otherInfoForm[0]->tin = isset($_POST['tin_number']) ?  $_POST['tin_number'] : '';
			$otherInfoForm[0]->philhealth = isset($_POST['philhealth']) ? $_POST['philhealth'] : '' ;
			$otherInfoForm[0]->hmdf = isset($_POST['hmdf']) ? $_POST['hmdf'] : '' ;
			$otherInfoForm[0]->bloodTypeId = isset($_POST['blood_type']) ? $_POST['blood_type'] : 0;
			$otherInfoForm[0]->modifiedBy = 1 ;
			$otherInfoForm[0]->dateModified = date('Y-m-d H:i:s') ;
			DAOFactory::getTblUserInfoOtherDAO()->update($otherInfoForm[0]);

			

			$data6['user_id'] = $otherInfoForm[0]->userId;
			$data6['bdate'] = isset($_POST['birth_date']) ? $_POST['birth_date'] : '' ;
			$data6['gender'] =  isset($_POST['gender']) ? $_POST['gender'] : '';
			$data6['phone_no'] = isset($_POST['phone_no']) ? $_POST['phone_no'] : '';
			$data6['mobile_no'] = isset($_POST['mobile_no']) ? $_POST['mobile_no'] : '';
			$data6['current_address'] = isset($_POST['current_address']) ? $_POST['current_address'] : '';
			$data6['current_city'] = isset($_POST['current_city']) ? $_POST['current_city'] : 0;
			$data6['current_province'] = isset($_POST['current_province']) ? $_POST['current_province'] : '';
			$data6['permanent_address'] = isset($_POST['permanent_address']) ? $_POST['permanent_address'] : 0;
			$data6['permanent_city'] =isset($_POST['permanent_city']) ? $_POST['permanent_city'] : 0;
			$data6['permanent_province'] = isset($_POST['permanent_province']) ? $_POST['permanent_province'] : 0;
			$data6['civil_status'] = isset($_POST['civil_status']) ? $_POST['civil_status'] : '' ;
			$data6['contact_person'] =isset($_POST['contact_person']) ? $_POST['contact_person'] : '' ;
			$data6['contact_number'] =isset($_POST['contact_number']) ? $_POST['contact_number'] : '';
			$data6['contact_address'] = isset($_POST['contact_address']) ? $_POST['contact_address'] : '' ;
			$data6['sss'] = isset($_POST['sss']) ?  $_POST['sss'] : '';
			$data6['tin'] =isset($_POST['tin_number']) ?  $_POST['tin_number'] : '';
			$data6['philhealth'] = isset($_POST['philhealth']) ? $_POST['philhealth'] : '' ;
			$data6['blood_type_id'] = isset($_POST['blood_type']) ? $_POST['blood_type'] : 0;
			$data6['hdmf'] = isset($_POST['hmdf']) ? $_POST['hmdf'] : '' ;
			$data6['created_by'] = $otherInfoForm[0]->createdBy;
			$data6['modified_by'] =$this->user['id'];
			$data6['date_created'] = $otherInfoForm[0]->dateCreated;
			$data6['date_modified'] =  date ('Y-m-d H:i:s');
			$data6['id'] = $otherInfoForm[0]->id;
			// print_r($data6);
			if(SERVERTYPE == 'local'){
				Db::update(DATABASE_SUB_LOCAL,'tbl_user_info_other',$data6);
			} else {
				$subdomain = DAOFactory::getTblSubdomainAccountsDAO()->load($_POST['subdomain']);
				Db::update($subdomain->database,'tbl_user_info_other',$data6);
			}

		} else {
			$otherInfoForm = new TblUserInfoOther;
			$otherInfoForm->userId = $_POST['userId'];
			$otherInfoForm->bdate = isset($_POST['birth_date']) ? $_POST['birth_date'] : '' ;
			$otherInfoForm->gender = isset($_POST['gender']) ? $_POST['gender'] : '';
			$otherInfoForm->phoneNo = isset($_POST['phone_no']) ? $_POST['phone_no'] : '';
			$otherInfoForm->mobileNo = isset($_POST['mobile_no']) ? $_POST['mobile_no'] : '';
			$otherInfoForm->currentAddress = isset($_POST['current_address']) ? $_POST['current_address'] : '';
			$otherInfoForm->currentCity = isset($_POST['current_city']) ? $_POST['current_city'] : 0;
			$otherInfoForm->currentProvince = isset($_POST['current_province']) ? $_POST['current_province'] : 0;
			$otherInfoForm->permanentAddress = isset($_POST['permanent_address']) ? $_POST['permanent_address'] : 0;
			$otherInfoForm->permanentCity = isset($_POST['permanent_city']) ? $_POST['permanent_city'] : 0;
			$otherInfoForm->permanentProvince = isset($_POST['permanent_province']) ? $_POST['permanent_province'] : 0;
			$otherInfoForm->civilStatus = isset($_POST['civil_status']) ? $_POST['civil_status'] : '' ;
			$otherInfoForm->contactPerson = isset($_POST['contact_person']) ? $_POST['contact_person'] : '' ;
			$otherInfoForm->contactNumber = isset($_POST['contact_number']) ? $_POST['contact_number'] : '';
			$otherInfoForm->contactAddress = isset($_POST['contact_address']) ? $_POST['contact_address'] : '' ;
			$otherInfoForm->sss = isset($_POST['sss']) ? $_POST['sss'] : '';
			$otherInfoForm->tin = isset($_POST['tin_number']) ?  $_POST['tin_number'] : '';
			$otherInfoForm->philhealth = isset($_POST['philhealth']) ? $_POST['philhealth'] : '' ;
			$otherInfoForm->hdmf = isset($_POST['hmdf']) ? $_POST['hmdf'] : '' ;
			$otherInfoForm->bloodTypeId = isset($_POST['blood_type']) ? $_POST['blood_type'] : 0;
			$otherInfoForm->createdBy = 1 ;
			$otherInfoForm->modifiedBy = 1 ;
			$otherInfoForm->dateCreated = date('Y-m-d H:i:s') ;
			$othersId = DAOFactory::getTblUserInfoOtherDAO()->insert($otherInfoForm);

			$data3['id'] = $othersId;
			$data3['user_id'] = $accountId;
			$data3['bdate'] = isset($_POST['birth_date']) ? $_POST['birth_date'] : '' ;
			$data3['gender'] =  isset($_POST['gender']) ? $_POST['gender'] : '';
			$data3['phone_no'] = isset($_POST['phone_no']) ? $_POST['phone_no'] : '';
			$data3['mobile_no'] = isset($_POST['mobile_no']) ? $_POST['mobile_no'] : '';
			$data3['current_address'] = isset($_POST['current_address']) ? $_POST['current_address'] : '';
			$data3['current_city'] = isset($_POST['current_city']) ? $_POST['current_city'] : 0;
			$data3['current_province'] = isset($_POST['current_province']) ? $_POST['current_province'] : '';
			$data3['permanent_address'] = isset($_POST['permanent_address']) ? $_POST['permanent_address'] : 0;
			$data3['permanent_city'] =isset($_POST['permanent_city']) ? $_POST['permanent_city'] : 0;
			$data3['permanent_province'] = isset($_POST['permanent_province']) ? $_POST['permanent_province'] : 0;
			$data3['civil_status'] = isset($_POST['civil_status']) ? $_POST['civil_status'] : '' ;
			$data3['contact_person'] =isset($_POST['contact_person']) ? $_POST['contact_person'] : '' ;
			$data3['contact_number'] =isset($_POST['contact_number']) ? $_POST['contact_number'] : '';
			$data3['contact_address'] = isset($_POST['contact_address']) ? $_POST['contact_address'] : '' ;
			$data3['sss'] = isset($_POST['sss']) ?  $_POST['sss'] : '';
			$data3['tin'] =isset($_POST['tin_number']) ?  $_POST['tin_number'] : '';
			$data3['philhealth'] = isset($_POST['philhealth']) ? $_POST['philhealth'] : '' ;
			$data3['blood_type_id'] = isset($_POST['blood_type']) ? $_POST['blood_type'] : 0;
			$data3['hdmf'] = isset($_POST['hmdf']) ? $_POST['hmdf'] : '' ;
			$data3['created_by'] = $this->user['id'];
			$data3['modified_by'] = 0;
			$data3['date_created'] = date ('Y-m-d H:i:s');
			$data3['date_modified'] = '';
			
			if(SERVERTYPE == 'local'){
				Db::insert(DATABASE_SUB_LOCAL,'tbl_user_info_other',$data3);
			} else {
				$subdomain = DAOFactory::getTblSubdomainAccountsDAO()->load($_POST['subdomain']);
				Db::insert($subdomain->database,'tbl_user_info_other',$data3);
			}
		}

		if(isset($_POST['superior'])){

			
			
			$subordinate = DAOFactory::getTblSubordinateDAO()->queryBySubordinateId($_POST['userId']);

			if(!empty($subordinate)){	
				$subordinate[0]->superiorId = $_POST['superior'];
				DAOFactory::getTblSubordinateDAO()->update($subordinate[0]);

				$data4['superior_id'] = $_POST['superior'];
				$data4['subordinate_id'] =  $subordinate[0]->subordinateId;
				$data4['created_by'] = $subordinate[0]->createdBy;
				$data4['modified_by'] = $this->user['id'];
				$data4['date_created'] = $subordinate[0]->dateCreated;
				$data4['date_modified'] = date ('Y-m-d H:i:s');
				$data4['id'] = $subordinate[0]->id;

				if(SERVERTYPE == 'local'){
					Db::update(DATABASE_SUB_LOCAL,'tbl_subordinate',$data4);
				} else {
					$subdomain = DAOFactory::getTblSubdomainAccountsDAO()->load($_POST['subdomain']);
					Db::update($subdomain->database,'tbl_subordinate',$data4);
				}
			} else {
				$insertSuperior = new TblSubordinate;
				$insertSuperior->superiorId =  $_POST['superior'];
				$insertSuperior->subordinateId =  $_POST['userId'];
				$insertSuperior->createdBy = 1;
				$insertSuperior->modifiedBy = 1;
				$insertSuperior->dateCreated = date('Y-m-d H:i:s');
				$idsub = DAOFactory::getTblSubordinateDAO()->insert($insertSuperior);

				$data4['id'] = $idsub;
				$data4['superior_id'] = $_POST['superior'];
				$data4['subordinate_id'] =  $_POST['userId'];
				$data4['created_by'] = $this->user['id'];
				$data4['modified_by'] = 0;
				$data4['date_created'] = date ('Y-m-d H:i:s');
				$data4['date_modified'] = '';

				if(SERVERTYPE == 'local'){
					Db::insert(DATABASE_SUB_LOCAL,'tbl_subordinate',$data4);
				} else {
					$subdomain = DAOFactory::getTblSubdomainAccountsDAO()->load($_POST['subdomain']);
					Db::insert($subdomain->database,'tbl_subordinate',$data4);
				}
			}

		}

		$userSched = DAOFactory::getTblUserScheduleDAO()->queryByUserId($_POST['userId']);
		if(!empty($userSched)){

			$userSched[0]->timeIn =  date("H:i", strtotime($_POST['time_in']));
			$userSched[0]->timeOut =  date("H:i", strtotime($_POST['time_out']));
			$userSched[0]->schedType =  $_POST['schedtype'];
			DAOFactory::getTblUserScheduleDAO()->update($userSched[0]);

			$data5['user_id'] = $userSched[0]->userId;
			$data5['time_in'] = date("H:i", strtotime($_POST['time_in']));
			$data5['time_out'] = date("H:i", strtotime($_POST['time_out']));
			$data5['sched_type'] =$_POST['schedtype'];
			$data5['created_by'] = $userSched[0]->createdBy;
			$data5['modified_by'] = $this->user['id'];
			$data5['date_created'] = $userSched[0]->dateCreated;
			$data5['date_modified'] =  date ('Y-m-d H:i:s');
			$data5['id'] = $userSched[0]->id;

			if(SERVERTYPE == 'local'){
				Db::update(DATABASE_SUB_LOCAL,'tbl_user_schedule',$data5);
				Db2::update(DATABASE_DTCENTRAL_LOCAL,'tbl_user_schedule',$data5);
				Db2::update(DATABASE_SUBDT_LOCAL,'tbl_user_schedule',$data5);
			} else {
				$subdomain = DAOFactory::getTblSubdomainAccountsDAO()->load($_POST['subdomain']);
				Db::update($subdomain->database,'tbl_user_schedule',$data5);

				$subdomainDT = Db2::load(DATABASE_DT_NAME,'tbl_subdomain_accounts',$_POST['subdomain']);
				Db2::update($subdomainDT['database'],'tbl_user_schedule',$data5);
				Db2::update(DATABASE_DT_NAME,'tbl_user_schedule',$data5);
			}
		} else {
			$insertSched = new TblUserSchedule;
			$insertSched->userId = $accountId;
			$insertSched->timeIn =  date("H:i", strtotime($_POST['time_in']));
			$insertSched->timeOut = date("H:i", strtotime($_POST['time_out']));
			$insertSched->schedType = $_POST['schedtype'];
			$insertSched->createdBy = 1;
			$insertSched->modifiedBy = 1;
			$insertSched->dateCreated = date('Y-m-d H:i:s');
			$idSched = DAOFactory::getTblUserScheduleDAO()->insert($insertSched);

			$data5['id'] = $idSched;
			$data5['user_id'] = $accountId;
			$data5['time_in'] = date("H:i", strtotime($_POST['time_in']));
			$data5['time_out'] = date("H:i", strtotime($_POST['time_out']));
			$data5['sched_type'] =$_POST['schedtype'];
			$data5['created_by'] = $this->user['id'];
			$data5['modified_by'] = 0;
			$data5['date_created'] = date ('Y-m-d H:i:s');
			$data5['date_modified'] = '';

			if(SERVERTYPE == 'local'){
				Db::insert(DATABASE_SUB_LOCAL,'tbl_user_schedule',$data5);
				Db2::insert(DATABASE_DTCENTRAL_LOCAL,'tbl_user_schedule',$data5);
				Db2::insert(DATABASE_SUBDT_LOCAL,'tbl_user_schedule',$data5);
			} else {
				$subdomain = DAOFactory::getTblSubdomainAccountsDAO()->load($_POST['subdomain']);
				Db::insert($subdomain->database,'tbl_user_schedule',$data5);

				$subdomainDT = Db2::load(DATABASE_DT_NAME,'tbl_subdomain_accounts',$_POST['subdomain']);
				Db2::insert($subdomainDT['database'],'tbl_user_schedule',$data5);
				Db2::insert(DATABASE_DT_NAME,'tbl_user_schedule',$data5);
			}
		}

		// $this->updateUserToDT($_POST);
	}
}
?>