<?php
class Calendar_model extends Model
{
	protected $user;

	function __construct()
	{
		parent::__construct();
		$this->user = Session::getSession('user');
	}
	function showHoliday(){
		$data = DAOFactory::getTblHolidayDAO()->queryByStatus('enabled');
		echo json_encode($data);
	}
	public function addEvent(){
		$toTime = date('H:i:s' ,strtotime($_POST['toTime']));
		$time = (strtotime($_POST['fromTime']) - strtotime($_POST['toTime']))/60*-1;
		// echo $time/60; exit;
		// exit;
		$insert = new TblWorkingCalendar;
		$insert->holidayId = $_POST['workingType'] == 'holiday' ? $_POST['holiday'] : 0;
		$insert->totalHoursPerDay = ($toTime > '12:00:00') ? ($time/60) - 1 : $time/60;
		$insert->remarks = isset($_POST['remarks']) ? $_POST['remarks'] : '';
		$insert->workingType = $_POST['workingType'];
		$insert->workingDate = $_POST['date'];
		$insert->fromTime = isset($_POST['fromTime']) ? date('H:i:s', strtotime($_POST['fromTime'])) : '00:00:00';
		$insert->toTime = isset($_POST['toTime']) ? date('H:i:s', strtotime($_POST['toTime'])) : '00:00:00';
		$insert->createdBy = $this->user['id'];
		$insert->modifiedBy = 0;
		$id = DAOFactory::getTblWorkingCalendarDAO()->insert($insert);

		$data['id'] = $id;
		$data['holiday_id'] = $_POST['workingType'] == 'holiday' ? $_POST['holiday'] : 0;
		$data['total_hours_per_day'] = ($toTime > '12:00:00') ? ($time/60) - 1 : $time/60;
		$data['remarks'] = isset($_POST['remarks']) ? $_POST['remarks'] : '';
		$data['working_type'] = $_POST['workingType'];
		$data['working_date'] = $_POST['date'];
		$data['fromTime'] = isset($_POST['fromTime']) ? date('H:i:s', strtotime($_POST['fromTime'])) : '00:00:00';
		$data['toTime'] = isset($_POST['toTime']) ? date('H:i:s', strtotime($_POST['toTime'])) : '00:00:00';
		$data['created_by'] = $this->user['id']; 
		$data['modified_by'] = 0;
		$data['date_created'] = date('Y-m-d H:i:s');
		$data['date_modified'] = '';

		if(SERVERTYPE == 'local'){
			Db::insert(DATABASE_SUB_LOCAL,'tbl_working_calendar',$data);
		} else {
			$subdomain = DAOFactory::getTblSubdomainAccountsDAO()->queryAll();
			foreach ($subdomain as $key => $each) {
				Db::insert($each->database,'tbl_working_calendar',$data);
			}
		}
	}
	public function updateEvent(){
		$toTime = date('H:i:s' ,strtotime($_POST['toTime']));
		$time = (strtotime($_POST['fromTime']) - strtotime($_POST['toTime']))/60*-1;
		$update = DAOFactory::getTblWorkingCalendarDAO()->queryByWorkingDate($_POST['date']);
		$update[0]->holidayId = $_POST['workingType'] == 'holiday' ? $_POST['holiday'] : 0;
		$update[0]->totalHoursPerDay = ($toTime > '12:00:00') ? ($time/60) - 1 : $time/60;
		$update[0]->remarks = isset($_POST['remarks']) ? $_POST['remarks'] : '';
		$update[0]->workingType = $_POST['workingType'];
		$update[0]->workingDate = $_POST['date'];
		$update[0]->fromTime = isset($_POST['fromTime']) ? date('H:i:s', strtotime($_POST['fromTime'])) : '00:00:00';
		$update[0]->toTime = isset($_POST['toTime']) ? date('H:i:s', strtotime($_POST['toTime'])) : '00:00:00';
		$update[0]->modifiedBy = 1;
		$update[0]->dateModified = date('Y-m-d H:i:s');
		DAOFactory::getTblWorkingCalendarDAO()->update($update[0]);


		$data['holiday_id'] = $_POST['workingType'] == 'holiday' ? $_POST['holiday'] : 0;
		$data['total_hours_per_day'] = ($toTime > '12:00:00') ? ($time/60) - 1 : $time/60;
		$data['remarks'] = isset($_POST['remarks']) ? $_POST['remarks'] : '';
		$data['working_type'] = $_POST['workingType'];
		$data['working_date'] = $_POST['date'];
		$data['fromTime'] = isset($_POST['fromTime']) ? date('H:i:s', strtotime($_POST['fromTime'])) : '00:00:00';
		$data['toTime'] = isset($_POST['toTime']) ? date('H:i:s', strtotime($_POST['toTime'])) : '00:00:00';
		$data['created_by'] = $this->user['id']; 
		$data['modified_by'] = 0;
		$data['date_created'] = $update[0]->createdBy;
		$data['date_modified'] = date('Y-m-d H:i:s');
		$data['id'] = $update[0]->id;

		if(SERVERTYPE == 'local'){
			Db::update(DATABASE_SUB_LOCAL,'tbl_working_calendar',$data);
		} else {
			$subdomain = DAOFactory::getTblSubdomainAccountsDAO()->queryAll();
			foreach ($subdomain as $key => $each) {
				Db::update($each->database,'tbl_working_calendar',$data);
			}
		}

	}
	public function getEventByDate(){
		$date = $_POST['date'];
		$data = DAOFactory::getTblWorkingCalendarDAO()->queryByWorkingDate($date);
		echo json_encode($data);
	}
	public function getEventByDateHoliday(){
		$date = $_POST['date'];
		$data = DAOFactory::getTblWorkingCalendarDAO()->getEventByDate($date);
		echo json_encode($data);
	}
}
?>