<?php
/**
 * Class that operate on table 'tbl_user_module_access'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2017-12-13 14:52
 */
class TblUserModuleAccessMySqlDAO implements TblUserModuleAccessDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @return TblUserModuleAccessMySql 
	 */
	public function load($id){
		$sql = 'SELECT * FROM tbl_user_module_access WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($id);
		return $this->getRow($sqlQuery);
	}

	/**
	 * Get all records from table
	 */
	public function queryAll(){
		$sql = 'SELECT * FROM tbl_user_module_access';
		$sqlQuery = new SqlQuery($sql);
		return $this->getList($sqlQuery);
	}
	
	/**
	 * Get all records from table ordered by field
	 *
	 * @param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn){
		$sql = 'SELECT * FROM tbl_user_module_access ORDER BY '.$orderColumn;
		$sqlQuery = new SqlQuery($sql);
		return $this->getList($sqlQuery);
	}
	
	/**
 	 * Delete record from table
 	 * @param tblUserModuleAcces primary key
 	 */
	public function delete($id){
		$sql = 'DELETE FROM tbl_user_module_access WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($id);
		return $this->executeUpdate($sqlQuery);
	}
	
	/**
 	 * Insert record to table
 	 *
 	 * @param TblUserModuleAccessMySql tblUserModuleAcces
 	 */
	public function insert($tblUserModuleAcces){
		$sql = 'INSERT INTO tbl_user_module_access (module_id, user_id, created_by, modified_by, date_modified, date_created) VALUES (?, ?, ?, ?, ?, ?)';
		$sqlQuery = new SqlQuery($sql);
		
		$sqlQuery->setNumber($tblUserModuleAcces->moduleId);
		$sqlQuery->setNumber($tblUserModuleAcces->userId);
		$sqlQuery->setNumber($tblUserModuleAcces->createdBy);
		$sqlQuery->setNumber($tblUserModuleAcces->modifiedBy);
		$sqlQuery->set($tblUserModuleAcces->dateModified);
		$sqlQuery->set($tblUserModuleAcces->dateCreated);

		$id = $this->executeInsert($sqlQuery);	
		$tblUserModuleAcces->id = $id;
		return $id;
	}
	
	/**
 	 * Update record in table
 	 *
 	 * @param TblUserModuleAccessMySql tblUserModuleAcces
 	 */
	public function update($tblUserModuleAcces){
		$sql = 'UPDATE tbl_user_module_access SET module_id = ?, user_id = ?, created_by = ?, modified_by = ?, date_modified = ?, date_created = ? WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		
		$sqlQuery->setNumber($tblUserModuleAcces->moduleId);
		$sqlQuery->setNumber($tblUserModuleAcces->userId);
		$sqlQuery->setNumber($tblUserModuleAcces->createdBy);
		$sqlQuery->setNumber($tblUserModuleAcces->modifiedBy);
		$sqlQuery->set($tblUserModuleAcces->dateModified);
		$sqlQuery->set($tblUserModuleAcces->dateCreated);

		$sqlQuery->setNumber($tblUserModuleAcces->id);
		return $this->executeUpdate($sqlQuery);
	}

	/**
 	 * Delete all rows
 	 */
	public function clean(){
		$sql = 'DELETE FROM tbl_user_module_access';
		$sqlQuery = new SqlQuery($sql);
		return $this->executeUpdate($sqlQuery);
	}

	public function queryByModuleId($value){
		$sql = 'SELECT * FROM tbl_user_module_access WHERE module_id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByUserId($value){
		$sql = 'SELECT * FROM tbl_user_module_access WHERE user_id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByCreatedBy($value){
		$sql = 'SELECT * FROM tbl_user_module_access WHERE created_by = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByModifiedBy($value){
		$sql = 'SELECT * FROM tbl_user_module_access WHERE modified_by = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByDateModified($value){
		$sql = 'SELECT * FROM tbl_user_module_access WHERE date_modified = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByDateCreated($value){
		$sql = 'SELECT * FROM tbl_user_module_access WHERE date_created = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}


	public function deleteByModuleId($value){
		$sql = 'DELETE FROM tbl_user_module_access WHERE module_id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByUserId($value){
		$sql = 'DELETE FROM tbl_user_module_access WHERE user_id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByCreatedBy($value){
		$sql = 'DELETE FROM tbl_user_module_access WHERE created_by = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByModifiedBy($value){
		$sql = 'DELETE FROM tbl_user_module_access WHERE modified_by = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByDateModified($value){
		$sql = 'DELETE FROM tbl_user_module_access WHERE date_modified = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByDateCreated($value){
		$sql = 'DELETE FROM tbl_user_module_access WHERE date_created = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}


	
	/**
	 * Read row
	 *
	 * @return TblUserModuleAccessMySql 
	 */
	protected function readRow($row){
		$tblUserModuleAcces = new TblUserModuleAcces();
		
		$tblUserModuleAcces->id = $row['id'];
		$tblUserModuleAcces->moduleId = $row['module_id'];
		$tblUserModuleAcces->userId = $row['user_id'];
		$tblUserModuleAcces->createdBy = $row['created_by'];
		$tblUserModuleAcces->modifiedBy = $row['modified_by'];
		$tblUserModuleAcces->dateModified = $row['date_modified'];
		$tblUserModuleAcces->dateCreated = $row['date_created'];

		return $tblUserModuleAcces;
	}
	
	protected function getList($sqlQuery){
		$tab = QueryExecutor::execute($sqlQuery);
		$ret = array();
		for($i=0;$i<count($tab);$i++){
			$ret[$i] = $this->readRow($tab[$i]);
		}
		return $ret;
	}
	
	/**
	 * Get row
	 *
	 * @return TblUserModuleAccessMySql 
	 */
	protected function getRow($sqlQuery){
		$tab = QueryExecutor::execute($sqlQuery);
		if(count($tab)==0){
			return null;
		}
		return $this->readRow($tab[0]);		
	}
	
	/**
	 * Execute sql query
	 */
	protected function execute($sqlQuery){
		return QueryExecutor::execute($sqlQuery);
	}
	
		
	/**
	 * Execute sql query
	 */
	protected function executeUpdate($sqlQuery){
		return QueryExecutor::executeUpdate($sqlQuery);
	}

	/**
	 * Query for one row and one column
	 */
	protected function querySingleResult($sqlQuery){
		return QueryExecutor::queryForString($sqlQuery);
	}

	/**
	 * Insert row to table
	 */
	protected function executeInsert($sqlQuery){
		return QueryExecutor::executeInsert($sqlQuery);
	}
}
?>