<?php
/**
 * Class that operate on table 'tbl_scope_client'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2019-05-27 08:17
 */
class TblScopeClientMySqlDAO implements TblScopeClientDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @return TblScopeClientMySql 
	 */
	public function load($id){
		$sql = 'SELECT * FROM tbl_scope_client WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($id);
		return $this->getRow($sqlQuery);
	}

	/**
	 * Get all records from table
	 */
	public function queryAll(){
		$sql = 'SELECT * FROM tbl_scope_client';
		$sqlQuery = new SqlQuery($sql);
		return $this->getList($sqlQuery);
	}
	
	/**
	 * Get all records from table ordered by field
	 *
	 * @param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn){
		$sql = 'SELECT * FROM tbl_scope_client ORDER BY '.$orderColumn;
		$sqlQuery = new SqlQuery($sql);
		return $this->getList($sqlQuery);
	}
	
	/**
 	 * Delete record from table
 	 * @param tblScopeClient primary key
 	 */
	public function delete($id){
		$sql = 'DELETE FROM tbl_scope_client WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($id);
		return $this->executeUpdate($sqlQuery);
	}
	
	/**
 	 * Insert record to table
 	 *
 	 * @param TblScopeClientMySql tblScopeClient
 	 */
	public function insert($tblScopeClient){
		$sql = 'INSERT INTO tbl_scope_client (client_win_id, scope_of_work_id, created_by, modified_by, date_created, date_modified) VALUES (?, ?, ?, ?, ?, ?)';
		$sqlQuery = new SqlQuery($sql);
		
		$sqlQuery->setNumber($tblScopeClient->clientWinId);
		$sqlQuery->setNumber($tblScopeClient->scopeOfWorkId);
		$sqlQuery->setNumber($tblScopeClient->createdBy);
		$sqlQuery->setNumber($tblScopeClient->modifiedBy);
		$sqlQuery->set($tblScopeClient->dateCreated);
		$sqlQuery->set($tblScopeClient->dateModified);

		$id = $this->executeInsert($sqlQuery);	
		$tblScopeClient->id = $id;
		return $id;
	}
	
	/**
 	 * Update record in table
 	 *
 	 * @param TblScopeClientMySql tblScopeClient
 	 */
	public function update($tblScopeClient){
		$sql = 'UPDATE tbl_scope_client SET client_win_id = ?, scope_of_work_id = ?, created_by = ?, modified_by = ?, date_created = ?, date_modified = ? WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		
		$sqlQuery->setNumber($tblScopeClient->clientWinId);
		$sqlQuery->setNumber($tblScopeClient->scopeOfWorkId);
		$sqlQuery->setNumber($tblScopeClient->createdBy);
		$sqlQuery->setNumber($tblScopeClient->modifiedBy);
		$sqlQuery->set($tblScopeClient->dateCreated);
		$sqlQuery->set($tblScopeClient->dateModified);

		$sqlQuery->setNumber($tblScopeClient->id);
		return $this->executeUpdate($sqlQuery);
	}

	/**
 	 * Delete all rows
 	 */
	public function clean(){
		$sql = 'DELETE FROM tbl_scope_client';
		$sqlQuery = new SqlQuery($sql);
		return $this->executeUpdate($sqlQuery);
	}

	public function queryByClientWinId($value){
		$sql = 'SELECT * FROM tbl_scope_client WHERE client_win_id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByScopeOfWorkId($value){
		$sql = 'SELECT * FROM tbl_scope_client WHERE scope_of_work_id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByCreatedBy($value){
		$sql = 'SELECT * FROM tbl_scope_client WHERE created_by = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByModifiedBy($value){
		$sql = 'SELECT * FROM tbl_scope_client WHERE modified_by = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByDateCreated($value){
		$sql = 'SELECT * FROM tbl_scope_client WHERE date_created = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByDateModified($value){
		$sql = 'SELECT * FROM tbl_scope_client WHERE date_modified = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}


	public function deleteByClientWinId($value){
		$sql = 'DELETE FROM tbl_scope_client WHERE client_win_id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByScopeOfWorkId($value){
		$sql = 'DELETE FROM tbl_scope_client WHERE scope_of_work_id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByCreatedBy($value){
		$sql = 'DELETE FROM tbl_scope_client WHERE created_by = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByModifiedBy($value){
		$sql = 'DELETE FROM tbl_scope_client WHERE modified_by = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByDateCreated($value){
		$sql = 'DELETE FROM tbl_scope_client WHERE date_created = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByDateModified($value){
		$sql = 'DELETE FROM tbl_scope_client WHERE date_modified = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}


	
	/**
	 * Read row
	 *
	 * @return TblScopeClientMySql 
	 */
	protected function readRow($row){
		$tblScopeClient = new TblScopeClient();
		
		$tblScopeClient->id = $row['id'];
		$tblScopeClient->clientWinId = $row['client_win_id'];
		$tblScopeClient->scopeOfWorkId = $row['scope_of_work_id'];
		$tblScopeClient->createdBy = $row['created_by'];
		$tblScopeClient->modifiedBy = $row['modified_by'];
		$tblScopeClient->dateCreated = $row['date_created'];
		$tblScopeClient->dateModified = $row['date_modified'];

		return $tblScopeClient;
	}
	
	protected function getList($sqlQuery){
		$tab = QueryExecutor::execute($sqlQuery);
		$ret = array();
		for($i=0;$i<count($tab);$i++){
			$ret[$i] = $this->readRow($tab[$i]);
		}
		return $ret;
	}
	
	/**
	 * Get row
	 *
	 * @return TblScopeClientMySql 
	 */
	protected function getRow($sqlQuery){
		$tab = QueryExecutor::execute($sqlQuery);
		if(count($tab)==0){
			return null;
		}
		return $this->readRow($tab[0]);		
	}
	
	/**
	 * Execute sql query
	 */
	protected function execute($sqlQuery){
		return QueryExecutor::execute($sqlQuery);
	}
	
		
	/**
	 * Execute sql query
	 */
	protected function executeUpdate($sqlQuery){
		return QueryExecutor::executeUpdate($sqlQuery);
	}

	/**
	 * Query for one row and one column
	 */
	protected function querySingleResult($sqlQuery){
		return QueryExecutor::queryForString($sqlQuery);
	}

	/**
	 * Insert row to table
	 */
	protected function executeInsert($sqlQuery){
		return QueryExecutor::executeInsert($sqlQuery);
	}
}
?>