<?php
/**
 * Class that operate on table 'tbl_client_schedule'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2017-12-27 03:54
 */
class TblClientScheduleMySqlDAO implements TblClientScheduleDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @return TblClientScheduleMySql 
	 */
	public function load($id){
		$sql = 'SELECT * FROM tbl_client_schedule WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($id);
		return $this->getRow($sqlQuery);
	}

	/**
	 * Get all records from table
	 */
	public function queryAll(){
		$sql = 'SELECT * FROM tbl_client_schedule';
		$sqlQuery = new SqlQuery($sql);
		return $this->getList($sqlQuery);
	}
	
	/**
	 * Get all records from table ordered by field
	 *
	 * @param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn){
		$sql = 'SELECT * FROM tbl_client_schedule ORDER BY '.$orderColumn;
		$sqlQuery = new SqlQuery($sql);
		return $this->getList($sqlQuery);
	}
	
	/**
 	 * Delete record from table
 	 * @param tblClientSchedule primary key
 	 */
	public function delete($id){
		$sql = 'DELETE FROM tbl_client_schedule WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($id);
		return $this->executeUpdate($sqlQuery);
	}
	
	/**
 	 * Insert record to table
 	 *
 	 * @param TblClientScheduleMySql tblClientSchedule
 	 */
	public function insert($tblClientSchedule){
		$sql = 'INSERT INTO tbl_client_schedule (client_id, time_in, time_out, sched_type, created_by, modified_by, date_created, date_modified) VALUES (?, ?, ?, ?, ?, ?, ?, ?)';
		$sqlQuery = new SqlQuery($sql);
		
		$sqlQuery->setNumber($tblClientSchedule->clientId);
		$sqlQuery->set($tblClientSchedule->timeIn);
		$sqlQuery->set($tblClientSchedule->timeOut);
		$sqlQuery->setNumber($tblClientSchedule->schedType);
		$sqlQuery->setNumber($tblClientSchedule->createdBy);
		$sqlQuery->setNumber($tblClientSchedule->modifiedBy);
		$sqlQuery->set($tblClientSchedule->dateCreated);
		$sqlQuery->set($tblClientSchedule->dateModified);

		$id = $this->executeInsert($sqlQuery);	
		$tblClientSchedule->id = $id;
		return $id;
	}
	
	/**
 	 * Update record in table
 	 *
 	 * @param TblClientScheduleMySql tblClientSchedule
 	 */
	public function update($tblClientSchedule){
		$sql = 'UPDATE tbl_client_schedule SET client_id = ?, time_in = ?, time_out = ?, sched_type = ?, created_by = ?, modified_by = ?, date_created = ?, date_modified = ? WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		
		$sqlQuery->setNumber($tblClientSchedule->clientId);
		$sqlQuery->set($tblClientSchedule->timeIn);
		$sqlQuery->set($tblClientSchedule->timeOut);
		$sqlQuery->setNumber($tblClientSchedule->schedType);
		$sqlQuery->setNumber($tblClientSchedule->createdBy);
		$sqlQuery->setNumber($tblClientSchedule->modifiedBy);
		$sqlQuery->set($tblClientSchedule->dateCreated);
		$sqlQuery->set($tblClientSchedule->dateModified);

		$sqlQuery->setNumber($tblClientSchedule->id);
		return $this->executeUpdate($sqlQuery);
	}

	/**
 	 * Delete all rows
 	 */
	public function clean(){
		$sql = 'DELETE FROM tbl_client_schedule';
		$sqlQuery = new SqlQuery($sql);
		return $this->executeUpdate($sqlQuery);
	}

	public function queryByClientId($value){
		$sql = 'SELECT * FROM tbl_client_schedule WHERE client_id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByTimeIn($value){
		$sql = 'SELECT * FROM tbl_client_schedule WHERE time_in = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByTimeOut($value){
		$sql = 'SELECT * FROM tbl_client_schedule WHERE time_out = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryBySchedType($value){
		$sql = 'SELECT * FROM tbl_client_schedule WHERE sched_type = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByCreatedBy($value){
		$sql = 'SELECT * FROM tbl_client_schedule WHERE created_by = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByModifiedBy($value){
		$sql = 'SELECT * FROM tbl_client_schedule WHERE modified_by = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByDateCreated($value){
		$sql = 'SELECT * FROM tbl_client_schedule WHERE date_created = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByDateModified($value){
		$sql = 'SELECT * FROM tbl_client_schedule WHERE date_modified = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}


	public function deleteByClientId($value){
		$sql = 'DELETE FROM tbl_client_schedule WHERE client_id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByTimeIn($value){
		$sql = 'DELETE FROM tbl_client_schedule WHERE time_in = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByTimeOut($value){
		$sql = 'DELETE FROM tbl_client_schedule WHERE time_out = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteBySchedType($value){
		$sql = 'DELETE FROM tbl_client_schedule WHERE sched_type = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByCreatedBy($value){
		$sql = 'DELETE FROM tbl_client_schedule WHERE created_by = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByModifiedBy($value){
		$sql = 'DELETE FROM tbl_client_schedule WHERE modified_by = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByDateCreated($value){
		$sql = 'DELETE FROM tbl_client_schedule WHERE date_created = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByDateModified($value){
		$sql = 'DELETE FROM tbl_client_schedule WHERE date_modified = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}


	
	/**
	 * Read row
	 *
	 * @return TblClientScheduleMySql 
	 */
	protected function readRow($row){
		$tblClientSchedule = new TblClientSchedule();
		
		$tblClientSchedule->id = $row['id'];
		$tblClientSchedule->clientId = $row['client_id'];
		$tblClientSchedule->timeIn = $row['time_in'];
		$tblClientSchedule->timeOut = $row['time_out'];
		$tblClientSchedule->schedType = $row['sched_type'];
		$tblClientSchedule->createdBy = $row['created_by'];
		$tblClientSchedule->modifiedBy = $row['modified_by'];
		$tblClientSchedule->dateCreated = $row['date_created'];
		$tblClientSchedule->dateModified = $row['date_modified'];

		return $tblClientSchedule;
	}
	
	protected function getList($sqlQuery){
		$tab = QueryExecutor::execute($sqlQuery);
		$ret = array();
		for($i=0;$i<count($tab);$i++){
			$ret[$i] = $this->readRow($tab[$i]);
		}
		return $ret;
	}
	
	/**
	 * Get row
	 *
	 * @return TblClientScheduleMySql 
	 */
	protected function getRow($sqlQuery){
		$tab = QueryExecutor::execute($sqlQuery);
		if(count($tab)==0){
			return null;
		}
		return $this->readRow($tab[0]);		
	}
	
	/**
	 * Execute sql query
	 */
	protected function execute($sqlQuery){
		return QueryExecutor::execute($sqlQuery);
	}
	
		
	/**
	 * Execute sql query
	 */
	protected function executeUpdate($sqlQuery){
		return QueryExecutor::executeUpdate($sqlQuery);
	}

	/**
	 * Query for one row and one column
	 */
	protected function querySingleResult($sqlQuery){
		return QueryExecutor::queryForString($sqlQuery);
	}

	/**
	 * Insert row to table
	 */
	protected function executeInsert($sqlQuery){
		return QueryExecutor::executeInsert($sqlQuery);
	}
}
?>