<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2017-12-06 06:34
 */
interface TblEngagementTypePerDeptAccessDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return TblEngagementTypePerDeptAccess 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param tblEngagementTypePerDeptAcces primary key
 	 */
	public function delete($id);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param TblEngagementTypePerDeptAccess tblEngagementTypePerDeptAcces
 	 */
	public function insert($tblEngagementTypePerDeptAcces);
	
	/**
 	 * Update record in table
 	 *
 	 * @param TblEngagementTypePerDeptAccess tblEngagementTypePerDeptAcces
 	 */
	public function update($tblEngagementTypePerDeptAcces);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryByEngagementTypeId($value);

	public function queryByDepartmentId($value);

	public function queryByPositionId($value);

	public function queryByCreatedBy($value);

	public function queryByModifiedBy($value);

	public function queryByDateCreated($value);

	public function queryByDateModified($value);


	public function deleteByEngagementTypeId($value);

	public function deleteByDepartmentId($value);

	public function deleteByPositionId($value);

	public function deleteByCreatedBy($value);

	public function deleteByModifiedBy($value);

	public function deleteByDateCreated($value);

	public function deleteByDateModified($value);


}
?>