<?php
/**
 * Class that operate on table 'tbl_attendance'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2013-06-17 04:14
 */
class TblAttendanceMySqlExtDAO extends TblAttendanceMySqlDAO{
	
	static function getEmployeeAttendanceByDate($id = 0,$date,$type = ''){
		$statusType = $type == '' ? '' : " AND status_type = '".$type."' ";
		$employee = $id == 0 ? '' : ' AND employee = '.$id.' ';
		$txt = "
			SELECT * FROM tbl_attendance WHERE DATE(time) = '".$date."' ".$employee." ".$statusType."
			
		";
		$sqlQuery = new SqlQuery($txt);
		
		return self::getAttendance($sqlQuery);
	}
/*
	static function getAttendanceByDate($id,$date,$keyword = ''){
		$txt = "
			SELECT * FROM tbl_attendance WHERE employee = ".$id." AND DATE(time) = '".$date."'
			AND employee IN ( SELECT id FROM tbl_user WHERE CONCAT(firstname,' ',midname,' ',lastname) LIKE '%".$keyword."%' )
		";
		
		$sqlQuery = new SqlQuery($txt);
		
		return self::getAttendance($sqlQuery);
	}
*/
	static function getAttendanceRange($user, $date1,$date2){
		
		$txt = "
			SELECT * FROM tbl_attendance WHERE employee = ".$user." AND DATE(time) >= '".$date1."' AND DATE(time) <= '".$date2."'
				AND status_type != '0'
				ORDER BY time ASC
		";
		
		$sqlQuery = new SqlQuery($txt);
		
		return self::getAttendance($sqlQuery);
	}
	
	static function getLastWeek($userId,$date){
		$txt = "
			SELECT * FROM tbl_attendance WHERE employee = ".$userId." AND DATE(time) = DATE_SUB('".$date."', INTERVAL 7 DAY)
		";
		
		$sqlQuery = new Sqlquery($txt);
		
		return self::getAttendance($sqlQuery);
	}
	
	protected static function getAttendance($sqlQuery){
		$tab = QueryExecutor::execute($sqlQuery);
		
		if(empty($tab)){
			return false;
		} else {
			$results = array();
			
			foreach($tab as $each){
				$attendance = new TblAttendance();
				$attendance->id = $each['id'];
				$attendance->employee = $each['employee'];
				$attendance->project = $each['project'];
				$attendance->activity = $each['activity'];
				$attendance->time = $each['time'];
				$attendance->officialTime = $each['officialTime'];
				$attendance->hoursCode = $each['hoursCode'];
				$attendance->note = $each['note'];
				$attendance->location = $each['location'];
				$attendance->status = $each['status'];
				$attendance->absent = $each['absent'];
				$attendance->late = $each['late'];
				$attendance->holiday = $each['holiday'];
				$attendance->statusType = $each['status_type'];
				$attendance->submit = $each['submit'];
				$attendance->client = $each['client'];
				$attendance->timeOut = $each['time_out'];
				$attendance->locationOut = $each['location_out'];
				$attendance->submitOut = $each['submit_out'];
				$attendance->noteOut = $each['note_out'];
				
				$results[] = $attendance;
			}
			
			return $results;
		}
	}
	
	static function getHoursCode($id, $from, $to){
		$txt = "
			select 
			  sum(case when hoursCode = 'RT' then 1 else 0 end) as RT,
			  sum(case when hoursCode = 'AL' then 1 else 0 end) as AL,
			  sum(case when hoursCode = 'HD' then 1 else 0 end) as HD,
			  sum(case when hoursCode = 'VL' then 1 else 0 end) as VL,
			  sum(case when hoursCode = 'EL' then 1 else 0 end) as EL,
			  sum(case when hoursCode = 'PL' then 1 else 0 end) as PL,
			  sum(case when hoursCode = 'ML' then 1 else 0 end) as ML,
			  sum(case when hoursCode = 'SL' then 1 else 0 end) as SL,
			  sum(case when hoursCode = 'LATE' then 1 when late = '1' then 1 else 0 end) as LATE,
			  sum(case when status = '0' then 1 when absent = '1' then 1 else 0 end) as no_time_in,
			  sum(case when status = '2' then 1 else 0 end) as late_time_in,
			  sum(case when late = '2' then 1 else 0 end) as HD_late,
			  count(id) as count
			from tbl_attendance
			WHERE employee = ".$id." AND DATE(time)>='".$from."' AND DATE(time)<='$to'
			AND status_type = '2'
		";
		$sqlQuery = new SqlQuery($txt);
		return self::getReturn($sqlQuery);
	}
	
	static function getAttendanceComplience($deadline , $ext, $date, $grp = 0,$company = '%%'){
		$group = $grp == 0 ? '' : " AND employee IN ( SELECT user_id FROM tbl_group_access WHERE group_id = ".$grp." AND type='1' ) ";
		$txt = "
			SELECT 
				sum(case when TIME(submit) <= '".$deadline."' then 1 else 0 end) as ontime,
				sum(case when TIME(submit) > '".$deadline."' then 1 else 0 end) as late,
				count(id) as num
			from tbl_attendance
			WHERE
			DATE(time)='".$date."' ".$group."
			AND employee IN
			(
				SELECT id FROM tbl_user WHERE company LIKE '".$company."'
			)
			/*AND TIME(submit) <= '".$ext."'*/
		";
		$sqlQuery = new SqlQuery($txt);
		return self::getReturn($sqlQuery);
	}
	
	static function getReturn($sqlQuery){
		$tab = QueryExecutor::execute($sqlQuery);
		if(empty($tab)){ return false; }
		$results = array();
		//$array = array();
		$array = self::getArray($tab[0]);
		foreach($tab as $each){
			$result = array();
			foreach($array as $key => $value){
				$result[$key] = $each[$key];
			}
			$results[] = $result;
		}
		
		return $results;
	}
	
	protected static function getArray($tab){
		$num = 0;
		$array = array();
		foreach($tab as $key => $value){
			if($num % 2 != 0){
				$array[$key] = '';
			}
			$num++;
		}
		return $array;
	}
	
	 function perDiem($userId,$from,$to)
	{
	$sql = "SELECT  count(*)*250 as `per diem`

    	FROM `tbl_attendance` as a
       LEFT JOIN `tbl_user` as u ON a.`employee` = u.`id`
       LEFT JOIN `provinces` as p ON (a.`location` = p.`name` OR a.`location_out` = p.`name`)
       	LEFT JOIN `cities` as c ON  (a.`location` = c.`name` OR a.`location_out` = c.`name`)
       
       where
       ((p.`name` = a.`location` or p.`name` = a.`location_out`) OR 
       (c.`name` = a.`location` or c.`name` = a.`location_out`))
       and
     ( (p.id != u.`assigned_location`) or(c.province_id != u.`assigned_location`) )
       and
			a.`employee` = '$userId'

			AND 
			date(a.`submit_out`) >= '$from' AND 
			date(a.`submit_out`) <= '$to'";
		// echo $sql;
		$sqlQuery = new SqlQuery($sql);
		return QueryExecutor::execute($sqlQuery);
	} 
	/* function perDiem($userId,$from,$to)
	{
		$sql ="SELECT  a.location,a.location_out,b.`assigned_location`,COUNT(*)*250 as `per diem` 
			FROM `tbl_attendance` as a
			JOIN `tbl_user` as b ON a.`employee` = b.`id`
			WHERE ((a.`location` != b.`assigned_location`) 
			and (a.`location_out` != b.`assigned_location`))
			AND b.`id` = '$userId'
			AND 
			date(a.`submit_out`) >= '$from' AND 
			date(a.`submit_out`) <= '$to'";
			
		$sqlQuery = new SqlQuery($sql);
		return QueryExecutor::execute($sqlQuery);
	} */
	function location()
	{
		$sql = "SELECT a.*,c.`name` from provinces as a 
			LEFT JOIN cities as c ON a.`id` = c.`province_id`  ORDER BY `c`.`name` ASC";
							
		$sqlQuery = new SqlQuery($sql);
		return QueryExecutor::execute($sqlQuery);
	}
	
	function getDtrData($from,$to,$grpId)
	{
		$group = $grpId != 0 ? "AND tga.group_id = ".$grpId."" : '';
		$sql = "SELECT tu.company_id,
							CONCAT(tu.firstname,' ',tu.lastname) name,
							TIME(ta.time) time_in,
							TIME(ta.time_out) time_out,
							DATE(ta.time) date,
							IF(tes.shift != '0','Regular Shift','Flexi') shift
					FROM tbl_attendance ta
							LEFT JOIN tbl_user tu
									ON tu.id = ta.employee
							LEFT JOIN tbl_employee_setup tes
									ON tes.employee = tu.id
							LEFT JOIN tbl_group_access tga
								ON tga.user_id = tes.employee
									WHERE
											DATE(ta.time) BETWEEN '".$from."' AND '".$to."'
												".$group."
											AND
												tga.type = 1
					ORDER BY name,date
					";
		$sqlQuery = new SqlQuery($sql);
		return QueryExecutor::execute($sqlQuery);
	}
	
	
}
?>