<?php
/**
 * Class that operate on table 'tbl_userinfo'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2017-04-03 05:19
 */
class TblUserinfoMySqlDAO implements TblUserinfoDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @return TblUserinfoMySql 
	 */
	public function load($id){
		$sql = 'SELECT * FROM tbl_userinfo WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($id);
		return $this->getRow($sqlQuery);
	}

	/**
	 * Get all records from table
	 */
	public function queryAll(){
		$sql = 'SELECT * FROM tbl_userinfo';
		$sqlQuery = new SqlQuery($sql);
		return $this->getList($sqlQuery);
	}
	
	/**
	 * Get all records from table ordered by field
	 *
	 * @param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn){
		$sql = 'SELECT * FROM tbl_userinfo ORDER BY '.$orderColumn;
		$sqlQuery = new SqlQuery($sql);
		return $this->getList($sqlQuery);
	}
	
	/**
 	 * Delete record from table
 	 * @param tblUserinfo primary key
 	 */
	public function delete($id){
		$sql = 'DELETE FROM tbl_userinfo WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($id);
		return $this->executeUpdate($sqlQuery);
	}
	
	/**
 	 * Insert record to table
 	 *
 	 * @param TblUserinfoMySql tblUserinfo
 	 */
	public function insert($tblUserinfo){
		$sql = 'INSERT INTO tbl_userinfo (user_id, bdate, gender, p_email, phone, cp, ca_house, ca_street, ca_city, pa_house, pa_street, pa_city, civil_status, marriage_date, spouse, occupation, contactNumber, childnum, ages, sss, mno, tin, philhealth, blood_type, date) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)';
		$sqlQuery = new SqlQuery($sql);
		
		$sqlQuery->setNumber($tblUserinfo->userId);
		$sqlQuery->set($tblUserinfo->bdate);
		$sqlQuery->set($tblUserinfo->gender);
		$sqlQuery->set($tblUserinfo->pEmail);
		$sqlQuery->set($tblUserinfo->phone);
		$sqlQuery->set($tblUserinfo->cp);
		$sqlQuery->set($tblUserinfo->caHouse);
		$sqlQuery->set($tblUserinfo->caStreet);
		$sqlQuery->set($tblUserinfo->caCity);
		$sqlQuery->set($tblUserinfo->paHouse);
		$sqlQuery->set($tblUserinfo->paStreet);
		$sqlQuery->set($tblUserinfo->paCity);
		$sqlQuery->set($tblUserinfo->civilStatus);
		$sqlQuery->set($tblUserinfo->marriageDate);
		$sqlQuery->set($tblUserinfo->spouse);
		$sqlQuery->set($tblUserinfo->occupation);
		$sqlQuery->set($tblUserinfo->contactNumber);
		$sqlQuery->setNumber($tblUserinfo->childnum);
		$sqlQuery->set($tblUserinfo->ages);
		$sqlQuery->set($tblUserinfo->sss);
		$sqlQuery->set($tblUserinfo->mno);
		$sqlQuery->set($tblUserinfo->tin);
		$sqlQuery->set($tblUserinfo->philhealth);
		$sqlQuery->set($tblUserinfo->bloodType);
		$sqlQuery->set($tblUserinfo->date);

		$id = $this->executeInsert($sqlQuery);	
		$tblUserinfo->id = $id;
		return $id;
	}
	
	/**
 	 * Update record in table
 	 *
 	 * @param TblUserinfoMySql tblUserinfo
 	 */
	public function update($tblUserinfo){
		$sql = 'UPDATE tbl_userinfo SET user_id = ?, bdate = ?, gender = ?, p_email = ?, phone = ?, cp = ?, ca_house = ?, ca_street = ?, ca_city = ?, pa_house = ?, pa_street = ?, pa_city = ?, civil_status = ?, marriage_date = ?, spouse = ?, occupation = ?, contactNumber = ?, childnum = ?, ages = ?, sss = ?, mno = ?, tin = ?, philhealth = ?, blood_type = ?, date = ? WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		
		$sqlQuery->setNumber($tblUserinfo->userId);
		$sqlQuery->set($tblUserinfo->bdate);
		$sqlQuery->set($tblUserinfo->gender);
		$sqlQuery->set($tblUserinfo->pEmail);
		$sqlQuery->set($tblUserinfo->phone);
		$sqlQuery->set($tblUserinfo->cp);
		$sqlQuery->set($tblUserinfo->caHouse);
		$sqlQuery->set($tblUserinfo->caStreet);
		$sqlQuery->set($tblUserinfo->caCity);
		$sqlQuery->set($tblUserinfo->paHouse);
		$sqlQuery->set($tblUserinfo->paStreet);
		$sqlQuery->set($tblUserinfo->paCity);
		$sqlQuery->set($tblUserinfo->civilStatus);
		$sqlQuery->set($tblUserinfo->marriageDate);
		$sqlQuery->set($tblUserinfo->spouse);
		$sqlQuery->set($tblUserinfo->occupation);
		$sqlQuery->set($tblUserinfo->contactNumber);
		$sqlQuery->setNumber($tblUserinfo->childnum);
		$sqlQuery->set($tblUserinfo->ages);
		$sqlQuery->set($tblUserinfo->sss);
		$sqlQuery->set($tblUserinfo->mno);
		$sqlQuery->set($tblUserinfo->tin);
		$sqlQuery->set($tblUserinfo->philhealth);
		$sqlQuery->set($tblUserinfo->bloodType);
		$sqlQuery->set($tblUserinfo->date);

		$sqlQuery->setNumber($tblUserinfo->id);
		return $this->executeUpdate($sqlQuery);
	}

	/**
 	 * Delete all rows
 	 */
	public function clean(){
		$sql = 'DELETE FROM tbl_userinfo';
		$sqlQuery = new SqlQuery($sql);
		return $this->executeUpdate($sqlQuery);
	}

	public function queryByUserId($value){
		$sql = 'SELECT * FROM tbl_userinfo WHERE user_id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByBdate($value){
		$sql = 'SELECT * FROM tbl_userinfo WHERE bdate = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByGender($value){
		$sql = 'SELECT * FROM tbl_userinfo WHERE gender = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByPEmail($value){
		$sql = 'SELECT * FROM tbl_userinfo WHERE p_email = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByPhone($value){
		$sql = 'SELECT * FROM tbl_userinfo WHERE phone = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByCp($value){
		$sql = 'SELECT * FROM tbl_userinfo WHERE cp = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByCaHouse($value){
		$sql = 'SELECT * FROM tbl_userinfo WHERE ca_house = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByCaStreet($value){
		$sql = 'SELECT * FROM tbl_userinfo WHERE ca_street = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByCaCity($value){
		$sql = 'SELECT * FROM tbl_userinfo WHERE ca_city = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByPaHouse($value){
		$sql = 'SELECT * FROM tbl_userinfo WHERE pa_house = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByPaStreet($value){
		$sql = 'SELECT * FROM tbl_userinfo WHERE pa_street = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByPaCity($value){
		$sql = 'SELECT * FROM tbl_userinfo WHERE pa_city = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByCivilStatus($value){
		$sql = 'SELECT * FROM tbl_userinfo WHERE civil_status = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByMarriageDate($value){
		$sql = 'SELECT * FROM tbl_userinfo WHERE marriage_date = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryBySpouse($value){
		$sql = 'SELECT * FROM tbl_userinfo WHERE spouse = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByOccupation($value){
		$sql = 'SELECT * FROM tbl_userinfo WHERE occupation = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByContactNumber($value){
		$sql = 'SELECT * FROM tbl_userinfo WHERE contactNumber = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByChildnum($value){
		$sql = 'SELECT * FROM tbl_userinfo WHERE childnum = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByAges($value){
		$sql = 'SELECT * FROM tbl_userinfo WHERE ages = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryBySss($value){
		$sql = 'SELECT * FROM tbl_userinfo WHERE sss = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByMno($value){
		$sql = 'SELECT * FROM tbl_userinfo WHERE mno = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByTin($value){
		$sql = 'SELECT * FROM tbl_userinfo WHERE tin = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByPhilhealth($value){
		$sql = 'SELECT * FROM tbl_userinfo WHERE philhealth = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByBloodType($value){
		$sql = 'SELECT * FROM tbl_userinfo WHERE blood_type = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByDate($value){
		$sql = 'SELECT * FROM tbl_userinfo WHERE date = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}


	public function deleteByUserId($value){
		$sql = 'DELETE FROM tbl_userinfo WHERE user_id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByBdate($value){
		$sql = 'DELETE FROM tbl_userinfo WHERE bdate = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByGender($value){
		$sql = 'DELETE FROM tbl_userinfo WHERE gender = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByPEmail($value){
		$sql = 'DELETE FROM tbl_userinfo WHERE p_email = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByPhone($value){
		$sql = 'DELETE FROM tbl_userinfo WHERE phone = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByCp($value){
		$sql = 'DELETE FROM tbl_userinfo WHERE cp = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByCaHouse($value){
		$sql = 'DELETE FROM tbl_userinfo WHERE ca_house = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByCaStreet($value){
		$sql = 'DELETE FROM tbl_userinfo WHERE ca_street = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByCaCity($value){
		$sql = 'DELETE FROM tbl_userinfo WHERE ca_city = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByPaHouse($value){
		$sql = 'DELETE FROM tbl_userinfo WHERE pa_house = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByPaStreet($value){
		$sql = 'DELETE FROM tbl_userinfo WHERE pa_street = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByPaCity($value){
		$sql = 'DELETE FROM tbl_userinfo WHERE pa_city = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByCivilStatus($value){
		$sql = 'DELETE FROM tbl_userinfo WHERE civil_status = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByMarriageDate($value){
		$sql = 'DELETE FROM tbl_userinfo WHERE marriage_date = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteBySpouse($value){
		$sql = 'DELETE FROM tbl_userinfo WHERE spouse = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByOccupation($value){
		$sql = 'DELETE FROM tbl_userinfo WHERE occupation = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByContactNumber($value){
		$sql = 'DELETE FROM tbl_userinfo WHERE contactNumber = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByChildnum($value){
		$sql = 'DELETE FROM tbl_userinfo WHERE childnum = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByAges($value){
		$sql = 'DELETE FROM tbl_userinfo WHERE ages = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteBySss($value){
		$sql = 'DELETE FROM tbl_userinfo WHERE sss = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByMno($value){
		$sql = 'DELETE FROM tbl_userinfo WHERE mno = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByTin($value){
		$sql = 'DELETE FROM tbl_userinfo WHERE tin = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByPhilhealth($value){
		$sql = 'DELETE FROM tbl_userinfo WHERE philhealth = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByBloodType($value){
		$sql = 'DELETE FROM tbl_userinfo WHERE blood_type = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByDate($value){
		$sql = 'DELETE FROM tbl_userinfo WHERE date = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}


	
	/**
	 * Read row
	 *
	 * @return TblUserinfoMySql 
	 */
	protected function readRow($row){
		$tblUserinfo = new TblUserinfo();
		
		$tblUserinfo->id = $row['id'];
		$tblUserinfo->userId = $row['user_id'];
		$tblUserinfo->bdate = $row['bdate'];
		$tblUserinfo->gender = $row['gender'];
		$tblUserinfo->pEmail = $row['p_email'];
		$tblUserinfo->phone = $row['phone'];
		$tblUserinfo->cp = $row['cp'];
		$tblUserinfo->caHouse = $row['ca_house'];
		$tblUserinfo->caStreet = $row['ca_street'];
		$tblUserinfo->caCity = $row['ca_city'];
		$tblUserinfo->paHouse = $row['pa_house'];
		$tblUserinfo->paStreet = $row['pa_street'];
		$tblUserinfo->paCity = $row['pa_city'];
		$tblUserinfo->civilStatus = $row['civil_status'];
		$tblUserinfo->marriageDate = $row['marriage_date'];
		$tblUserinfo->spouse = $row['spouse'];
		$tblUserinfo->occupation = $row['occupation'];
		$tblUserinfo->contactNumber = $row['contactNumber'];
		$tblUserinfo->childnum = $row['childnum'];
		$tblUserinfo->ages = $row['ages'];
		$tblUserinfo->sss = $row['sss'];
		$tblUserinfo->mno = $row['mno'];
		$tblUserinfo->tin = $row['tin'];
		$tblUserinfo->philhealth = $row['philhealth'];
		$tblUserinfo->bloodType = $row['blood_type'];
		$tblUserinfo->date = $row['date'];

		return $tblUserinfo;
	}
	
	protected function getList($sqlQuery){
		$tab = QueryExecutor::execute($sqlQuery);
		$ret = array();
		for($i=0;$i<count($tab);$i++){
			$ret[$i] = $this->readRow($tab[$i]);
		}
		return $ret;
	}
	
	/**
	 * Get row
	 *
	 * @return TblUserinfoMySql 
	 */
	protected function getRow($sqlQuery){
		$tab = QueryExecutor::execute($sqlQuery);
		if(count($tab)==0){
			return null;
		}
		return $this->readRow($tab[0]);		
	}
	
	/**
	 * Execute sql query
	 */
	protected function execute($sqlQuery){
		return QueryExecutor::execute($sqlQuery);
	}
	
		
	/**
	 * Execute sql query
	 */
	protected function executeUpdate($sqlQuery){
		return QueryExecutor::executeUpdate($sqlQuery);
	}

	/**
	 * Query for one row and one column
	 */
	protected function querySingleResult($sqlQuery){
		return QueryExecutor::queryForString($sqlQuery);
	}

	/**
	 * Insert row to table
	 */
	protected function executeInsert($sqlQuery){
		return QueryExecutor::executeInsert($sqlQuery);
	}
}
?>