<?php
/**
 * Class that operate on table 'tbl_request_ot'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2017-04-03 05:19
 */
class TblRequestOtMySqlDAO implements TblRequestOtDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @return TblRequestOtMySql 
	 */
	public function load($id){
		$sql = 'SELECT * FROM tbl_request_ot WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($id);
		return $this->getRow($sqlQuery);
	}

	/**
	 * Get all records from table
	 */
	public function queryAll(){
		$sql = 'SELECT * FROM tbl_request_ot';
		$sqlQuery = new SqlQuery($sql);
		return $this->getList($sqlQuery);
	}
	
	/**
	 * Get all records from table ordered by field
	 *
	 * @param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn){
		$sql = 'SELECT * FROM tbl_request_ot ORDER BY '.$orderColumn;
		$sqlQuery = new SqlQuery($sql);
		return $this->getList($sqlQuery);
	}
	
	/**
 	 * Delete record from table
 	 * @param tblRequestOt primary key
 	 */
	public function delete($id){
		$sql = 'DELETE FROM tbl_request_ot WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($id);
		return $this->executeUpdate($sqlQuery);
	}
	
	/**
 	 * Insert record to table
 	 *
 	 * @param TblRequestOtMySql tblRequestOt
 	 */
	public function insert($tblRequestOt){
		$sql = 'INSERT INTO tbl_request_ot (user_id, client, expected_output, from_hours, to_hours, estimated_hours, reason, status, dateRequested, date_overtime, approveId) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)';
		$sqlQuery = new SqlQuery($sql);
		
		$sqlQuery->setNumber($tblRequestOt->userId);
		$sqlQuery->setNumber($tblRequestOt->client);
		$sqlQuery->set($tblRequestOt->expectedOutput);
		$sqlQuery->set($tblRequestOt->fromHours);
		$sqlQuery->set($tblRequestOt->toHours);
		$sqlQuery->setNumber($tblRequestOt->estimatedHours);
		$sqlQuery->set($tblRequestOt->reason);
		$sqlQuery->set($tblRequestOt->status);
		$sqlQuery->set($tblRequestOt->dateRequested);
		$sqlQuery->set($tblRequestOt->dateOvertime);
		$sqlQuery->setNumber($tblRequestOt->approveId);

		$id = $this->executeInsert($sqlQuery);	
		$tblRequestOt->id = $id;
		return $id;
	}
	
	/**
 	 * Update record in table
 	 *
 	 * @param TblRequestOtMySql tblRequestOt
 	 */
	public function update($tblRequestOt){
		$sql = 'UPDATE tbl_request_ot SET user_id = ?, client = ?, expected_output = ?, from_hours = ?, to_hours = ?, estimated_hours = ?, reason = ?, status = ?, dateRequested = ?, date_overtime = ?, approveId = ? WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		
		$sqlQuery->setNumber($tblRequestOt->userId);
		$sqlQuery->setNumber($tblRequestOt->client);
		$sqlQuery->set($tblRequestOt->expectedOutput);
		$sqlQuery->set($tblRequestOt->fromHours);
		$sqlQuery->set($tblRequestOt->toHours);
		$sqlQuery->setNumber($tblRequestOt->estimatedHours);
		$sqlQuery->set($tblRequestOt->reason);
		$sqlQuery->set($tblRequestOt->status);
		$sqlQuery->set($tblRequestOt->dateRequested);
		$sqlQuery->set($tblRequestOt->dateOvertime);
		$sqlQuery->setNumber($tblRequestOt->approveId);

		$sqlQuery->setNumber($tblRequestOt->id);
		return $this->executeUpdate($sqlQuery);
	}

	/**
 	 * Delete all rows
 	 */
	public function clean(){
		$sql = 'DELETE FROM tbl_request_ot';
		$sqlQuery = new SqlQuery($sql);
		return $this->executeUpdate($sqlQuery);
	}

	public function queryByUserId($value){
		$sql = 'SELECT * FROM tbl_request_ot WHERE user_id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByClient($value){
		$sql = 'SELECT * FROM tbl_request_ot WHERE client = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByExpectedOutput($value){
		$sql = 'SELECT * FROM tbl_request_ot WHERE expected_output = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByFromHours($value){
		$sql = 'SELECT * FROM tbl_request_ot WHERE from_hours = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByToHours($value){
		$sql = 'SELECT * FROM tbl_request_ot WHERE to_hours = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByEstimatedHours($value){
		$sql = 'SELECT * FROM tbl_request_ot WHERE estimated_hours = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByReason($value){
		$sql = 'SELECT * FROM tbl_request_ot WHERE reason = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByStatus($value){
		$sql = 'SELECT * FROM tbl_request_ot WHERE status = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByDateRequested($value){
		$sql = 'SELECT * FROM tbl_request_ot WHERE dateRequested = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByDateOvertime($value){
		$sql = 'SELECT * FROM tbl_request_ot WHERE date_overtime = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByApproveId($value){
		$sql = 'SELECT * FROM tbl_request_ot WHERE approveId = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}


	public function deleteByUserId($value){
		$sql = 'DELETE FROM tbl_request_ot WHERE user_id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByClient($value){
		$sql = 'DELETE FROM tbl_request_ot WHERE client = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByExpectedOutput($value){
		$sql = 'DELETE FROM tbl_request_ot WHERE expected_output = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByFromHours($value){
		$sql = 'DELETE FROM tbl_request_ot WHERE from_hours = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByToHours($value){
		$sql = 'DELETE FROM tbl_request_ot WHERE to_hours = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByEstimatedHours($value){
		$sql = 'DELETE FROM tbl_request_ot WHERE estimated_hours = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByReason($value){
		$sql = 'DELETE FROM tbl_request_ot WHERE reason = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByStatus($value){
		$sql = 'DELETE FROM tbl_request_ot WHERE status = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByDateRequested($value){
		$sql = 'DELETE FROM tbl_request_ot WHERE dateRequested = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByDateOvertime($value){
		$sql = 'DELETE FROM tbl_request_ot WHERE date_overtime = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByApproveId($value){
		$sql = 'DELETE FROM tbl_request_ot WHERE approveId = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}


	
	/**
	 * Read row
	 *
	 * @return TblRequestOtMySql 
	 */
	protected function readRow($row){
		$tblRequestOt = new TblRequestOt();
		
		$tblRequestOt->id = $row['id'];
		$tblRequestOt->userId = $row['user_id'];
		$tblRequestOt->client = $row['client'];
		$tblRequestOt->expectedOutput = $row['expected_output'];
		$tblRequestOt->fromHours = $row['from_hours'];
		$tblRequestOt->toHours = $row['to_hours'];
		$tblRequestOt->estimatedHours = $row['estimated_hours'];
		$tblRequestOt->reason = $row['reason'];
		$tblRequestOt->status = $row['status'];
		$tblRequestOt->dateRequested = $row['dateRequested'];
		$tblRequestOt->dateOvertime = $row['date_overtime'];
		$tblRequestOt->approveId = $row['approveId'];

		return $tblRequestOt;
	}
	
	protected function getList($sqlQuery){
		$tab = QueryExecutor::execute($sqlQuery);
		$ret = array();
		for($i=0;$i<count($tab);$i++){
			$ret[$i] = $this->readRow($tab[$i]);
		}
		return $ret;
	}
	
	/**
	 * Get row
	 *
	 * @return TblRequestOtMySql 
	 */
	protected function getRow($sqlQuery){
		$tab = QueryExecutor::execute($sqlQuery);
		if(count($tab)==0){
			return null;
		}
		return $this->readRow($tab[0]);		
	}
	
	/**
	 * Execute sql query
	 */
	protected function execute($sqlQuery){
		return QueryExecutor::execute($sqlQuery);
	}
	
		
	/**
	 * Execute sql query
	 */
	protected function executeUpdate($sqlQuery){
		return QueryExecutor::executeUpdate($sqlQuery);
	}

	/**
	 * Query for one row and one column
	 */
	protected function querySingleResult($sqlQuery){
		return QueryExecutor::queryForString($sqlQuery);
	}

	/**
	 * Insert row to table
	 */
	protected function executeInsert($sqlQuery){
		return QueryExecutor::executeInsert($sqlQuery);
	}
}
?>