<?php
/**
 * Class that operate on table 'tbl_plan_records'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2017-04-03 05:19
 */
class TblPlanRecordsMySqlDAO implements TblPlanRecordsDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @return TblPlanRecordsMySql 
	 */
	public function load($id){
		$sql = 'SELECT * FROM tbl_plan_records WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($id);
		return $this->getRow($sqlQuery);
	}

	/**
	 * Get all records from table
	 */
	public function queryAll(){
		$sql = 'SELECT * FROM tbl_plan_records';
		$sqlQuery = new SqlQuery($sql);
		return $this->getList($sqlQuery);
	}
	
	/**
	 * Get all records from table ordered by field
	 *
	 * @param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn){
		$sql = 'SELECT * FROM tbl_plan_records ORDER BY '.$orderColumn;
		$sqlQuery = new SqlQuery($sql);
		return $this->getList($sqlQuery);
	}
	
	/**
 	 * Delete record from table
 	 * @param tblPlanRecord primary key
 	 */
	public function delete($id){
		$sql = 'DELETE FROM tbl_plan_records WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($id);
		return $this->executeUpdate($sqlQuery);
	}
	
	/**
 	 * Insert record to table
 	 *
 	 * @param TblPlanRecordsMySql tblPlanRecord
 	 */
	public function insert($tblPlanRecord){
		$sql = 'INSERT INTO tbl_plan_records (trans_id, line, transaction, activity, plan_output, budget_hours, remaining_budget, hours_code, deadline, superior_id) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)';
		$sqlQuery = new SqlQuery($sql);
		
		$sqlQuery->setNumber($tblPlanRecord->transId);
		$sqlQuery->setNumber($tblPlanRecord->line);
		$sqlQuery->set($tblPlanRecord->transaction);
		$sqlQuery->setNumber($tblPlanRecord->activity);
		$sqlQuery->set($tblPlanRecord->planOutput);
		$sqlQuery->set($tblPlanRecord->budgetHours);
		$sqlQuery->set($tblPlanRecord->remainingBudget);
		$sqlQuery->set($tblPlanRecord->hoursCode);
		$sqlQuery->set($tblPlanRecord->deadline);
		$sqlQuery->setNumber($tblPlanRecord->superiorId);

		$id = $this->executeInsert($sqlQuery);	
		$tblPlanRecord->id = $id;
		return $id;
	}
	
	/**
 	 * Update record in table
 	 *
 	 * @param TblPlanRecordsMySql tblPlanRecord
 	 */
	public function update($tblPlanRecord){
		$sql = 'UPDATE tbl_plan_records SET trans_id = ?, line = ?, transaction = ?, activity = ?, plan_output = ?, budget_hours = ?, remaining_budget = ?, hours_code = ?, deadline = ?, superior_id = ? WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		
		$sqlQuery->setNumber($tblPlanRecord->transId);
		$sqlQuery->setNumber($tblPlanRecord->line);
		$sqlQuery->set($tblPlanRecord->transaction);
		$sqlQuery->setNumber($tblPlanRecord->activity);
		$sqlQuery->set($tblPlanRecord->planOutput);
		$sqlQuery->set($tblPlanRecord->budgetHours);
		$sqlQuery->set($tblPlanRecord->remainingBudget);
		$sqlQuery->set($tblPlanRecord->hoursCode);
		$sqlQuery->set($tblPlanRecord->deadline);
		$sqlQuery->setNumber($tblPlanRecord->superiorId);

		$sqlQuery->setNumber($tblPlanRecord->id);
		return $this->executeUpdate($sqlQuery);
	}

	/**
 	 * Delete all rows
 	 */
	public function clean(){
		$sql = 'DELETE FROM tbl_plan_records';
		$sqlQuery = new SqlQuery($sql);
		return $this->executeUpdate($sqlQuery);
	}

	public function queryByTransId($value){
		$sql = 'SELECT * FROM tbl_plan_records WHERE trans_id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByLine($value){
		$sql = 'SELECT * FROM tbl_plan_records WHERE line = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByTransaction($value){
		$sql = 'SELECT * FROM tbl_plan_records WHERE transaction = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByActivity($value){
		$sql = 'SELECT * FROM tbl_plan_records WHERE activity = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByPlanOutput($value){
		$sql = 'SELECT * FROM tbl_plan_records WHERE plan_output = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByBudgetHours($value){
		$sql = 'SELECT * FROM tbl_plan_records WHERE budget_hours = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByRemainingBudget($value){
		$sql = 'SELECT * FROM tbl_plan_records WHERE remaining_budget = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByHoursCode($value){
		$sql = 'SELECT * FROM tbl_plan_records WHERE hours_code = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByDeadline($value){
		$sql = 'SELECT * FROM tbl_plan_records WHERE deadline = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryBySuperiorId($value){
		$sql = 'SELECT * FROM tbl_plan_records WHERE superior_id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}


	public function deleteByTransId($value){
		$sql = 'DELETE FROM tbl_plan_records WHERE trans_id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByLine($value){
		$sql = 'DELETE FROM tbl_plan_records WHERE line = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByTransaction($value){
		$sql = 'DELETE FROM tbl_plan_records WHERE transaction = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByActivity($value){
		$sql = 'DELETE FROM tbl_plan_records WHERE activity = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByPlanOutput($value){
		$sql = 'DELETE FROM tbl_plan_records WHERE plan_output = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByBudgetHours($value){
		$sql = 'DELETE FROM tbl_plan_records WHERE budget_hours = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByRemainingBudget($value){
		$sql = 'DELETE FROM tbl_plan_records WHERE remaining_budget = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByHoursCode($value){
		$sql = 'DELETE FROM tbl_plan_records WHERE hours_code = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByDeadline($value){
		$sql = 'DELETE FROM tbl_plan_records WHERE deadline = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteBySuperiorId($value){
		$sql = 'DELETE FROM tbl_plan_records WHERE superior_id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}


	
	/**
	 * Read row
	 *
	 * @return TblPlanRecordsMySql 
	 */
	protected function readRow($row){
		$tblPlanRecord = new TblPlanRecord();
		
		$tblPlanRecord->id = $row['id'];
		$tblPlanRecord->transId = $row['trans_id'];
		$tblPlanRecord->line = $row['line'];
		$tblPlanRecord->transaction = $row['transaction'];
		$tblPlanRecord->activity = $row['activity'];
		$tblPlanRecord->planOutput = $row['plan_output'];
		$tblPlanRecord->budgetHours = $row['budget_hours'];
		$tblPlanRecord->remainingBudget = $row['remaining_budget'];
		$tblPlanRecord->hoursCode = $row['hours_code'];
		$tblPlanRecord->deadline = $row['deadline'];
		$tblPlanRecord->superiorId = $row['superior_id'];

		return $tblPlanRecord;
	}
	
	protected function getList($sqlQuery){
		$tab = QueryExecutor::execute($sqlQuery);
		$ret = array();
		for($i=0;$i<count($tab);$i++){
			$ret[$i] = $this->readRow($tab[$i]);
		}
		return $ret;
	}
	
	/**
	 * Get row
	 *
	 * @return TblPlanRecordsMySql 
	 */
	protected function getRow($sqlQuery){
		$tab = QueryExecutor::execute($sqlQuery);
		if(count($tab)==0){
			return null;
		}
		return $this->readRow($tab[0]);		
	}
	
	/**
	 * Execute sql query
	 */
	protected function execute($sqlQuery){
		return QueryExecutor::execute($sqlQuery);
	}
	
		
	/**
	 * Execute sql query
	 */
	protected function executeUpdate($sqlQuery){
		return QueryExecutor::executeUpdate($sqlQuery);
	}

	/**
	 * Query for one row and one column
	 */
	protected function querySingleResult($sqlQuery){
		return QueryExecutor::queryForString($sqlQuery);
	}

	/**
	 * Insert row to table
	 */
	protected function executeInsert($sqlQuery){
		return QueryExecutor::executeInsert($sqlQuery);
	}
}
?>