<?php
/**
 * Class that operate on table 'tbl_leave'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2017-04-03 05:19
 */
class TblLeaveMySqlDAO implements TblLeaveDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @return TblLeaveMySql 
	 */
	public function load($id){
		$sql = 'SELECT * FROM tbl_leave WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($id);
		return $this->getRow($sqlQuery);
	}

	/**
	 * Get all records from table
	 */
	public function queryAll(){
		$sql = 'SELECT * FROM tbl_leave';
		$sqlQuery = new SqlQuery($sql);
		return $this->getList($sqlQuery);
	}
	
	/**
	 * Get all records from table ordered by field
	 *
	 * @param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn){
		$sql = 'SELECT * FROM tbl_leave ORDER BY '.$orderColumn;
		$sqlQuery = new SqlQuery($sql);
		return $this->getList($sqlQuery);
	}
	
	/**
 	 * Delete record from table
 	 * @param tblLeave primary key
 	 */
	public function delete($id){
		$sql = 'DELETE FROM tbl_leave WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($id);
		return $this->executeUpdate($sqlQuery);
	}
	
	/**
 	 * Insert record to table
 	 *
 	 * @param TblLeaveMySql tblLeave
 	 */
	public function insert($tblLeave){
		$sql = 'INSERT INTO tbl_leave (user_id, activity, time_start, time_end, time_spent, hour_code, line_property, planned_output, category, actual_output, date, approveDate, status, approveId) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)';
		$sqlQuery = new SqlQuery($sql);
		
		$sqlQuery->setNumber($tblLeave->userId);
		$sqlQuery->setNumber($tblLeave->activity);
		$sqlQuery->set($tblLeave->timeStart);
		$sqlQuery->set($tblLeave->timeEnd);
		$sqlQuery->set($tblLeave->timeSpent);
		$sqlQuery->set($tblLeave->hourCode);
		$sqlQuery->set($tblLeave->lineProperty);
		$sqlQuery->setNumber($tblLeave->plannedOutput);
		$sqlQuery->set($tblLeave->category);
		$sqlQuery->set($tblLeave->actualOutput);
		$sqlQuery->set($tblLeave->date);
		$sqlQuery->set($tblLeave->approveDate);
		$sqlQuery->set($tblLeave->status);
		$sqlQuery->setNumber($tblLeave->approveId);

		$id = $this->executeInsert($sqlQuery);	
		$tblLeave->id = $id;
		return $id;
	}
	
	/**
 	 * Update record in table
 	 *
 	 * @param TblLeaveMySql tblLeave
 	 */
	public function update($tblLeave){
		$sql = 'UPDATE tbl_leave SET user_id = ?, activity = ?, time_start = ?, time_end = ?, time_spent = ?, hour_code = ?, line_property = ?, planned_output = ?, category = ?, actual_output = ?, date = ?, approveDate = ?, status = ?, approveId = ? WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		
		$sqlQuery->setNumber($tblLeave->userId);
		$sqlQuery->setNumber($tblLeave->activity);
		$sqlQuery->set($tblLeave->timeStart);
		$sqlQuery->set($tblLeave->timeEnd);
		$sqlQuery->set($tblLeave->timeSpent);
		$sqlQuery->set($tblLeave->hourCode);
		$sqlQuery->set($tblLeave->lineProperty);
		$sqlQuery->setNumber($tblLeave->plannedOutput);
		$sqlQuery->set($tblLeave->category);
		$sqlQuery->set($tblLeave->actualOutput);
		$sqlQuery->set($tblLeave->date);
		$sqlQuery->set($tblLeave->approveDate);
		$sqlQuery->set($tblLeave->status);
		$sqlQuery->setNumber($tblLeave->approveId);

		$sqlQuery->setNumber($tblLeave->id);
		return $this->executeUpdate($sqlQuery);
	}

	/**
 	 * Delete all rows
 	 */
	public function clean(){
		$sql = 'DELETE FROM tbl_leave';
		$sqlQuery = new SqlQuery($sql);
		return $this->executeUpdate($sqlQuery);
	}

	public function queryByUserId($value){
		$sql = 'SELECT * FROM tbl_leave WHERE user_id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByActivity($value){
		$sql = 'SELECT * FROM tbl_leave WHERE activity = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByTimeStart($value){
		$sql = 'SELECT * FROM tbl_leave WHERE time_start = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByTimeEnd($value){
		$sql = 'SELECT * FROM tbl_leave WHERE time_end = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByTimeSpent($value){
		$sql = 'SELECT * FROM tbl_leave WHERE time_spent = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByHourCode($value){
		$sql = 'SELECT * FROM tbl_leave WHERE hour_code = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByLineProperty($value){
		$sql = 'SELECT * FROM tbl_leave WHERE line_property = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByPlannedOutput($value){
		$sql = 'SELECT * FROM tbl_leave WHERE planned_output = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByCategory($value){
		$sql = 'SELECT * FROM tbl_leave WHERE category = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByActualOutput($value){
		$sql = 'SELECT * FROM tbl_leave WHERE actual_output = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByDate($value){
		$sql = 'SELECT * FROM tbl_leave WHERE date = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByApproveDate($value){
		$sql = 'SELECT * FROM tbl_leave WHERE approveDate = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByStatus($value){
		$sql = 'SELECT * FROM tbl_leave WHERE status = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByApproveId($value){
		$sql = 'SELECT * FROM tbl_leave WHERE approveId = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}


	public function deleteByUserId($value){
		$sql = 'DELETE FROM tbl_leave WHERE user_id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByActivity($value){
		$sql = 'DELETE FROM tbl_leave WHERE activity = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByTimeStart($value){
		$sql = 'DELETE FROM tbl_leave WHERE time_start = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByTimeEnd($value){
		$sql = 'DELETE FROM tbl_leave WHERE time_end = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByTimeSpent($value){
		$sql = 'DELETE FROM tbl_leave WHERE time_spent = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByHourCode($value){
		$sql = 'DELETE FROM tbl_leave WHERE hour_code = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByLineProperty($value){
		$sql = 'DELETE FROM tbl_leave WHERE line_property = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByPlannedOutput($value){
		$sql = 'DELETE FROM tbl_leave WHERE planned_output = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByCategory($value){
		$sql = 'DELETE FROM tbl_leave WHERE category = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByActualOutput($value){
		$sql = 'DELETE FROM tbl_leave WHERE actual_output = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByDate($value){
		$sql = 'DELETE FROM tbl_leave WHERE date = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByApproveDate($value){
		$sql = 'DELETE FROM tbl_leave WHERE approveDate = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByStatus($value){
		$sql = 'DELETE FROM tbl_leave WHERE status = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByApproveId($value){
		$sql = 'DELETE FROM tbl_leave WHERE approveId = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}


	
	/**
	 * Read row
	 *
	 * @return TblLeaveMySql 
	 */
	protected function readRow($row){
		$tblLeave = new TblLeave();
		
		$tblLeave->id = $row['id'];
		$tblLeave->userId = $row['user_id'];
		$tblLeave->activity = $row['activity'];
		$tblLeave->timeStart = $row['time_start'];
		$tblLeave->timeEnd = $row['time_end'];
		$tblLeave->timeSpent = $row['time_spent'];
		$tblLeave->hourCode = $row['hour_code'];
		$tblLeave->lineProperty = $row['line_property'];
		$tblLeave->plannedOutput = $row['planned_output'];
		$tblLeave->category = $row['category'];
		$tblLeave->actualOutput = $row['actual_output'];
		$tblLeave->date = $row['date'];
		$tblLeave->approveDate = $row['approveDate'];
		$tblLeave->status = $row['status'];
		$tblLeave->approveId = $row['approveId'];

		return $tblLeave;
	}
	
	protected function getList($sqlQuery){
		$tab = QueryExecutor::execute($sqlQuery);
		$ret = array();
		for($i=0;$i<count($tab);$i++){
			$ret[$i] = $this->readRow($tab[$i]);
		}
		return $ret;
	}
	
	/**
	 * Get row
	 *
	 * @return TblLeaveMySql 
	 */
	protected function getRow($sqlQuery){
		$tab = QueryExecutor::execute($sqlQuery);
		if(count($tab)==0){
			return null;
		}
		return $this->readRow($tab[0]);		
	}
	
	/**
	 * Execute sql query
	 */
	protected function execute($sqlQuery){
		return QueryExecutor::execute($sqlQuery);
	}
	
		
	/**
	 * Execute sql query
	 */
	protected function executeUpdate($sqlQuery){
		return QueryExecutor::executeUpdate($sqlQuery);
	}

	/**
	 * Query for one row and one column
	 */
	protected function querySingleResult($sqlQuery){
		return QueryExecutor::queryForString($sqlQuery);
	}

	/**
	 * Insert row to table
	 */
	protected function executeInsert($sqlQuery){
		return QueryExecutor::executeInsert($sqlQuery);
	}
}
?>