<?php
/**
 * Class that operate on table 'tbl_dprecords'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2017-04-03 05:19
 */
class TblDprecordsMySqlDAO implements TblDprecordsDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @return TblDprecordsMySql 
	 */
	public function load($id){
		$sql = 'SELECT * FROM tbl_dprecords WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($id);
		return $this->getRow($sqlQuery);
	}

	/**
	 * Get all records from table
	 */
	public function queryAll(){
		$sql = 'SELECT * FROM tbl_dprecords';
		$sqlQuery = new SqlQuery($sql);
		return $this->getList($sqlQuery);
	}
	
	/**
	 * Get all records from table ordered by field
	 *
	 * @param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn){
		$sql = 'SELECT * FROM tbl_dprecords ORDER BY '.$orderColumn;
		$sqlQuery = new SqlQuery($sql);
		return $this->getList($sqlQuery);
	}
	
	/**
 	 * Delete record from table
 	 * @param tblDprecord primary key
 	 */
	public function delete($id){
		$sql = 'DELETE FROM tbl_dprecords WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($id);
		return $this->executeUpdate($sqlQuery);
	}
	
	/**
 	 * Insert record to table
 	 *
 	 * @param TblDprecordsMySql tblDprecord
 	 */
	public function insert($tblDprecord){
		$sql = 'INSERT INTO tbl_dprecords (trans_id, activity, category, planned_output, actual_output, to_dos, task_issue, completion_age, line_property, time_start, time_end, hour_spent, hour_code, journal, voucher, transaction) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)';
		$sqlQuery = new SqlQuery($sql);
		
		$sqlQuery->setNumber($tblDprecord->transId);
		$sqlQuery->setNumber($tblDprecord->activity);
		$sqlQuery->set($tblDprecord->category);
		$sqlQuery->set($tblDprecord->plannedOutput);
		$sqlQuery->set($tblDprecord->actualOutput);
		$sqlQuery->setNumber($tblDprecord->toDos);
		$sqlQuery->set($tblDprecord->taskIssue);
		$sqlQuery->set($tblDprecord->completionAge);
		$sqlQuery->set($tblDprecord->lineProperty);
		$sqlQuery->set($tblDprecord->timeStart);
		$sqlQuery->set($tblDprecord->timeEnd);
		$sqlQuery->set($tblDprecord->hourSpent);
		$sqlQuery->set($tblDprecord->hourCode);
		$sqlQuery->set($tblDprecord->journal);
		$sqlQuery->set($tblDprecord->voucher);
		$sqlQuery->set($tblDprecord->transaction);

		$id = $this->executeInsert($sqlQuery);	
		$tblDprecord->id = $id;
		return $id;
	}
	
	/**
 	 * Update record in table
 	 *
 	 * @param TblDprecordsMySql tblDprecord
 	 */
	public function update($tblDprecord){
		$sql = 'UPDATE tbl_dprecords SET trans_id = ?, activity = ?, category = ?, planned_output = ?, actual_output = ?, to_dos = ?, task_issue = ?, completion_age = ?, line_property = ?, time_start = ?, time_end = ?, hour_spent = ?, hour_code = ?, journal = ?, voucher = ?, transaction = ? WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		
		$sqlQuery->setNumber($tblDprecord->transId);
		$sqlQuery->setNumber($tblDprecord->activity);
		$sqlQuery->set($tblDprecord->category);
		$sqlQuery->set($tblDprecord->plannedOutput);
		$sqlQuery->set($tblDprecord->actualOutput);
		$sqlQuery->setNumber($tblDprecord->toDos);
		$sqlQuery->set($tblDprecord->taskIssue);
		$sqlQuery->set($tblDprecord->completionAge);
		$sqlQuery->set($tblDprecord->lineProperty);
		$sqlQuery->set($tblDprecord->timeStart);
		$sqlQuery->set($tblDprecord->timeEnd);
		$sqlQuery->set($tblDprecord->hourSpent);
		$sqlQuery->set($tblDprecord->hourCode);
		$sqlQuery->set($tblDprecord->journal);
		$sqlQuery->set($tblDprecord->voucher);
		$sqlQuery->set($tblDprecord->transaction);

		$sqlQuery->setNumber($tblDprecord->id);
		return $this->executeUpdate($sqlQuery);
	}

	/**
 	 * Delete all rows
 	 */
	public function clean(){
		$sql = 'DELETE FROM tbl_dprecords';
		$sqlQuery = new SqlQuery($sql);
		return $this->executeUpdate($sqlQuery);
	}

	public function queryByTransId($value){
		$sql = 'SELECT * FROM tbl_dprecords WHERE trans_id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByActivity($value){
		$sql = 'SELECT * FROM tbl_dprecords WHERE activity = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByCategory($value){
		$sql = 'SELECT * FROM tbl_dprecords WHERE category = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByPlannedOutput($value){
		$sql = 'SELECT * FROM tbl_dprecords WHERE planned_output = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByActualOutput($value){
		$sql = 'SELECT * FROM tbl_dprecords WHERE actual_output = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByToDos($value){
		$sql = 'SELECT * FROM tbl_dprecords WHERE to_dos = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByTaskIssue($value){
		$sql = 'SELECT * FROM tbl_dprecords WHERE task_issue = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByCompletionAge($value){
		$sql = 'SELECT * FROM tbl_dprecords WHERE completion_age = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByLineProperty($value){
		$sql = 'SELECT * FROM tbl_dprecords WHERE line_property = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByTimeStart($value){
		$sql = 'SELECT * FROM tbl_dprecords WHERE time_start = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByTimeEnd($value){
		$sql = 'SELECT * FROM tbl_dprecords WHERE time_end = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByHourSpent($value){
		$sql = 'SELECT * FROM tbl_dprecords WHERE hour_spent = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByHourCode($value){
		$sql = 'SELECT * FROM tbl_dprecords WHERE hour_code = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByJournal($value){
		$sql = 'SELECT * FROM tbl_dprecords WHERE journal = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByVoucher($value){
		$sql = 'SELECT * FROM tbl_dprecords WHERE voucher = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByTransaction($value){
		$sql = 'SELECT * FROM tbl_dprecords WHERE transaction = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}


	public function deleteByTransId($value){
		$sql = 'DELETE FROM tbl_dprecords WHERE trans_id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByActivity($value){
		$sql = 'DELETE FROM tbl_dprecords WHERE activity = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByCategory($value){
		$sql = 'DELETE FROM tbl_dprecords WHERE category = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByPlannedOutput($value){
		$sql = 'DELETE FROM tbl_dprecords WHERE planned_output = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByActualOutput($value){
		$sql = 'DELETE FROM tbl_dprecords WHERE actual_output = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByToDos($value){
		$sql = 'DELETE FROM tbl_dprecords WHERE to_dos = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByTaskIssue($value){
		$sql = 'DELETE FROM tbl_dprecords WHERE task_issue = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByCompletionAge($value){
		$sql = 'DELETE FROM tbl_dprecords WHERE completion_age = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByLineProperty($value){
		$sql = 'DELETE FROM tbl_dprecords WHERE line_property = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByTimeStart($value){
		$sql = 'DELETE FROM tbl_dprecords WHERE time_start = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByTimeEnd($value){
		$sql = 'DELETE FROM tbl_dprecords WHERE time_end = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByHourSpent($value){
		$sql = 'DELETE FROM tbl_dprecords WHERE hour_spent = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByHourCode($value){
		$sql = 'DELETE FROM tbl_dprecords WHERE hour_code = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByJournal($value){
		$sql = 'DELETE FROM tbl_dprecords WHERE journal = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByVoucher($value){
		$sql = 'DELETE FROM tbl_dprecords WHERE voucher = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByTransaction($value){
		$sql = 'DELETE FROM tbl_dprecords WHERE transaction = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}


	
	/**
	 * Read row
	 *
	 * @return TblDprecordsMySql 
	 */
	protected function readRow($row){
		$tblDprecord = new TblDprecord();
		
		$tblDprecord->id = $row['id'];
		$tblDprecord->transId = $row['trans_id'];
		$tblDprecord->activity = $row['activity'];
		$tblDprecord->category = $row['category'];
		$tblDprecord->plannedOutput = $row['planned_output'];
		$tblDprecord->actualOutput = $row['actual_output'];
		$tblDprecord->toDos = $row['to_dos'];
		$tblDprecord->taskIssue = $row['task_issue'];
		$tblDprecord->completionAge = $row['completion_age'];
		$tblDprecord->lineProperty = $row['line_property'];
		$tblDprecord->timeStart = $row['time_start'];
		$tblDprecord->timeEnd = $row['time_end'];
		$tblDprecord->hourSpent = $row['hour_spent'];
		$tblDprecord->hourCode = $row['hour_code'];
		$tblDprecord->journal = $row['journal'];
		$tblDprecord->voucher = $row['voucher'];
		$tblDprecord->transaction = $row['transaction'];

		return $tblDprecord;
	}
	
	protected function getList($sqlQuery){
		$tab = QueryExecutor::execute($sqlQuery);
		$ret = array();
		for($i=0;$i<count($tab);$i++){
			$ret[$i] = $this->readRow($tab[$i]);
		}
		return $ret;
	}
	
	/**
	 * Get row
	 *
	 * @return TblDprecordsMySql 
	 */
	protected function getRow($sqlQuery){
		$tab = QueryExecutor::execute($sqlQuery);
		if(count($tab)==0){
			return null;
		}
		return $this->readRow($tab[0]);		
	}
	
	/**
	 * Execute sql query
	 */
	protected function execute($sqlQuery){
		return QueryExecutor::execute($sqlQuery);
	}
	
		
	/**
	 * Execute sql query
	 */
	protected function executeUpdate($sqlQuery){
		return QueryExecutor::executeUpdate($sqlQuery);
	}

	/**
	 * Query for one row and one column
	 */
	protected function querySingleResult($sqlQuery){
		return QueryExecutor::queryForString($sqlQuery);
	}

	/**
	 * Insert row to table
	 */
	protected function executeInsert($sqlQuery){
		return QueryExecutor::executeInsert($sqlQuery);
	}
}
?>