<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2017-04-03 05:19
 */
interface TblTeamSetupDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return TblTeamSetup 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param tblTeamSetup primary key
 	 */
	public function delete($id);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param TblTeamSetup tblTeamSetup
 	 */
	public function insert($tblTeamSetup);
	
	/**
 	 * Update record in table
 	 *
 	 * @param TblTeamSetup tblTeamSetup
 	 */
	public function update($tblTeamSetup);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryByTeamId($value);

	public function queryByDescription($value);

	public function queryByLeader($value);


	public function deleteByTeamId($value);

	public function deleteByDescription($value);

	public function deleteByLeader($value);


}
?>