<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2017-04-03 05:19
 */
interface TblEmploymentDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return TblEmployment 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param tblEmployment primary key
 	 */
	public function delete($id);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param TblEmployment tblEmployment
 	 */
	public function insert($tblEmployment);
	
	/**
 	 * Update record in table
 	 *
 	 * @param TblEmployment tblEmployment
 	 */
	public function update($tblEmployment);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryByUserId($value);

	public function queryByDateHired($value);

	public function queryByEmploymentStatus($value);

	public function queryByRegularization($value);

	public function queryByVacation($value);

	public function queryBySick($value);

	public function queryByLeave($value);

	public function queryByLastDay($value);

	public function queryByEmployeeStatus($value);

	public function queryByRemarks($value);


	public function deleteByUserId($value);

	public function deleteByDateHired($value);

	public function deleteByEmploymentStatus($value);

	public function deleteByRegularization($value);

	public function deleteByVacation($value);

	public function deleteBySick($value);

	public function deleteByLeave($value);

	public function deleteByLastDay($value);

	public function deleteByEmployeeStatus($value);

	public function deleteByRemarks($value);


}
?>