<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2017-04-03 05:19
 */
interface TblDefaultActivitiesDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return TblDefaultActivities 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param tblDefaultActivitie primary key
 	 */
	public function delete($id);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param TblDefaultActivities tblDefaultActivitie
 	 */
	public function insert($tblDefaultActivitie);
	
	/**
 	 * Update record in table
 	 *
 	 * @param TblDefaultActivities tblDefaultActivitie
 	 */
	public function update($tblDefaultActivitie);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryByCompany($value);

	public function queryByGroupId($value);

	public function queryByActId($value);

	public function queryByEngagementType($value);


	public function deleteByCompany($value);

	public function deleteByGroupId($value);

	public function deleteByActId($value);

	public function deleteByEngagementType($value);


}
?>