<style>
    body{
        background: #eeeeee!important;
        color: #666666!important;
    }
    .table thead tr th{
        text-align: center;
    }
    .nav li a{
        border-radius: 0px;
    }
    .dropdown-toggle{
        height: 30px;
        font-size: 12px;
    }
</style>
<div class="mt-20">
    <ul class="nav nav-pills">
        <li class="active"><a data-toggle="pill" href="#timeentries">Attendance</a></li>
        <li><a data-toggle="pill" href="#inbetween">In Between</a></li>
    </ul>
    <div class="tab-content">
        <div id="timeentries" class="tab-pane fade in active">
            <div class="panel panel-default mt-10" style="border-radius: 0px">
                <!-- <div class="panel-heading">
                    Attendance
                </div> -->
                <div class="panel-body" style="padding-top: 30px;">
                    <form id="generateAttendance">
                        <div class="row">
                            <div class="form-group col-lg-5">
                                <div class="input-group">
                                    <span class="input-group-btn">
                                        <button type="button" class="btn btn-sm btn-default" disabled="">Subdomain : </button>
                                    </span>
                                <!-- <input type="text" value="<?=date('Y-m-01')?>" class="form-control input-sm datepicker" name="from" placeholder="From Date"> -->
                                    <select class="form-control selectpicker input-sm" data-live-search="true" name="subdomain">
                                    </select>
                                </div>
                            </div>
                            <div class="form-group col-lg-7">
                                <div class="input-group">
                                    <span class="input-group-btn">
                                        <button type="button" class="btn btn-sm btn-default" disabled="">Employee : </button>
                                    </span>
                                <!-- <input type="text" value="<?=date('Y-m-01')?>" class="form-control input-sm datepicker" name="from" placeholder="From Date"> -->
                                    <select class="form-control selectpicker input-sm" data-live-search="true" name="employee">
                                    </select>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="form-group col-lg-3">
                                <div class="input-group">
                                    <span class="input-group-btn">
                                        <button type="button" class="btn btn-sm btn-default" disabled="">From : </button>
                                    </span>
                                <input type="text" value="<?=date('Y-m-01')?>" class="form-control input-sm datepicker" name="from" placeholder="From Date">
                                </div>
                            </div>
                            <div class="form-group col-lg-3">
                                <div class="input-group">
                                    <span class="input-group-btn">
                                        <button type="button" class="btn btn-sm btn-default" disabled="">To : </button>
                                    </span>
                                <input type="text" value="<?=date('Y-m-t')?>" class="form-control input-sm datepicker" name="to" placeholder="To Date">
                                </div>
                            </div>

                            <div class="form-group col-lg-3">
                                <button type="submit" class="btn btn-info btn-sm">Generate</button>
                                <button type="button" id ="ExportAttendance" class="btn btn-info btn-sm">Export</button>
                            </div>
                        </div>
                    </form>
                    <table class="table table-condensed table-standard table-bordered" id="attendanceTable" style="color: #666!important;">
                        <thead>
                            <tr>
                                <th rowspan="2">Name</th>
                                <th rowspan="2">Date</th>
                                <th colspan="5">Time In</th>
                                <th colspan="5">Time Out</th>
                            </tr>
                            <tr>
                                <th>Time</th>
                                <th>Client</th>
                                <th>Location</th>
                                <th>Sync Date</th>
                                <th>Actual Date</th>
                                <th>Time</th>
                                <th>Client</th>
                                <th>Location</th>
                                <th>Sync Date</th>
                                <th>Actual Date</th>
                            </tr>
                        </thead>
                        <tbody class="attendance">
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
        <div id="inbetween" class="tab-pane fade">
            <div class="panel panel-default mt-10" style="border-radius: 0px">
                <div class="panel-body" style="padding-top: 30px;">
                    <form id="generateBetween">
                        <div class="row">
                            <div class="form-group col-lg-5">
                                <div class="input-group">
                                    <span class="input-group-btn">
                                        <button type="button" class="btn btn-sm btn-default" disabled="">Subdomain : </button>
                                    </span>
                                <!-- <input type="text" value="<?=date('Y-m-01')?>" class="form-control input-sm datepicker" name="from" placeholder="From Date"> -->
                                    <select class="form-control selectpicker input-sm" data-live-search="true" name="subdomain">
                                    </select>
                                </div>
                            </div>
                            <div class="form-group col-lg-7">
                                <div class="input-group">
                                    <span class="input-group-btn">
                                        <button type="button" class="btn btn-sm btn-default" disabled="">Employee : </button>
                                    </span>
                                <!-- <input type="text" value="<?=date('Y-m-01')?>" class="form-control input-sm datepicker" name="from" placeholder="From Date"> -->
                                    <select class="form-control selectpicker input-sm" data-live-search="true" name="employee">
                                    </select>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="form-group col-lg-3">
                                <div class="input-group">
                                    <span class="input-group-btn">
                                        <button type="button" class="btn btn-sm btn-default" disabled="">From : </button>
                                    </span>
                                <input type="text" value="<?=date('Y-m-01')?>" class="form-control input-sm datepicker" name="from" placeholder="From Date">
                                </div>
                            </div>
                            <div class="form-group col-lg-3">
                                <div class="input-group">
                                    <span class="input-group-btn">
                                        <button type="button" class="btn btn-sm btn-default" disabled="">To : </button>
                                    </span>
                                <input type="text" value="<?=date('Y-m-t')?>" class="form-control input-sm datepicker" name="to" placeholder="To Date">
                                </div>
                            </div>

                            <div class="form-group col-lg-3">
                                <button type="submit" class="btn btn-info btn-sm">Generate</button>
                                <button type="button" id ="ExportAttendance" class="btn btn-info btn-sm">Export</button>
                            </div>
                        </div>
                    </form>
                    <table class="table table-condensed table-standard" id="betweenTable" style="color: #666!important;">
                        <thead>
                            <tr>
                                <th>Name</th>
                                <th>Date</th>
                                <th>Time</th>
                                <th>Client</th>
                                <th>Location</th>
                                <th>Sync Date</th>
                            </tr>
                        </thead>
                        <tbody class="between">
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>
    <script>
        showSubdomainsDT();
        $('#generateAttendance').submit(function(){

            $('#attendanceTable tbody.attendance').html('');
            tableLoader('#attendanceTable');
            var form = $(this).serialize();
            $.post(URL+'dashtito/getAttendance', form)
            .done(function(returnData){
                var data = $.parseJSON(returnData);
                if(returnData == '[]'){
                    var th = $('#attendanceTable th').length;
                    $('#attendanceTable tbody.attendance').html('<tr><td class="text-center" colspan="'+th+'" style="padding: 30px;">No Results Found</td></tr>');
                } else {
                    append = '';
                    $.each(data, function(i,x){
                        var timein = '';
                        var timeout = '';


                        if(x.time_in === null){
                            timein = '<td class="danger text-center text-danger" colspan="5">No Time In</td>';
                        } else {

                            timein = '<td>'+tConv24(x.time_in)+'</td>'+
                            '<td>'+x.time_in_client+'</td>'+
                            '<td>'+x.time_in_loc+'</td>'+
                            '<td>'+dateTimeConv24(x.time_in_sync)+'</td>'+
                            '<td>'+dateTimeConv24(x.actual_date_in)+'</td>';
                        }
                        if(x.time_out === null){
                            timeout = '<td class="danger text-center text-danger" colspan="5">No Time Out</td>';
                        } else {
                            timeout = '<td>'+tConv24(x.time_out)+'</td>'+
                            '<td>'+x.time_out_client+'</td>'+
                            '<td>'+x.time_out_loc+'</td>'+
                            '<td>'+dateTimeConv24(x.time_out_sync)+'</td>'+
                            '<td>'+dateTimeConv24(x.actual_date_out)+'</td>';
                        }
                        name = x.name !== null ? x.name : x.username;
                        append += '<tr>'+
                                    '<td>'+name+'</td>'+
                                    '<td>'+x.time_in_date+'</td>'+
                                    timein+
                                    timeout+
                                '</tr>';
                    })
                    $('#attendanceTable tbody.attendance').html(append);
                }
            })
            return false;
        })
        $('#generateBetween').submit(function(){

            $('#betweenTable tbody.between').html('');
            tableLoader('#betweenTable');
            var form = $(this).serialize();
            $.post(URL+'dashtito/getAttendanceBetween', form)
            .done(function(returnData){
                var data = $.parseJSON(returnData);
                if(returnData == '[]'){
                    var th = $('#betweenTable th').length;

                    $('#betweenTable tbody.between').html('<tr><td class="text-center" colspan="'+th+'" style="padding: 20px;">No Results Found</td></tr>');
                } else {
                    append = '';
                    $.each(data, function(i,x){
                        name = x.name !== null ? x.name : x.username;
                        append += '<tr>'+
                                    '<td>'+name+'</td>'+
                                    '<td>'+x.date+'</td>'+
                                    '<td>'+x.time+'</td>'+
                                    '<td>'+x.client+'</td>'+
                                    '<td>'+x.location+'</td>'+
                                    '<td>'+x.synced_date+'</td>'+

                                '</tr>';
                    })
                    $('#betweenTable tbody.between').html(append);
                }
            })
            return false;
        })

        $('#ExportAttendance').click(function(){

            from = $('#generateAttendance input[name="from"]').val();
            to = $('#generateAttendance input[name="to"]').val();
            subdomain = $('#generateAttendance select[name="subdomain"]').val();
            employee = $('#generateAttendance select[name="employee"]').val();

            window.location.href = URL +'dashtito/exportEmployeeAttendance?from='+from+'&to='+to+'&subdomain='+subdomain+'&employee='+employee;

        });
        $('#ExportAttendanceBetween').click(function(){

            from = $('#generateBetween input[name="from"]').val();
            to = $('#generateBetween input[name="to"]').val();
            subdomain = $('#generateBetween select[name="subdomain"]').val();
            employee = $('#generateBetween select[name="employee"]').val();

            window.location.href = URL +'dashtito/exportEmployeeAttendanceBetween?from='+from+'&to='+to+'&subdomain='+subdomain+'&employee='+employee;

        });
        $('select[name="subdomain"]').change(function(){
            var subdomain = $(this).val();
            showEmployees(subdomain);
        });
function showSubdomainsDT(){
    $.post(URL + 'dashtito/showSubdomainsDT')
	.done(function(returnData){
        var data = $.parseJSON(returnData);
        var append = '';
        $.each(data,function(key,a){
            append +=  '<option value="'+a.id+'">'+a.subdomain+'</option>';
        })
        $('#generateAttendance').find('select[name=subdomain]').html(append);
        $('#generateAttendance').find('select[name=subdomain]').selectpicker('refresh');
        $('#generateBetween').find('select[name=subdomain]').html(append);
        $('#generateBetween').find('select[name=subdomain]').selectpicker('refresh');
    })  
}
function showEmployees(subdomain){
    $.post(URL + 'dashtito/getEmployeePerSubdomain', {'subdomain':subdomain})
	.done(function(returnData){
	    console.log(returnData);
        var data = $.parseJSON(returnData);
        var append = '<option value="%%">All</option>';
        $.each(data,function(key,a){
            append +=  '<option value="'+a.id+'">'+a.name+'</option>';
        })
        $('#generateAttendance').find('select[name=employee]').html(append);
        $('#generateAttendance').find('select[name=employee]').selectpicker('refresh');
        $('#generateBetween').find('select[name=employee]').html(append);
        $('#generateBetween').find('select[name=employee]').selectpicker('refresh');
    })  
}

function tConv24(time24) {
    var ts = time24;
    var H = +ts.substr(0, 2);
    var h = (H % 12) || 12;
    h = (h < 10)?("0"+h):h;
    var ampm = H < 12 ? " AM" : " PM";
    ts = h + ts.substr(2, 3) + ampm;
    return ts;
};

function dateTimeConv24(time24) {
    var datetime = time24.split(' ');
    var time = datetime[1];
    var date = datetime[0];

    return date+' '+tConv24(time);
};

</script>
