$(function(){
	$('#table_db').on('click', '.subview', function(){
		$('#reportModal').modal({
		  	backdrop: 'static', 
		    keyboard: false,
		    toggle: true
		 });
		var subdomain = $(this).attr('subid');
		var date = $('input[name="date"]').val();
		dbReportSummary(date,subdomain);
	});

	$('#generateDb').submit(function(){
		$('#table_db').DataTable().destroy();
		tableLoader('#table_db');
		var form = $(this).serialize();
		$.post(URL + 'reports/generateDashboard', form)
		.done(function(returnData){
			var data = $.parseJSON(returnData);
			var append = '';
			$.each(data,function(key,a){
				append += "<tr>"+
								"<td><a class='subview' subid='"+a.sub_id+"'>"+a.sub_username+"</a></td>"+
								"<td>"+a.target+"</td>"+
								"<td>"+a.actual+"</td>"+
								"<td>"+a.variance+"</td>"+
						"</tr>";
			})
			$('#table_db').find(".data_db").html(append);
			$('#table_db').DataTable({
			    "ordering": false  
			});
		})
		return false;
	})

	$('.btnExport').click(function(){
		date = $('input[name="date"]').val();

		window.location = URL +"export/dashboard?date="+date;
	})
	$('.btnExport2').click(function(){
		date = $('input[name="date"]').val();
		subdomain = $('.subview').attr('subid');

		window.location = URL +"export/dashboard2?date="+date+"&subdomain="+subdomain;
	})

})

function dbReportSummary(date,subdomain){
	$('#db_summary_table').DataTable().destroy();	
	tableLoader('#db_summary_table');
	$.post(URL + 'reports/generateDpr2', {'date':date,'subdomain': subdomain})
	.done(function(returnData){
		var data = $.parseJSON(returnData);
		var append = '';
		$.each(data,function(key,a){
			status1 = (a.nbt == 'done' ? 1: 0);
			status2 = (a.nbt == 'no report' ? 1: 0);
			append += "<tr>"+
								"<td>"+a.name+"</td>"+
								"<td>"+a.position+"</td>"+
								"<td>"+status1+"</td>"+
								"<td>"+status2+"</td>"+
						"</tr>";
		})

		$('#db_summary_table').find(".dbSummaryData").html(append);	
		$('#db_summary_table').DataTable();	
	})
	return false;
}