<?php
/**
 * Class that operate on table 'tbl_engagement'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2017-12-05 08:24
 */
class TblEngagementMySqlExtDAO extends TblEngagementMySqlDAO{

	function countEngagement(){


		$sql="SELECT count(*) as total from tbl_engagement";

		$sqlQuery = new SqlQuery($sql);
		return QueryExecutor::execute($sqlQuery);
	}
	function getEngagementList(){
		$sql = "
				SELECT 
					tes.id eng_id,
					tc.id client_id,
					tc.client,
					te.engagement_no engagement_no,
					te.engagement,
					tes.date_start,
					tes.date_end,
					tes.overall_budget_hours,
					tes.eng_status,
					tes.subdomain
				FROM
					tbl_engagement_setup tes
				INNER JOIN
					tbl_client tc
				ON
					tc.id = tes.client_id
				INNER JOIN
					tbl_engagement te
				ON
					te.id = tes.engagement_id
		";
		$sqlQuery = new SqlQuery($sql);
		return QueryExecutor::execute($sqlQuery);
	}
	function getEngagementDetails($eng){
		$sql = "
				SELECT 
					tc.client_no,
					tc.`client`,
					tc.contract_price,
					tc.`type` client_type,
					te.engagement_no,
					te.engagement,
					tes.date_start,
					tes.date_end,
					tes.overall_budget_hours,
					tes.status,
					CONCAT(tn_referred_by.fname,' ',tn_referred_by.mname,' ',tn_referred_by.lname) referred_by,
					CONCAT(tn_initiated_by.fname,' ',tn_initiated_by.mname,' ',tn_initiated_by.lname) initiated_by,
					CONCAT(tn_closed_by.fname,' ',tn_closed_by.mname,' ',tn_closed_by.lname) closed_by,
					CONCAT(tn_managed_by.fname,' ',tn_managed_by.mname,' ',tn_managed_by.lname) managed_by
				FROM
					tbl_engagement_setup tes
				INNER JOIN
					tbl_client tc
				ON
					tc.id = tes.client_id
				INNER JOIN
					tbl_engagement te
				ON	
					te.id = tes.engagement_id
				INNER JOIN
					tbl_key_accounts tka
				ON 	
					tka.id = tc.key_accounts_id
				INNER JOIN
					tbl_names tn_referred_by
				ON
					tn_referred_by.id = tka.referred_by
				INNER JOIN
					tbl_names tn_initiated_by
				ON
					tn_initiated_by.id = tka.initiated_by
				INNER JOIN
					tbl_names tn_closed_by
				ON
					tn_closed_by.id = tka.closed_by
				INNER JOIN
					tbl_names tn_managed_by
				ON
					tn_managed_by.id = tka.managed_by
					
				WHERE tes.id = $eng
		";
		$sqlQuery = new SqlQuery($sql);
		return QueryExecutor::execute($sqlQuery);
	}
	function getEngagementBudget($eng){
		$sql = "
				SELECT 
					tp.id,
					tp.position_no,
					tp.position,
					tbhpp.budget_hours
									
				FROM
					tbl_engagement_setup tes
				INNER JOIN
					tbl_budget_hours_per_position tbhpp
				ON
					tbhpp.engagement_setup_id = tes.id
				INNER JOIN
					tbl_position tp
				ON	
					tp.id = tbhpp.position_id

				WHERE tes.id = $eng
		";
		$sqlQuery = new SqlQuery($sql);
		return QueryExecutor::execute($sqlQuery);
	}
}
?>