<?php
/**
 * Class that operate on table 'tbl_analysis'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2018-02-26 06:14
 */
class TblAnalysisMySqlDAO implements TblAnalysisDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @return TblAnalysisMySql 
	 */
	public function load($id){
		$sql = 'SELECT * FROM tbl_analysis WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($id);
		return $this->getRow($sqlQuery);
	}

	/**
	 * Get all records from table
	 */
	public function queryAll(){
		$sql = 'SELECT * FROM tbl_analysis';
		$sqlQuery = new SqlQuery($sql);
		return $this->getList($sqlQuery);
	}
	
	/**
	 * Get all records from table ordered by field
	 *
	 * @param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn){
		$sql = 'SELECT * FROM tbl_analysis ORDER BY '.$orderColumn;
		$sqlQuery = new SqlQuery($sql);
		return $this->getList($sqlQuery);
	}
	
	/**
 	 * Delete record from table
 	 * @param tblAnalysi primary key
 	 */
	public function delete($id){
		$sql = 'DELETE FROM tbl_analysis WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($id);
		return $this->executeUpdate($sqlQuery);
	}
	
	/**
 	 * Insert record to table
 	 *
 	 * @param TblAnalysisMySql tblAnalysi
 	 */
	public function insert($tblAnalysi){
		$sql = 'INSERT INTO tbl_analysis (subsync_id, subdomain, user_id, type, remarks, analysis_date, created_by, modified_by, date_created, date_modified) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)';
		$sqlQuery = new SqlQuery($sql);
		
		$sqlQuery->setNumber($tblAnalysi->subsyncId);
		$sqlQuery->setNumber($tblAnalysi->subdomain);
		$sqlQuery->setNumber($tblAnalysi->userId);
		$sqlQuery->set($tblAnalysi->type);
		$sqlQuery->set($tblAnalysi->remarks);
		$sqlQuery->set($tblAnalysi->analysisDate);
		$sqlQuery->setNumber($tblAnalysi->createdBy);
		$sqlQuery->setNumber($tblAnalysi->modifiedBy);
		$sqlQuery->set($tblAnalysi->dateCreated);
		$sqlQuery->set($tblAnalysi->dateModified);

		$id = $this->executeInsert($sqlQuery);	
		$tblAnalysi->id = $id;
		return $id;
	}
	
	/**
 	 * Update record in table
 	 *
 	 * @param TblAnalysisMySql tblAnalysi
 	 */
	public function update($tblAnalysi){
		$sql = 'UPDATE tbl_analysis SET subsync_id = ?, subdomain = ?, user_id = ?, type = ?, remarks = ?, analysis_date = ?, created_by = ?, modified_by = ?, date_created = ?, date_modified = ? WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		
		$sqlQuery->setNumber($tblAnalysi->subsyncId);
		$sqlQuery->setNumber($tblAnalysi->subdomain);
		$sqlQuery->setNumber($tblAnalysi->userId);
		$sqlQuery->set($tblAnalysi->type);
		$sqlQuery->set($tblAnalysi->remarks);
		$sqlQuery->set($tblAnalysi->analysisDate);
		$sqlQuery->setNumber($tblAnalysi->createdBy);
		$sqlQuery->setNumber($tblAnalysi->modifiedBy);
		$sqlQuery->set($tblAnalysi->dateCreated);
		$sqlQuery->set($tblAnalysi->dateModified);

		$sqlQuery->setNumber($tblAnalysi->id);
		return $this->executeUpdate($sqlQuery);
	}

	/**
 	 * Delete all rows
 	 */
	public function clean(){
		$sql = 'DELETE FROM tbl_analysis';
		$sqlQuery = new SqlQuery($sql);
		return $this->executeUpdate($sqlQuery);
	}

	public function queryBySubsyncId($value){
		$sql = 'SELECT * FROM tbl_analysis WHERE subsync_id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryBySubdomain($value){
		$sql = 'SELECT * FROM tbl_analysis WHERE subdomain = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByUserId($value){
		$sql = 'SELECT * FROM tbl_analysis WHERE user_id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByType($value){
		$sql = 'SELECT * FROM tbl_analysis WHERE type = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByRemarks($value){
		$sql = 'SELECT * FROM tbl_analysis WHERE remarks = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByAnalysisDate($value){
		$sql = 'SELECT * FROM tbl_analysis WHERE analysis_date = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByCreatedBy($value){
		$sql = 'SELECT * FROM tbl_analysis WHERE created_by = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByModifiedBy($value){
		$sql = 'SELECT * FROM tbl_analysis WHERE modified_by = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByDateCreated($value){
		$sql = 'SELECT * FROM tbl_analysis WHERE date_created = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByDateModified($value){
		$sql = 'SELECT * FROM tbl_analysis WHERE date_modified = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}


	public function deleteBySubsyncId($value){
		$sql = 'DELETE FROM tbl_analysis WHERE subsync_id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteBySubdomain($value){
		$sql = 'DELETE FROM tbl_analysis WHERE subdomain = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByUserId($value){
		$sql = 'DELETE FROM tbl_analysis WHERE user_id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByType($value){
		$sql = 'DELETE FROM tbl_analysis WHERE type = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByRemarks($value){
		$sql = 'DELETE FROM tbl_analysis WHERE remarks = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByAnalysisDate($value){
		$sql = 'DELETE FROM tbl_analysis WHERE analysis_date = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByCreatedBy($value){
		$sql = 'DELETE FROM tbl_analysis WHERE created_by = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByModifiedBy($value){
		$sql = 'DELETE FROM tbl_analysis WHERE modified_by = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByDateCreated($value){
		$sql = 'DELETE FROM tbl_analysis WHERE date_created = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByDateModified($value){
		$sql = 'DELETE FROM tbl_analysis WHERE date_modified = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}


	
	/**
	 * Read row
	 *
	 * @return TblAnalysisMySql 
	 */
	protected function readRow($row){
		$tblAnalysi = new TblAnalysi();
		
		$tblAnalysi->id = $row['id'];
		$tblAnalysi->subsyncId = $row['subsync_id'];
		$tblAnalysi->subdomain = $row['subdomain'];
		$tblAnalysi->userId = $row['user_id'];
		$tblAnalysi->type = $row['type'];
		$tblAnalysi->remarks = $row['remarks'];
		$tblAnalysi->analysisDate = $row['analysis_date'];
		$tblAnalysi->createdBy = $row['created_by'];
		$tblAnalysi->modifiedBy = $row['modified_by'];
		$tblAnalysi->dateCreated = $row['date_created'];
		$tblAnalysi->dateModified = $row['date_modified'];

		return $tblAnalysi;
	}
	
	protected function getList($sqlQuery){
		$tab = QueryExecutor::execute($sqlQuery);
		$ret = array();
		for($i=0;$i<count($tab);$i++){
			$ret[$i] = $this->readRow($tab[$i]);
		}
		return $ret;
	}
	
	/**
	 * Get row
	 *
	 * @return TblAnalysisMySql 
	 */
	protected function getRow($sqlQuery){
		$tab = QueryExecutor::execute($sqlQuery);
		if(count($tab)==0){
			return null;
		}
		return $this->readRow($tab[0]);		
	}
	
	/**
	 * Execute sql query
	 */
	protected function execute($sqlQuery){
		return QueryExecutor::execute($sqlQuery);
	}
	
		
	/**
	 * Execute sql query
	 */
	protected function executeUpdate($sqlQuery){
		return QueryExecutor::executeUpdate($sqlQuery);
	}

	/**
	 * Query for one row and one column
	 */
	protected function querySingleResult($sqlQuery){
		return QueryExecutor::queryForString($sqlQuery);
	}

	/**
	 * Insert row to table
	 */
	protected function executeInsert($sqlQuery){
		return QueryExecutor::executeInsert($sqlQuery);
	}
}
?>