<?php
/**
 * Class that operate on table 'tbl_project_activities'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2013-03-06 02:40
 */
class TblProjectActivitiesMySqlExtDAO extends TblProjectActivitiesMySqlDAO{

	static function getProjectActivities($groupId, $from, $to, $company = '%%'){
		$group = "SELECT id FROM tbl_user_group WHERE grp_id = '".$groupId."'";
		$groupAccess = "SELECT user_id FROM tbl_group_access WHERE group_id IN (".$group.") ";
		$dprTrans = "SELECT id FROM tbl_dpr_transaction WHERE DATE(date) >= '".$from."' AND DATE(date) <= '".$to."' AND status = 'done'
			AND user_id IN (".$groupAccess.") ";
		$dprecords = "SELECT activity FROM tbl_dprecords WHERE trans_id IN (".$dprTrans.") GROUP BY activity";
		//echo $txt1 = "SELECT * FROM tbl_project_activities WHERE id IN (".$dprecords.")";
		
		//$txt = "SELECT * FROM tbl_client_project WHERE id IN (".$project.")";
		$txt = "SELECT tpa.* FROM tbl_project_activities as tpa, tbl_user_group as tug, tbl_group_access as tga, tbl_dpr_transaction as tdt, 
			tbl_dprecords as td WHERE tpa.id = td.activity AND td.trans_id = tdt.id AND DATE(tdt.date) >= '".$from."' AND DATE(tdt.date) <= '".$to."' 
			AND tdt.status = 'done' AND tdt.user_id = tga.user_id AND tga.group_id = tug.id AND tug.grp_id = '".$groupId."' ";
		
		$txt = "
			SELECT tpa.* FROM
				tbl_project_activities tpa
				INNER JOIN tbl_dprecords td ON td.activity = tpa.id
				INNER JOIN tbl_dpr_transaction tdt ON tdt.id = td.trans_id
				INNER JOIN tbl_user u ON u.id = tdt.user_id
				INNER JOIN tbl_group_access tga ON tga.user_id = tdt.user_id
				
				WHERE
				
				DATE(tdt.date) >= '".$from."' AND 
				DATE(tdt.date) <= '".$to."' AND 
				tga.group_id = ".$groupId." AND 
				u.company LIKE '".$company."'
				
				GROUP BY tpa.id
		";
		
		$sqlQuery = new SqlQuery($txt);
		
		return self::getProjectAcivities($sqlQuery);
	}
	
	static function actNumberExist($projectId, $actNumber, $id = 0){
		$other = $id != 0 ? " AND id != ".$id." " : "";
		$txt = "SELECT * FROM tbl_project_activities WHERE project_id = ? AND act_number = ? ".$other;
		$sqlQuery = new SqlQuery($txt);
		
		$sqlQuery->set($projectId);
		$sqlQuery->set($actNumber);
		
		$tab = QueryExecutor::execute($sqlQuery);
		if(empty($tab)){
			return false;
		} else {
			return true;
		}
	}
	
	static function searchProjectAct($projectId, $keyword = ''){
		$search = '';
		if($keyword != ''){
			$search = " AND act_id IN (SELECT id from tbl_activity_purpose WHERE purpose LIKE '%".$keyword."%') ";
		}
		$txt = "SELECT tbl_project_activities.* from tbl_project_activities, tbl_client_project WHERE 
			tbl_client_project.id = tbl_project_activities.project_id AND tbl_project_activities.project_id = ".$projectId." ".$search." ";
		
		/*$txt = "
			SELECT
				@s:=@s+1  line_number, tpa.act_number, tap.purpose,
				
				case tpa.grp_id
				when '0' then 'None'
				else tga.group_id
				end as line_property,
				tpa.id
				
				FROM (SELECT @s:= 0) AS s, tbl_project_activities tpa 
				LEFT JOIN ( SELECT * FROM tbl_group_activity ) tga ON tpa.grp_id=tga.id
				LEFT JOIN ( SELECT * FROM tbl_activity_purpose ) tap ON tap.id=tpa.act_id
				
				WHERE tpa.project_id = ".$projectId." ".$search." 
		";*/
		$sqlQuery = new SqlQuery($txt);
		
		return self::getProjectAcivities($sqlQuery);
	}
	
	static function searchProjectActivity($projectId, $keyword = ''){
		$search = '';
		if($keyword != ''){
			$search = " AND tpa.act_id IN (SELECT id from tbl_activity_purpose WHERE purpose LIKE '%".$keyword."%') ";
		}
		//$txt = "SELECT * from tbl_project_activities WHERE project_id = ".$projectId." ".$search." ";
		
		$txt = "
			SELECT
				@s:=@s+1  line_number, tpa.act_number, tap.purpose,
				
				case tpa.grp_id
				when '0' then 'None'
				else tga.group_id
				end as line_property,
				tpa.id
				
				FROM (SELECT @s:= 0) AS s, tbl_project_activities tpa 
				LEFT JOIN ( SELECT * FROM tbl_group_activity ) tga ON tpa.grp_id=tga.id
				LEFT JOIN ( SELECT * FROM tbl_activity_purpose ) tap ON tap.id=tpa.act_id
				
				WHERE tpa.project_id = ".$projectId." ".$search." 
		";
		
		$sqlQuery = new SqlQuery($txt);
		
		return self::getProjectAcivities2($sqlQuery);
	}
	
	static function searchActivityByGroup($groupId, $search = '' ){
		$keyword = $search == '' ? '' : " AND ( tap.purpose LIKE '%".$search."%' OR tpa.act_number LIKE '%".$search."%' ) ";
		
		$txt = "
			SELECT
				@s:=@s+1  line_number, tcp.project_id, tcp.projectname, tpa.act_number, tap.purpose,
				
				tpa.id
				
				FROM (SELECT @s:= 0) AS s, tbl_project_activities tpa 
				LEFT JOIN ( SELECT * FROM tbl_group_activity ) tga ON tpa.grp_id=tga.id
				LEFT JOIN ( SELECT * FROM tbl_client_project ) tcp ON tcp.id=tpa.project_id
				LEFT JOIN ( SELECT * FROM tbl_activity_purpose ) tap ON tap.id=tpa.act_id
				
				WHERE tpa.grp_id = ".$groupId." ".$keyword." GROUP BY tpa.id
		";
		
		$sqlQuery = new sqlQuery($txt);
		
		return self::getProjectAcivities2($sqlQuery);
	}
	
	static function searchProjectByActivityGroup($groupId, $search = '' ){
		$keyword = $search == '' ? '' : " AND ( tcp.project_id LIKE '%".$search."%' OR tcp.projectname LIKE '%".$search."%' ) ";
		
		$txt = "
			SELECT
				@s:=@s+1  line_number, tcp.project_id, tcp.projectname, tpa.act_number, tap.purpose,
				
				tpa.id
				
				FROM (SELECT @s:= 0) AS s, tbl_project_activities tpa 
				LEFT JOIN ( SELECT * FROM tbl_group_activity ) tga ON tpa.grp_id=tga.id
				LEFT JOIN ( SELECT * FROM tbl_client_project ) tcp ON tcp.id=tpa.project_id
				LEFT JOIN ( SELECT * FROM tbl_activity_purpose ) tap ON tap.id=tpa.act_id
				
				WHERE tpa.grp_id = ".$groupId." ".$keyword." GROUP BY tpa.id
		";
		
		$sqlQuery = new sqlQuery($txt);
		
		return self::getProjectAcivities2($sqlQuery);
	}
	
	static function setPurposeInGroup($groupId, $purpose, $setAll = '', $id = 0){
		$set = $setAll == '' ? "" : " AND grp_id = 0 ";
		$setId = $id == 0 ? "" : " AND id = ".$id." ";
		$txt = "UPDATE tbl_project_activities 
			set grp_id = ".$groupId." 
			WHERE act_id = ".$purpose." ".$set." ".$setId."
		";
		
		$sqlQuery = new sqlQuery($txt);
		
		QueryExecutor::executeUpdate($sqlQuery);
	}
	
	static function getActivityByProjectId($projectId, $activityId){
		$txt = "
			SELECT tpa.*
			
			FROM tbl_project_activities tpa
			INNER JOIN tbl_client_project tcp ON tcp.id = tpa.project_id
			
			WHERE
			tcp.project_id LIKE '".$projectId."' AND tpa.act_number LIKE '".actvityId."'
			GROUP BY tpa.id
		";
		
		$sqlQuery = new SqlQuery($txt);
		
		return self::getProjectAcivities($sqlQuery);
	}
	
	protected static function getProjectAcivities($sqlQuery){
		$tab = QueryExecutor::execute($sqlQuery);
		if(empty($tab)){ return false; }
		$results = array();
		foreach($tab as $each){
			$result = new TblProjectActivitie();
			$result->id = $each['id'];
			$result->actNumber = $each['act_number'];
			$result->projectId = $each['project_id'];
			$result->grpId = $each['grp_id'];
			$result->actId = $each['act_id'];
			$results[] = $result;
		}
		return $results;
	}
	
	protected static function getProjectAcivities2($sqlQuery){
		$tab = QueryExecutor::execute($sqlQuery);
		if(empty($tab)){ return false; }
		$results = array();
		foreach($tab as $each){
			$result = array();
			$num = count($each)/2;
			/*echo '<pre>';
			print_r($each);
			echo '</pre>';*/
			for( $i = 0; $i < $num ; $i++ ){
				$result[] = $each[$i];
			}
			
			$results[] = $result;
			
		}
		
		return $results;
	}
}
?>