<?php
/**
 * Class that operate on table 'tbl_user1'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2017-04-03 05:19
 */
class TblUser1MySqlDAO implements TblUser1DAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @return TblUser1MySql 
	 */
	public function load($id){
		$sql = 'SELECT * FROM tbl_user1 WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($id);
		return $this->getRow($sqlQuery);
	}

	/**
	 * Get all records from table
	 */
	public function queryAll(){
		$sql = 'SELECT * FROM tbl_user1';
		$sqlQuery = new SqlQuery($sql);
		return $this->getList($sqlQuery);
	}
	
	/**
	 * Get all records from table ordered by field
	 *
	 * @param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn){
		$sql = 'SELECT * FROM tbl_user1 ORDER BY '.$orderColumn;
		$sqlQuery = new SqlQuery($sql);
		return $this->getList($sqlQuery);
	}
	
	/**
 	 * Delete record from table
 	 * @param tblUser1 primary key
 	 */
	public function delete($id){
		$sql = 'DELETE FROM tbl_user1 WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($id);
		return $this->executeUpdate($sqlQuery);
	}
	
	/**
 	 * Insert record to table
 	 *
 	 * @param TblUser1MySql tblUser1
 	 */
	public function insert($tblUser1){
		$sql = 'INSERT INTO tbl_user1 (company, company_id, username, password, firstname, midname, lastname, position, email, dateRegistered, userType, userStatus, department, costCenter, category) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)';
		$sqlQuery = new SqlQuery($sql);
		
		$sqlQuery->setNumber($tblUser1->company);
		$sqlQuery->set($tblUser1->companyId);
		$sqlQuery->set($tblUser1->username);
		$sqlQuery->set($tblUser1->password);
		$sqlQuery->set($tblUser1->firstname);
		$sqlQuery->set($tblUser1->midname);
		$sqlQuery->set($tblUser1->lastname);
		$sqlQuery->set($tblUser1->position);
		$sqlQuery->set($tblUser1->email);
		$sqlQuery->set($tblUser1->dateRegistered);
		$sqlQuery->set($tblUser1->userType);
		$sqlQuery->set($tblUser1->userStatus);
		$sqlQuery->set($tblUser1->department);
		$sqlQuery->set($tblUser1->costCenter);
		$sqlQuery->set($tblUser1->category);

		$id = $this->executeInsert($sqlQuery);	
		$tblUser1->id = $id;
		return $id;
	}
	
	/**
 	 * Update record in table
 	 *
 	 * @param TblUser1MySql tblUser1
 	 */
	public function update($tblUser1){
		$sql = 'UPDATE tbl_user1 SET company = ?, company_id = ?, username = ?, password = ?, firstname = ?, midname = ?, lastname = ?, position = ?, email = ?, dateRegistered = ?, userType = ?, userStatus = ?, department = ?, costCenter = ?, category = ? WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		
		$sqlQuery->setNumber($tblUser1->company);
		$sqlQuery->set($tblUser1->companyId);
		$sqlQuery->set($tblUser1->username);
		$sqlQuery->set($tblUser1->password);
		$sqlQuery->set($tblUser1->firstname);
		$sqlQuery->set($tblUser1->midname);
		$sqlQuery->set($tblUser1->lastname);
		$sqlQuery->set($tblUser1->position);
		$sqlQuery->set($tblUser1->email);
		$sqlQuery->set($tblUser1->dateRegistered);
		$sqlQuery->set($tblUser1->userType);
		$sqlQuery->set($tblUser1->userStatus);
		$sqlQuery->set($tblUser1->department);
		$sqlQuery->set($tblUser1->costCenter);
		$sqlQuery->set($tblUser1->category);

		$sqlQuery->setNumber($tblUser1->id);
		return $this->executeUpdate($sqlQuery);
	}

	/**
 	 * Delete all rows
 	 */
	public function clean(){
		$sql = 'DELETE FROM tbl_user1';
		$sqlQuery = new SqlQuery($sql);
		return $this->executeUpdate($sqlQuery);
	}

	public function queryByCompany($value){
		$sql = 'SELECT * FROM tbl_user1 WHERE company = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByCompanyId($value){
		$sql = 'SELECT * FROM tbl_user1 WHERE company_id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByUsername($value){
		$sql = 'SELECT * FROM tbl_user1 WHERE username = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByPassword($value){
		$sql = 'SELECT * FROM tbl_user1 WHERE password = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByFirstname($value){
		$sql = 'SELECT * FROM tbl_user1 WHERE firstname = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByMidname($value){
		$sql = 'SELECT * FROM tbl_user1 WHERE midname = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByLastname($value){
		$sql = 'SELECT * FROM tbl_user1 WHERE lastname = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByPosition($value){
		$sql = 'SELECT * FROM tbl_user1 WHERE position = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByEmail($value){
		$sql = 'SELECT * FROM tbl_user1 WHERE email = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByDateRegistered($value){
		$sql = 'SELECT * FROM tbl_user1 WHERE dateRegistered = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByUserType($value){
		$sql = 'SELECT * FROM tbl_user1 WHERE userType = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByUserStatus($value){
		$sql = 'SELECT * FROM tbl_user1 WHERE userStatus = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByDepartment($value){
		$sql = 'SELECT * FROM tbl_user1 WHERE department = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByCostCenter($value){
		$sql = 'SELECT * FROM tbl_user1 WHERE costCenter = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByCategory($value){
		$sql = 'SELECT * FROM tbl_user1 WHERE category = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}


	public function deleteByCompany($value){
		$sql = 'DELETE FROM tbl_user1 WHERE company = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByCompanyId($value){
		$sql = 'DELETE FROM tbl_user1 WHERE company_id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByUsername($value){
		$sql = 'DELETE FROM tbl_user1 WHERE username = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByPassword($value){
		$sql = 'DELETE FROM tbl_user1 WHERE password = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByFirstname($value){
		$sql = 'DELETE FROM tbl_user1 WHERE firstname = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByMidname($value){
		$sql = 'DELETE FROM tbl_user1 WHERE midname = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByLastname($value){
		$sql = 'DELETE FROM tbl_user1 WHERE lastname = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByPosition($value){
		$sql = 'DELETE FROM tbl_user1 WHERE position = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByEmail($value){
		$sql = 'DELETE FROM tbl_user1 WHERE email = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByDateRegistered($value){
		$sql = 'DELETE FROM tbl_user1 WHERE dateRegistered = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByUserType($value){
		$sql = 'DELETE FROM tbl_user1 WHERE userType = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByUserStatus($value){
		$sql = 'DELETE FROM tbl_user1 WHERE userStatus = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByDepartment($value){
		$sql = 'DELETE FROM tbl_user1 WHERE department = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByCostCenter($value){
		$sql = 'DELETE FROM tbl_user1 WHERE costCenter = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByCategory($value){
		$sql = 'DELETE FROM tbl_user1 WHERE category = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}


	
	/**
	 * Read row
	 *
	 * @return TblUser1MySql 
	 */
	protected function readRow($row){
		$tblUser1 = new TblUser1();
		
		$tblUser1->id = $row['id'];
		$tblUser1->company = $row['company'];
		$tblUser1->companyId = $row['company_id'];
		$tblUser1->username = $row['username'];
		$tblUser1->password = $row['password'];
		$tblUser1->firstname = $row['firstname'];
		$tblUser1->midname = $row['midname'];
		$tblUser1->lastname = $row['lastname'];
		$tblUser1->position = $row['position'];
		$tblUser1->email = $row['email'];
		$tblUser1->dateRegistered = $row['dateRegistered'];
		$tblUser1->userType = $row['userType'];
		$tblUser1->userStatus = $row['userStatus'];
		$tblUser1->department = $row['department'];
		$tblUser1->costCenter = $row['costCenter'];
		$tblUser1->category = $row['category'];

		return $tblUser1;
	}
	
	protected function getList($sqlQuery){
		$tab = QueryExecutor::execute($sqlQuery);
		$ret = array();
		for($i=0;$i<count($tab);$i++){
			$ret[$i] = $this->readRow($tab[$i]);
		}
		return $ret;
	}
	
	/**
	 * Get row
	 *
	 * @return TblUser1MySql 
	 */
	protected function getRow($sqlQuery){
		$tab = QueryExecutor::execute($sqlQuery);
		if(count($tab)==0){
			return null;
		}
		return $this->readRow($tab[0]);		
	}
	
	/**
	 * Execute sql query
	 */
	protected function execute($sqlQuery){
		return QueryExecutor::execute($sqlQuery);
	}
	
		
	/**
	 * Execute sql query
	 */
	protected function executeUpdate($sqlQuery){
		return QueryExecutor::executeUpdate($sqlQuery);
	}

	/**
	 * Query for one row and one column
	 */
	protected function querySingleResult($sqlQuery){
		return QueryExecutor::queryForString($sqlQuery);
	}

	/**
	 * Insert row to table
	 */
	protected function executeInsert($sqlQuery){
		return QueryExecutor::executeInsert($sqlQuery);
	}
}
?>