<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2017-04-03 05:19
 */
interface TblProjectActivitiesDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return TblProjectActivities 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param tblProjectActivitie primary key
 	 */
	public function delete($id);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param TblProjectActivities tblProjectActivitie
 	 */
	public function insert($tblProjectActivitie);
	
	/**
 	 * Update record in table
 	 *
 	 * @param TblProjectActivities tblProjectActivitie
 	 */
	public function update($tblProjectActivitie);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryByActNumber($value);

	public function queryByProjectId($value);

	public function queryByActId($value);

	public function queryByGrpId($value);


	public function deleteByActNumber($value);

	public function deleteByProjectId($value);

	public function deleteByActId($value);

	public function deleteByGrpId($value);


}
?>