<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2017-04-03 05:19
 */
interface TblDepartmentDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return TblDepartment 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param tblDepartment primary key
 	 */
	public function delete($id);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param TblDepartment tblDepartment
 	 */
	public function insert($tblDepartment);
	
	/**
 	 * Update record in table
 	 *
 	 * @param TblDepartment tblDepartment
 	 */
	public function update($tblDepartment);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryByCompany($value);

	public function queryByNumber($value);

	public function queryByDescription($value);


	public function deleteByCompany($value);

	public function deleteByNumber($value);

	public function deleteByDescription($value);


}
?>