<?php
 	header("Content-type: application/vnd.ms-excel");
	header("Content-Disposition: attachment; filename=nbtReport.xls");
	header("Pragma: no-cache");
	header("Expires: 0");
?>
<style>
	.table
	{
		width: 100%;
		max-width: 100%;
		margin-bottom: 20px;
	}
	table
	{
		border-spacing: 0;
		border-collapse: collapse;
	}
	table
	{
		white-space: normal;
		line-height: normal;
		font-weight: normal;
		font-size: medium;
		font-variant: normal;
		font-style: normal;
		color: -webkit-text;
		text-align: start;
	}
	table
	{
		display: table;
		border-collapse: separate;
		border-spacing: 2px;
		border-color: grey;
	}
	.table-bordered>tbody>tr>td, .table-bordered>tbody>tr>th, .table-bordered>tfoot>tr>td, .table-bordered>tfoot>tr>th, .table-bordered>thead>tr>td, .table-bordered>thead>tr>th {
    border: 1px solid #ddd;
}

	tr
	{
		display: table-row;
		vertical-align: inherit;
		border-color: inherit;
	}
	.table>tbody>tr>th, .table>tfoot>tr>td, .table>tfoot>tr>th, .table>thead>tr>td, .table>thead>tr>th {
		padding: 8px;
		line-height: 1.42857143;
		vertical-align: top;
		border-top: 1px solid #ddd;
	}
	th
	{
		font-weight: bold;
	}
	td, th
	{
		display: table-cell;
		vertical-align: inherit;
	}
	.table>tbody>tr>td,
	.table>tbody>tr>th,
	.table>tfoot>tr>td,
	.table>tfoot>tr>th,
	.table>thead>tr>td,
	 .table>thead>tr>th
	 {
		padding: 8px;
		line-height: 1.42857143;
		vertical-align: top;
		border-top: 1px solid #ddd;
	}
	td, th
	{
		display: table-cell;
		vertical-align: inherit;
	}
	.table th, td
	{
		text-align: center;
	}
	.success
	{
		background:#d6e9c6
	}
	.pull-right
	{
		float:right
	}
</style>
<?php

	$data = DAOFactory::getTblDailyForecastDAO()->getNbtTrans($_REQUEST['userId'], $_REQUEST['date']);
 ?>
<table class="table table-bordered hover ">
	<tr class="success">
		<th class="text-center">Client</th>
		<th class="text-center">Engagement</th>
		<th class="text-center">TBA</th>
		<th class="text-center">NBT</th>
		<th class="text-center">Target</th>
		<th class="text-center">Actual Target</th>
		<?php 
			$time = DAOFactory::getTblDailyForecastDAO()->getNbtTime($_REQUEST['userId'], $_REQUEST['date'], 0);
			foreach ($time as $title):
		 ?>
		 <th class="text-center"><?=$title['description']?></th>
		<?php endforeach; ?>
	</tr>
	<tbody class="data_nbt_report">
		<?php foreach ($data as  $value):?>
			<tr>
			<td><?= $value['client'] ?></td>
			<td><?=  $value['engagement'] ?></td>
			<td><?=  $value['tba'] ?></td>
			<td><?=  $value['nbt'] ?></td>
			<td><?=  $value['target'] ?></td>
			<td><?=  $value['quantity'] == '' ? 0 : $value['quantity'] ?></td>
			<?php
			$trans = DAOFactory::getTblDailyForecastDAO()->getNbtTime($_REQUEST['userId'], $_REQUEST['date'], $value['dailyForecastId']); 
				foreach ($trans as $nbt):
			?>
			<td><?=$nbt['quantity']?></td>
			<?php endforeach; ?>
			</tr>

		<?php endforeach; ?>
	</tbody>
</table>