<?php
/**
 * Class that operate on table 'tbl_nbt_transaction'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2018-01-24 11:22
 */
class TblNbtTransactionMySqlExtDAO extends TblNbtTransactionMySqlDAO{
	function showSubperDept($subdomain){
		$sql = "
			SELECT
				sub_per_dept.subdomain_id,
				dept.id dept_id,
				dept.department
			FROM tbl_subdomain_per_dept sub_per_dept
			
			INNER JOIN tbl_department dept
				ON dept.id = sub_per_dept.department_id
			
			WHERE dept.`status` LIKE '%enabled%' 
			AND sub_per_dept.subdomain_id = '$subdomain'
		";
		$sqlQuery = new SqlQuery($sql);
		return QueryExecutor::execute($sqlQuery);
	}
	function dprReport($date, $subdomain, $department){
		
		$sql = "SELECT
					u.id user_id,
					u.subdomain,
					u.username,
					u_info.company_identification,
					CONCAT(u_info.lname,', ',u_info.fname,' ',u_info.mname) name,
					p.position,
					IF(nbt.status = 'pending' OR nbt.status IS NULL, 'no report', nbt.status) nbt,
					nbt.nbt_id
				FROM tbl_user u
				INNER JOIN
					tbl_user_info u_info
				ON u_info.user_id = u.id
				INNER JOIN
					tbl_position p
				ON p.id = u_info.position_id
				LEFT JOIN
					(
						SELECT 
							nbt_trans.subsync_id nbt_id,
							nbt_trans.user_id,
							nbt_trans.status
						FROM tbl_nbt_transaction nbt_trans
						WHERE DATE(nbt_trans.to_do_date) = '$date'
						AND nbt_trans.subdomain = $subdomain
					) nbt
				ON nbt.user_id = u.id
				WHERE u.subdomain = '$subdomain'
				AND u_info.department_id LIKE '$department'
				ORDER BY u_info.lname
				";
		$sqlQuery = new SqlQuery($sql);
		return QueryExecutor::execute($sqlQuery);
	}	
	function dprReport2($date, $subdomain){
		
		$sql = "SELECT
					u.id user_id,
					u.subdomain,
					u.username,
					u_info.company_identification,
					CONCAT(u_info.lname,', ',u_info.fname,' ',u_info.mname) name,
					p.position,
					IF(nbt.status = 'pending' OR nbt.status IS NULL, 'no report', nbt.status) nbt,
					nbt.nbt_id
				FROM tbl_user u
				INNER JOIN
					tbl_user_info u_info
				ON u_info.user_id = u.id
				LEFT JOIN
					tbl_position p
				ON p.id = u_info.position_id
				LEFT JOIN tbl_employee_status emp_stat
					ON emp_stat.id = u_info.employee_status
				LEFT JOIN
					(
						SELECT 
							nbt_trans.subsync_id nbt_id,
							nbt_trans.user_id,
							nbt_trans.status
						FROM tbl_nbt_transaction nbt_trans
						WHERE DATE(nbt_trans.to_do_date) = '$date'
						AND nbt_trans.subdomain = $subdomain
					) nbt
				ON nbt.user_id = u.id
				WHERE u.subdomain = '$subdomain'
				AND emp_stat.emp_status LIKE '%active%'
				ORDER BY u_info.lname
				";
		$sqlQuery = new SqlQuery($sql);
		return QueryExecutor::execute($sqlQuery);
	}	
	function dprReportSummary($id,$uid,$sub){
		$sql = "				
			SELECT 
				tc.`client`,
				te.engagement,
				tba.tba,
				nbt.nbt,
				SUM(tdfpt.target) target,
				IF(SUM(tna.quantity) IS NULL,0,SUM(tna.quantity)) actual
			FROM tbl_nbt_transaction nbt_trans
			
			INNER JOIN tbl_nbt_hours_spent nhs
				ON nhs.nbt_transaction_id = nbt_trans.subsync_id
				AND nhs.subdomain = '$sub'
			INNER JOIN tbl_daily_forecast df
				ON df.subsync_id = nhs.daily_forecast_id
				AND df.subdomain = '$sub'
			INNER JOIN tbl_daily_forecast_per_time tdfpt
				ON tdfpt.daily_forecast_id = df.subsync_id
				AND tdfpt.subdomain = '$sub'
			LEFT JOIN tbl_nbt_actual tna
				ON tna.daily_forecast_per_time_id = tdfpt.subsync_id
				AND tna.subdomain = '$sub'
			INNER JOIN tbl_forecast_transaction tft
				ON tft.subsync_id = df.forecast_transaction_id
				AND tft.subdomain = '$sub'
			INNER JOIN tbl_client tc
				ON tc.id = tft.client_id
			INNER JOIN tbl_engagement te
				ON te.id = tft.engagement_id
			INNER JOIN tbl_tba tba
				ON tba.id = tft.tba_id
			INNER JOIN tbl_nbt nbt
				ON nbt.id = tft.nbt_id
				
			WHERE nbt_trans.subsync_id = '$id'
			AND nbt_trans.subdomain = '$sub'
			AND nbt_trans.user_id = '$uid'
			
			GROUP BY df.id
		";
		$sqlQuery = new SqlQuery($sql);
		return QueryExecutor::execute($sqlQuery);
	}
	function darReport($from,$to,$subdomain,$status){
		$sql = "
		SELECT * FROM (
			SELECT
				ui.user_id,
				ui.lname,
				CONCAT(ui.fname,' ',ui.mname) given_name,
				IF(approve.id IS NULL, 'pending', 'approved') approve_status,
				IF(approve.id IS NULL, '', approve.date_approve) approve_date,
				ui.date_hired,
				IF(RT.RT != '', RT.RT,0)RT,
				IF(ROT.ROT != '', TRUNCATE(ROT.ROT,2),0)ROT,
				IF(LH.LH != '', TRUNCATE(LH.LH,2),0)LH,
				IF(LHE.LHE != '', TRUNCATE(LHE.LHE,2),0)LHE,
				IF(NDOT.NDOT != '', TRUNCATE(NDOT.NDOT,2),0)NDOT,
				IF(NSD.NSD != '', TRUNCATE(NSD.NSD,2),0)NSD,
				IF(SHOT.SHOT != '', TRUNCATE(SHOT.SHOT,2),0)SHOT,
				IF(SHOTE.SHOTE != '', TRUNCATE(SHOTE.SHOTE,2),0)SHOTE,
				IF(SH.SH != '', TRUNCATE(SH.SH,2),0)SH,
				IF(SHE.SHE != '', TRUNCATE(SHE.SHE,2),0)SHE,
				IF(SOT.SOT != '', TRUNCATE(SOT.SOT,2),0)SOT,
				IF(SOTE.SOTE != '', TRUNCATE(SOTE.SOTE,2),0)SOTE,
				IF(SRH.SRH != '', TRUNCATE(SRH.SRH,2),0)SRH,
				IF(SRHE.SRHE != '', TRUNCATE(SRHE.SRHE,2),0)SRHE,
				IF(LATE.LATE != '', TRUNCATE(LATE.LATE,2),0)LATE,
				IF(UT.UT != '', TRUNCATE(UT.UT,2),0)UT,
				IF(AL.AL != '', TRUNCATE(AL.AL,2),0)AL,
				IF(SL.SL != '', TRUNCATE(SL.SL,2),0)SL,
				IF(VL.VL != '', TRUNCATE(VL.VL,2),0)VL,
				IF(SIL.SIL != '', TRUNCATE(SIL.SIL,2),0)SIL,
				IF(reimbursement.reimbursement != '', TRUNCATE(reimbursement.reimbursement,2), 0)reimbursement
			FROM tbl_nbt_transaction nt
			INNER JOIN tbl_user_info ui
				ON ui.user_id = nt.user_id
			LEFT JOIN(
				SELECT
						*
					FROM tbl_nbt_approve n_approve
					WHERE n_approve.from_date = '$from'
					AND n_approve.to_date = '$to'
			)approve ON approve.user_id = ui.user_id
			LEFT JOIN(
				SELECT
						nt.user_id,
						nhs.nbt_transaction_id nt_id,
						IF(nhs.hours_spent != '',SUM(nhs.hours_spent),0) RT
					FROM tbl_nbt_hours_spent nhs
					
					INNER JOIN tbl_nbt_transaction nt
						ON nt.subsync_id = nhs.nbt_transaction_id
						AND nt.subdomain = '$subdomain'
					INNER JOIN tbl_hour_code hc
						ON hc.id = nhs.hour_code
					
					WHERE hc.hour_code = 'RT'
					AND nt.`status` = 'done'
					AND nt.to_do_date >= '$from' AND nt.to_do_date <= '$to'
					AND nhs.subdomain = '$subdomain'
					GROUP BY nt.user_id
			) RT ON RT.user_id = ui.user_id
				LEFT JOIN(
					SELECT
					nt.user_id,
					nhs.nbt_transaction_id nt_id,
					IF(nhs.hours_spent != '',SUM(nhs.hours_spent),0) ROT
				FROM tbl_nbt_hours_spent nhs
				
				INNER JOIN tbl_nbt_transaction nt
					ON nt.subsync_id = nhs.nbt_transaction_id
					AND nt.subdomain = '$subdomain'
				INNER JOIN tbl_hour_code hc
					ON hc.id = nhs.hour_code
				
				WHERE hc.hour_code = 'ROT'
				AND nt.`status` = 'done'
				AND nt.to_do_date >= '$from' AND nt.to_do_date <= '$to'
				AND nhs.subdomain = '$subdomain'
				GROUP BY nt.user_id
			) ROT ON ROT.user_id = ui.user_id
			LEFT JOIN(
				SELECT
					nt.user_id,
					nhs.nbt_transaction_id nt_id,
					IF(nhs.hours_spent != '',SUM(nhs.hours_spent),0) LH
				FROM tbl_nbt_hours_spent nhs
				
				INNER JOIN tbl_nbt_transaction nt
					ON nt.subsync_id = nhs.nbt_transaction_id
					AND nt.subdomain = '$subdomain'
				INNER JOIN tbl_hour_code hc
					ON hc.id = nhs.hour_code
				
				WHERE hc.hour_code = 'LH'
				AND nt.`status` = 'done'
				AND nt.to_do_date >= '$from' AND nt.to_do_date <= '$to'
				AND nhs.subdomain = '$subdomain'
				GROUP BY nt.user_id
			) LH ON LH.user_id = ui.user_id
			LEFT JOIN(
				SELECT
					nt.user_id,
					nhs.nbt_transaction_id nt_id,
					IF(nhs.hours_spent != '',SUM(nhs.hours_spent),0) LHE,
					GROUP_CONCAT(DISTINCT DAYOFMONTH(nt.to_do_date) separator ',') LHE_date
				FROM tbl_nbt_hours_spent nhs

				INNER JOIN tbl_nbt_transaction nt
					ON nt.subsync_id = nhs.nbt_transaction_id
					AND nt.subdomain = '$subdomain'
				INNER JOIN tbl_hour_code hc
					ON hc.id = nhs.hour_code

				WHERE hc.hour_code = 'LHE'
				AND nt.`status` = 'done'
				AND nt.to_do_date >= '$from' AND nt.to_do_date <= '$to'
				AND nhs.subdomain = '$subdomain'
				GROUP BY nt.user_id
			) LHE ON LHE.user_id = ui.user_id
			LEFT JOIN(
				SELECT
					nt.user_id,
					nhs.nbt_transaction_id nt_id,
					IF(nhs.hours_spent != '',SUM(nhs.hours_spent),0) NDOT,
					GROUP_CONCAT(DISTINCT DAYOFMONTH(nt.to_do_date) separator ',') NDOT_date
				FROM tbl_nbt_hours_spent nhs

				INNER JOIN tbl_nbt_transaction nt
					ON nt.subsync_id = nhs.nbt_transaction_id
					AND nt.subdomain = '$subdomain'
				INNER JOIN tbl_hour_code hc
					ON hc.id = nhs.hour_code

				WHERE hc.hour_code = 'NDOT'
				AND nt.`status` = 'done'
				AND nt.to_do_date >= '$from' AND nt.to_do_date <= '$to'
				AND nhs.subdomain = '$subdomain'
				GROUP BY nt.user_id
			) NDOT ON NDOT.user_id = nt.user_id
			LEFT JOIN(
				SELECT
					nt.user_id,
					nhs.nbt_transaction_id nt_id,
					IF(nhs.hours_spent != '',SUM(nhs.hours_spent),0) NSD,
					GROUP_CONCAT(DISTINCT DAYOFMONTH(nt.to_do_date) separator ',') NSD_date
				FROM tbl_nbt_hours_spent nhs

				INNER JOIN tbl_nbt_transaction nt
					ON nt.subsync_id = nhs.nbt_transaction_id
					AND nt.subdomain = '$subdomain'
				INNER JOIN tbl_hour_code hc
					ON hc.id = nhs.hour_code

				WHERE hc.hour_code = 'NSD'
				AND nt.`status` = 'done'
				AND nt.to_do_date >= '$from' AND nt.to_do_date <= '$to'
				AND nhs.subdomain = '$subdomain'
				GROUP BY nt.user_id
			)NSD ON NSD.user_id = NSD.user_id
			LEFT JOIN(
				SELECT
					nt.user_id,
					IF(nhs.hours_spent != '',SUM(nhs.hours_spent),0) SHOT,
					GROUP_CONCAT(DISTINCT DAYOFMONTH(nt.to_do_date) separator ',') SHOT_date
				FROM tbl_nbt_hours_spent nhs

				INNER JOIN tbl_nbt_transaction nt
					ON nt.subsync_id = nhs.nbt_transaction_id
					AND nt.subdomain = '$subdomain'
				INNER JOIN tbl_hour_code hc
					ON hc.id = nhs.hour_code

				WHERE hc.hour_code = 'SHOT'
				AND nt.`status` = 'done'
				AND nt.to_do_date >= '$from' AND nt.to_do_date <= '$to'
				AND nhs.subdomain = '$subdomain'
				GROUP BY nt.user_id
			)SHOT ON SHOT.user_id = SHOT.user_id
			LEFT JOIN(
				SELECT
					nt.user_id,
					IF(nhs.hours_spent != '',SUM(nhs.hours_spent),0) SH,
					GROUP_CONCAT(DISTINCT DAYOFMONTH(nt.to_do_date) separator ',') SH_date
				FROM tbl_nbt_hours_spent nhs

				INNER JOIN tbl_nbt_transaction nt
					ON nt.subsync_id = nhs.nbt_transaction_id
					AND nt.subdomain = '$subdomain'
				INNER JOIN tbl_hour_code hc
					ON hc.id = nhs.hour_code

				WHERE hc.hour_code = 'SH'
				AND nt.`status` = 'done'
				AND nt.to_do_date >= '$from' AND nt.to_do_date <= '$to'
				AND nhs.subdomain = '$subdomain'
				GROUP BY nt.user_id
			)SH ON SH.user_id = nt.user_id
			LEFT JOIN(
				SELECT
					nt.user_id,
					IF(nhs.hours_spent != '',SUM(nhs.hours_spent),0) SHE,
					GROUP_CONCAT(DISTINCT DAYOFMONTH(nt.to_do_date) separator ',') SHE_date
				FROM tbl_nbt_hours_spent nhs

				INNER JOIN tbl_nbt_transaction nt
					ON nt.subsync_id = nhs.nbt_transaction_id
					AND nt.subdomain = '$subdomain'
				INNER JOIN tbl_hour_code hc
					ON hc.id = nhs.hour_code

				WHERE hc.hour_code = 'SHE'
				AND nt.`status` = 'done'
				AND nt.to_do_date >= '$from' AND nt.to_do_date <= '$to'
				AND nhs.subdomain = '$subdomain'
				GROUP BY nt.user_id
			)SHE ON SHE.user_id = nt.user_id
			LEFT JOIN(
				SELECT
					nt.user_id,
					IF(nhs.hours_spent != '',SUM(nhs.hours_spent),0) SOT,
					GROUP_CONCAT(DISTINCT DAYOFMONTH(nt.to_do_date) separator ',') SOT_date
				FROM tbl_nbt_hours_spent nhs

				INNER JOIN tbl_nbt_transaction nt
					ON nt.subsync_id = nhs.nbt_transaction_id
					AND nt.subdomain = '$subdomain'
				INNER JOIN tbl_hour_code hc
					ON hc.id = nhs.hour_code

				WHERE hc.hour_code = 'SOT'
				AND nt.`status` = 'done'
				AND nt.to_do_date >= '$from' AND nt.to_do_date <= '$to'
				AND nhs.subdomain = '$subdomain'
				GROUP BY nt.user_id
			)SOT ON SOT.user_id = nt.user_id
			LEFT JOIN(
				SELECT
					nt.user_id,
					IF(nhs.hours_spent != '',SUM(nhs.hours_spent),0) SHOTE,
					GROUP_CONCAT(DISTINCT DAYOFMONTH(nt.to_do_date) separator ',') SHOTE_date
				FROM tbl_nbt_hours_spent nhs

				INNER JOIN tbl_nbt_transaction nt
					ON nt.subsync_id = nhs.nbt_transaction_id
					AND nt.subdomain = '$subdomain'
				INNER JOIN tbl_hour_code hc
					ON hc.id = nhs.hour_code

				WHERE hc.hour_code = 'SHOTE'
				AND nt.`status` = 'done'
				AND nt.to_do_date >= '$from' AND nt.to_do_date <= '$to'
				AND nhs.subdomain = '$subdomain'
				GROUP BY nt.user_id
			)SHOTE ON SHOTE.user_id = nt.user_id
			LEFT JOIN(
				SELECT
					nt.user_id,
					IF(nhs.hours_spent != '',SUM(nhs.hours_spent),0) SOTE,
					GROUP_CONCAT(DISTINCT DAYOFMONTH(nt.to_do_date) separator ',') SOTE_date
				FROM tbl_nbt_hours_spent nhs

				INNER JOIN tbl_nbt_transaction nt
					ON nt.subsync_id = nhs.nbt_transaction_id
					AND nt.subdomain = '$subdomain'
				INNER JOIN tbl_hour_code hc
					ON hc.id = nhs.hour_code

				WHERE hc.hour_code = 'SOTE'
				AND nt.`status` = 'done'
				AND nt.to_do_date >= '$from' AND nt.to_do_date <= '$to'
				AND nhs.subdomain = '$subdomain'
				GROUP BY nt.user_id
			)SOTE ON SOTE.user_id = nt.user_id
			LEFT JOIN(
				SELECT
					nt.user_id,
					IF(nhs.hours_spent != '',SUM(nhs.hours_spent),0) SRH,
					GROUP_CONCAT(DISTINCT DAYOFMONTH(nt.to_do_date) separator ',') SRH_date
				FROM tbl_nbt_hours_spent nhs

				INNER JOIN tbl_nbt_transaction nt
					ON nt.subsync_id = nhs.nbt_transaction_id
					AND nt.subdomain = '$subdomain'
				INNER JOIN tbl_hour_code hc
					ON hc.id = nhs.hour_code

				WHERE hc.hour_code = 'SRH'
				AND nt.`status` = 'done'
				AND nt.to_do_date >= '$from' AND nt.to_do_date <= '$to'
				AND nhs.subdomain = '$subdomain'
				GROUP BY nt.user_id
			)SRH ON SRH.user_id = nt.user_id
			LEFT JOIN(
				SELECT
					nt.user_id,
					IF(nhs.hours_spent != '',SUM(nhs.hours_spent),0) SRHE,
					GROUP_CONCAT(DISTINCT DAYOFMONTH(nt.to_do_date) separator ',') SRHE_date
				FROM tbl_nbt_hours_spent nhs

				INNER JOIN tbl_nbt_transaction nt
					ON nt.subsync_id = nhs.nbt_transaction_id
					AND nt.subdomain = '$subdomain'
				INNER JOIN tbl_hour_code hc
					ON hc.id = nhs.hour_code

				WHERE hc.hour_code = 'SRHE'
				AND nt.`status` = 'done'
				AND nt.to_do_date >= '$from' AND nt.to_do_date <= '$to'
				AND nhs.subdomain = '$subdomain'
				GROUP BY nt.user_id
			)SRHE ON SRHE.user_id = nt.user_id
			LEFT JOIN(
				SELECT
					nt.user_id,
					IF(nhs.hours_spent != '',SUM(nhs.hours_spent),0) LATE,
					GROUP_CONCAT(DISTINCT DAYOFMONTH(nt.to_do_date) separator ',') LATE_date
				FROM tbl_nbt_hours_spent nhs

				INNER JOIN tbl_nbt_transaction nt
					ON nt.subsync_id = nhs.nbt_transaction_id
					AND nt.subdomain = '$subdomain'
				INNER JOIN tbl_hour_code hc
					ON hc.id = nhs.hour_code

				WHERE hc.hour_code = 'LATE'
				AND nt.`status` = 'done'
				AND nt.to_do_date >= '$from' AND nt.to_do_date <= '$to'
				AND nhs.subdomain = '$subdomain'
				GROUP BY nt.user_id
			)LATE ON LATE.user_id = nt.user_id

			LEFT JOIN(
				SELECT
					nt.user_id,
					IF(nhs.hours_spent != '',SUM(nhs.hours_spent),0) UT,
					GROUP_CONCAT(DISTINCT DAYOFMONTH(nt.to_do_date) separator ',') UT_date
				FROM tbl_nbt_hours_spent nhs

				INNER JOIN tbl_nbt_transaction nt
					ON nt.subsync_id = nhs.nbt_transaction_id
					AND nt.subdomain = '$subdomain'
				INNER JOIN tbl_hour_code hc
					ON hc.id = nhs.hour_code

				WHERE hc.hour_code = 'UT'
				AND nt.`status` = 'done'
				AND nt.to_do_date >= '$from' AND nt.to_do_date <= '$to'
				AND nhs.subdomain = '$subdomain'
				GROUP BY nt.user_id
			)UT ON UT.user_id = nt.user_id
			LEFT JOIN(
				SELECT
					AL.user_id,
					AL.nt_id,
					SUM(AL.AL) AL,
					GROUP_CONCAT(DISTINCT DAYOFMONTH(AL.AL_date) separator ',') AL_date
				FROM(
					SELECT
						nt.user_id,
						nhs.nbt_transaction_id nt_id,
						IF(nhs.hours_spent != '',SUM(nhs.hours_spent/wc.total_hours_per_day),0) AL,
						nhs.hours_spent,
						hc.hour_code,
						nt.to_do_date AL_date
					FROM tbl_nbt_hours_spent nhs

					INNER JOIN tbl_nbt_transaction nt
						ON nt.subsync_id = nhs.nbt_transaction_id
						AND nt.subdomain = '$subdomain'
					INNER JOIN tbl_hour_code hc
						ON hc.id = nhs.hour_code
					LEFT JOIN tbl_working_calendar wc
						ON wc.working_date = nt.to_do_date

					WHERE hc.hour_code = 'AL'
					AND nt.`status` = 'done'
					AND nt.to_do_date >= '$from' AND nt.to_do_date <= '$to'
					AND nhs.subdomain = '$subdomain'
					GROUP BY nt.user_id
				)AL
                GROUP BY AL.user_id
			)AL ON AL.user_id = nt.user_id
			LEFT JOIN(
				SELECT
					SL.user_id,
					SL.nt_id,
					SUM(SL.SL) SL,
					GROUP_CONCAT(DISTINCT DAYOFMONTH(SL.SL_date) separator ',') SL_date
				FROM(
					SELECT
						nt.user_id,
						nhs.nbt_transaction_id nt_id,
						IF(nhs.hours_spent != '',SUM(nhs.hours_spent/wc.total_hours_per_day),0) SL,
						nhs.hours_spent,
						hc.hour_code,
						nt.to_do_date SL_date
					FROM tbl_nbt_hours_spent nhs

					INNER JOIN tbl_nbt_transaction nt
						ON nt.subsync_id = nhs.nbt_transaction_id
						AND nt.subdomain = '$subdomain'
					INNER JOIN tbl_hour_code hc
						ON hc.id = nhs.hour_code
					LEFT JOIN tbl_working_calendar wc
						ON wc.working_date = nt.to_do_date	

					WHERE hc.hour_code = 'SL'
					AND nt.`status` = 'done'
					AND nt.to_do_date >= '$from' AND nt.to_do_date <= '$to'
					AND nhs.subdomain = '$subdomain'
					GROUP BY nt.user_id
				)SL
                GROUP BY SL.user_id
			)SL ON SL.user_id = nt.user_id
			LEFT JOIN(
				SELECT
					VL.user_id,
					VL.nt_id,
					SUM(VL.VL) VL,
					GROUP_CONCAT(DISTINCT DAYOFMONTH(VL.VL_date) separator ',') VL_date
				FROM(
					SELECT
						nt.user_id,
						nhs.nbt_transaction_id nt_id,
						IF(nhs.hours_spent != '',SUM(nhs.hours_spent/wc.total_hours_per_day),0) VL,
						nhs.hours_spent,
						hc.hour_code,
						nt.to_do_date VL_date
					FROM tbl_nbt_hours_spent nhs

					INNER JOIN tbl_nbt_transaction nt
						ON nt.subsync_id = nhs.nbt_transaction_id
						AND nt.subdomain = '$subdomain'
					INNER JOIN tbl_hour_code hc
						ON hc.id = nhs.hour_code
					LEFT JOIN tbl_working_calendar wc
						ON wc.working_date = nt.to_do_date

					WHERE hc.hour_code = 'VL'
					AND nt.`status` = 'done'
					AND nt.to_do_date >= '$from' AND nt.to_do_date <= '$to'
					AND nhs.subdomain = '$subdomain'
					GROUP BY nt.user_id
				)VL
                GROUP BY VL.user_id
			)VL ON VL.user_id = nt.user_id
			LEFT JOIN(
				SELECT
					SIL.user_id,
					SIL.nt_id,
					SUM(SIL.SIL) SIL,
					GROUP_CONCAT(DISTINCT DAYOFMONTH(SIL.SIL_date) separator ',') SIL_date
				FROM(
					SELECT
						nt.user_id,
						nhs.nbt_transaction_id nt_id,
						IF(nhs.hours_spent != '',SUM(nhs.hours_spent/wc.total_hours_per_day),0) SIL,
						nhs.hours_spent,
						hc.hour_code,
						nt.to_do_date SIL_date
					FROM tbl_nbt_hours_spent nhs

					INNER JOIN tbl_nbt_transaction nt
						ON nt.subsync_id = nhs.nbt_transaction_id
						AND nt.subdomain = '$subdomain'
					INNER JOIN tbl_hour_code hc
						ON hc.id = nhs.hour_code
					LEFT JOIN tbl_working_calendar wc
						ON wc.working_date = nt.to_do_date

					WHERE hc.hour_code = 'SIL'
					AND nt.`status` = 'done'
					AND nt.to_do_date >= '$from' AND nt.to_do_date <= '$to'
					AND nhs.subdomain = '$subdomain'
					GROUP BY nt.user_id
				)SIL
                GROUP BY SIL.user_id
			)SIL ON SIL.user_id = nt.user_id
			LEFT JOIN(
				SELECT
					ft.user_id,
					r.daily_forecast_id,
					SUM(r.reimbursement) reimbursement
				FROM tbl_reimbursement r

				INNER JOIN tbl_daily_forecast ft
					ON r.daily_forecast_id = ft.subsync_id
				INNER JOIN tbl_forecast_transaction trans
					ON trans.subsync_id = ft.forecast_transaction_id
				INNER JOIN tbl_forecast f
					ON f.subsync_id = trans.forecast_id
			)reimbursement ON reimbursement.user_id = nt.user_id


			WHERE nt.`status` LIKE 'done'
			AND nt.to_do_date >= '$from' AND nt.to_do_date <= '$to'
			AND nt.subdomain = '$subdomain'
			GROUP BY ui.user_id

			) dar
			WHERE dar.approve_status LIKE '%$status%'
			ORDER BY dar.lname
		";
		$sqlQuery = new SqlQuery($sql);
		return QueryExecutor::execute($sqlQuery);
	}
	function dprListGroup($from,$to,$subdomain,$userId){
		$sql = "SELECT
					dar_group.to_do_date,
					dar_group.user_id,
					dar_group.subdomain,
					dar_group.subsync_id,
					SUM(dar_group.reimbursement) reimbursement,			
					dar_group.`client`,
					dar_group.engagement,
					dar_group.tba,
					dar_group.nbt,
					dar_group.target,
					dar_group.actual,
					dar_group.hours_spent,
					dar_group.hour_code
				FROM(
					SELECT 
						nbt_trans.to_do_date,
						nbt_trans.user_id,
						nbt_trans.subdomain,
						nbt_trans.subsync_id,
						IF(reimbursement.reimbursement IS NULL, 0, reimbursement.reimbursement) reimbursement,			
						tc.`client`,
						te.engagement,
						tba.tba,
						nbt.nbt,
						SUM(tdfpt.target) target,
						IF(SUM(tna.quantity) IS NULL,0,SUM(tna.quantity)) actual,
						nhs.hours_spent,
						hour_code.hour_code
						
					FROM tbl_nbt_transaction nbt_trans
				
					INNER JOIN tbl_nbt_hours_spent nhs
						ON nhs.nbt_transaction_id = nbt_trans.subsync_id
						AND nhs.subdomain = $subdomain
					INNER JOIN tbl_daily_forecast df
						ON df.subsync_id = nhs.daily_forecast_id
						AND df.subdomain = $subdomain
					INNER JOIN tbl_daily_forecast_per_time tdfpt
						ON tdfpt.daily_forecast_id = df.subsync_id
						AND tdfpt.subdomain = $subdomain
					LEFT JOIN tbl_nbt_actual tna
						ON tna.daily_forecast_per_time_id = tdfpt.subsync_id
						AND tna.subdomain = $subdomain
					INNER JOIN tbl_forecast_transaction tft
						ON tft.subsync_id = df.forecast_transaction_id
						AND tft.subdomain = $subdomain
					INNER JOIN tbl_client tc
						ON tc.id = tft.client_id
					INNER JOIN tbl_engagement te
						ON te.id = tft.engagement_id
					INNER JOIN tbl_tba tba
						ON tba.id = tft.tba_id
					INNER JOIN tbl_nbt nbt
						ON nbt.id = tft.nbt_id
					LEFT JOIN tbl_hour_code hour_code
						ON hour_code.id = nhs.hour_code
					LEFT JOIN tbl_reimbursement reimbursement
						ON reimbursement.daily_forecast_id = df.id
						AND reimbursement.subdomain = $subdomain
						
					WHERE nbt_trans.to_do_date >= '$from' AND nbt_trans.to_do_date <= '$to'
					AND nbt_trans.subdomain = $subdomain
					AND nbt_trans.user_id = $userId
				
					GROUP BY nbt_trans.to_do_date
				)dar_group
				GROUP BY dar_group.to_do_date";
		$sqlQuery = new SqlQuery($sql);
		return QueryExecutor::execute($sqlQuery);
	}
	function dprListDetailed($subdomain,$nbtTransId){
		$sql = "SELECT 
					nbt_trans.to_do_date,
					IF(reimbursement.reimbursement IS NULL, 0, reimbursement.reimbursement) reimbursement,			
					tc.`client`,
					te.engagement,
					tba.tba,
					nbt.nbt,
					SUM(tdfpt.target) target,
					IF(SUM(tna.quantity) IS NULL,0,SUM(tna.quantity)) actual,
					nhs.hours_spent,
					hour_code.hour_code
					
				FROM tbl_nbt_transaction nbt_trans
				
				INNER JOIN tbl_nbt_hours_spent nhs
					ON nhs.nbt_transaction_id = nbt_trans.subsync_id
					AND nhs.subdomain = $subdomain
				INNER JOIN tbl_daily_forecast df
					ON df.subsync_id = nhs.daily_forecast_id
					AND df.subdomain = $subdomain
				INNER JOIN tbl_daily_forecast_per_time tdfpt
					ON tdfpt.daily_forecast_id = df.subsync_id
					AND tdfpt.subdomain = $subdomain
				LEFT JOIN tbl_nbt_actual tna
					ON tna.daily_forecast_per_time_id = tdfpt.subsync_id
					AND tna.subdomain = $subdomain
				INNER JOIN tbl_forecast_transaction tft
					ON tft.subsync_id = df.forecast_transaction_id
					AND tft.subdomain = $subdomain
				INNER JOIN tbl_client tc
					ON tc.id = tft.client_id
				INNER JOIN tbl_engagement te
					ON te.id = tft.engagement_id
				INNER JOIN tbl_tba tba
					ON tba.id = tft.tba_id
				INNER JOIN tbl_nbt nbt
					ON nbt.id = tft.nbt_id
				LEFT JOIN tbl_hour_code hour_code
					ON hour_code.id = nhs.hour_code
				LEFT JOIN tbl_reimbursement reimbursement
					ON reimbursement.daily_forecast_id = df.id
					AND reimbursement.subdomain = $subdomain
					
				WHERE nbt_trans.subsync_id = $nbtTransId
				AND nbt_trans.subdomain = $subdomain
				
				GROUP BY df.id, nbt_trans.to_do_date";
		$sqlQuery = new SqlQuery($sql);
		return QueryExecutor::execute($sqlQuery);
	}
}
?>