<?php
/**
 * Class that operate on table 'tbl_company_per_eng'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2018-03-21 07:54
 */
class TblCompanyPerEngMySqlDAO implements TblCompanyPerEngDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @return TblCompanyPerEngMySql 
	 */
	public function load($id){
		$sql = 'SELECT * FROM tbl_company_per_eng WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($id);
		return $this->getRow($sqlQuery);
	}

	/**
	 * Get all records from table
	 */
	public function queryAll(){
		$sql = 'SELECT * FROM tbl_company_per_eng';
		$sqlQuery = new SqlQuery($sql);
		return $this->getList($sqlQuery);
	}
	
	/**
	 * Get all records from table ordered by field
	 *
	 * @param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn){
		$sql = 'SELECT * FROM tbl_company_per_eng ORDER BY '.$orderColumn;
		$sqlQuery = new SqlQuery($sql);
		return $this->getList($sqlQuery);
	}
	
	/**
 	 * Delete record from table
 	 * @param tblCompanyPerEng primary key
 	 */
	public function delete($id){
		$sql = 'DELETE FROM tbl_company_per_eng WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($id);
		return $this->executeUpdate($sqlQuery);
	}
	
	/**
 	 * Insert record to table
 	 *
 	 * @param TblCompanyPerEngMySql tblCompanyPerEng
 	 */
	public function insert($tblCompanyPerEng){
		$sql = 'INSERT INTO tbl_company_per_eng (company_id, engagement_id, client_id, created_by, modified_by, date_created, date_modified) VALUES (?, ?, ?, ?, ?, ?, ?)';
		$sqlQuery = new SqlQuery($sql);
		
		$sqlQuery->setNumber($tblCompanyPerEng->companyId);
		$sqlQuery->setNumber($tblCompanyPerEng->engagementId);
		$sqlQuery->setNumber($tblCompanyPerEng->clientId);
		$sqlQuery->setNumber($tblCompanyPerEng->createdBy);
		$sqlQuery->setNumber($tblCompanyPerEng->modifiedBy);
		$sqlQuery->set($tblCompanyPerEng->dateCreated);
		$sqlQuery->set($tblCompanyPerEng->dateModified);

		$id = $this->executeInsert($sqlQuery);	
		$tblCompanyPerEng->id = $id;
		return $id;
	}
	
	/**
 	 * Update record in table
 	 *
 	 * @param TblCompanyPerEngMySql tblCompanyPerEng
 	 */
	public function update($tblCompanyPerEng){
		$sql = 'UPDATE tbl_company_per_eng SET company_id = ?, engagement_id = ?, client_id = ?, created_by = ?, modified_by = ?, date_created = ?, date_modified = ? WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		
		$sqlQuery->setNumber($tblCompanyPerEng->companyId);
		$sqlQuery->setNumber($tblCompanyPerEng->engagementId);
		$sqlQuery->setNumber($tblCompanyPerEng->clientId);
		$sqlQuery->setNumber($tblCompanyPerEng->createdBy);
		$sqlQuery->setNumber($tblCompanyPerEng->modifiedBy);
		$sqlQuery->set($tblCompanyPerEng->dateCreated);
		$sqlQuery->set($tblCompanyPerEng->dateModified);

		$sqlQuery->setNumber($tblCompanyPerEng->id);
		return $this->executeUpdate($sqlQuery);
	}

	/**
 	 * Delete all rows
 	 */
	public function clean(){
		$sql = 'DELETE FROM tbl_company_per_eng';
		$sqlQuery = new SqlQuery($sql);
		return $this->executeUpdate($sqlQuery);
	}

	public function queryByCompanyId($value){
		$sql = 'SELECT * FROM tbl_company_per_eng WHERE company_id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByEngagementId($value){
		$sql = 'SELECT * FROM tbl_company_per_eng WHERE engagement_id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByClientId($value){
		$sql = 'SELECT * FROM tbl_company_per_eng WHERE client_id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByCreatedBy($value){
		$sql = 'SELECT * FROM tbl_company_per_eng WHERE created_by = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByModifiedBy($value){
		$sql = 'SELECT * FROM tbl_company_per_eng WHERE modified_by = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByDateCreated($value){
		$sql = 'SELECT * FROM tbl_company_per_eng WHERE date_created = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByDateModified($value){
		$sql = 'SELECT * FROM tbl_company_per_eng WHERE date_modified = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}


	public function deleteByCompanyId($value){
		$sql = 'DELETE FROM tbl_company_per_eng WHERE company_id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByEngagementId($value){
		$sql = 'DELETE FROM tbl_company_per_eng WHERE engagement_id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByClientId($value){
		$sql = 'DELETE FROM tbl_company_per_eng WHERE client_id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByCreatedBy($value){
		$sql = 'DELETE FROM tbl_company_per_eng WHERE created_by = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByModifiedBy($value){
		$sql = 'DELETE FROM tbl_company_per_eng WHERE modified_by = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByDateCreated($value){
		$sql = 'DELETE FROM tbl_company_per_eng WHERE date_created = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByDateModified($value){
		$sql = 'DELETE FROM tbl_company_per_eng WHERE date_modified = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}


	
	/**
	 * Read row
	 *
	 * @return TblCompanyPerEngMySql 
	 */
	protected function readRow($row){
		$tblCompanyPerEng = new TblCompanyPerEng();
		
		$tblCompanyPerEng->id = $row['id'];
		$tblCompanyPerEng->companyId = $row['company_id'];
		$tblCompanyPerEng->engagementId = $row['engagement_id'];
		$tblCompanyPerEng->clientId = $row['client_id'];
		$tblCompanyPerEng->createdBy = $row['created_by'];
		$tblCompanyPerEng->modifiedBy = $row['modified_by'];
		$tblCompanyPerEng->dateCreated = $row['date_created'];
		$tblCompanyPerEng->dateModified = $row['date_modified'];

		return $tblCompanyPerEng;
	}
	
	protected function getList($sqlQuery){
		$tab = QueryExecutor::execute($sqlQuery);
		$ret = array();
		for($i=0;$i<count($tab);$i++){
			$ret[$i] = $this->readRow($tab[$i]);
		}
		return $ret;
	}
	
	/**
	 * Get row
	 *
	 * @return TblCompanyPerEngMySql 
	 */
	protected function getRow($sqlQuery){
		$tab = QueryExecutor::execute($sqlQuery);
		if(count($tab)==0){
			return null;
		}
		return $this->readRow($tab[0]);		
	}
	
	/**
	 * Execute sql query
	 */
	protected function execute($sqlQuery){
		return QueryExecutor::execute($sqlQuery);
	}
	
		
	/**
	 * Execute sql query
	 */
	protected function executeUpdate($sqlQuery){
		return QueryExecutor::executeUpdate($sqlQuery);
	}

	/**
	 * Query for one row and one column
	 */
	protected function querySingleResult($sqlQuery){
		return QueryExecutor::queryForString($sqlQuery);
	}

	/**
	 * Insert row to table
	 */
	protected function executeInsert($sqlQuery){
		return QueryExecutor::executeInsert($sqlQuery);
	}
}
?>