<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2017-12-13 07:17
 */
interface TblWorkingCalendarDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return TblWorkingCalendar 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param tblWorkingCalendar primary key
 	 */
	public function delete($id);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param TblWorkingCalendar tblWorkingCalendar
 	 */
	public function insert($tblWorkingCalendar);
	
	/**
 	 * Update record in table
 	 *
 	 * @param TblWorkingCalendar tblWorkingCalendar
 	 */
	public function update($tblWorkingCalendar);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryByHolidayId($value);

	public function queryByTotalHoursPerDay($value);

	public function queryByRemarks($value);

	public function queryByWorkingType($value);

	public function queryByWorkingDate($value);

	public function queryByFromTime($value);

	public function queryByToTime($value);

	public function queryByCreatedBy($value);

	public function queryByModifiedBy($value);

	public function queryByDateCreated($value);

	public function queryByDateModified($value);


	public function deleteByHolidayId($value);

	public function deleteByTotalHoursPerDay($value);

	public function deleteByRemarks($value);

	public function deleteByWorkingType($value);

	public function deleteByWorkingDate($value);

	public function deleteByFromTime($value);

	public function deleteByToTime($value);

	public function deleteByCreatedBy($value);

	public function deleteByModifiedBy($value);

	public function deleteByDateCreated($value);

	public function deleteByDateModified($value);


}
?>