<?php
/**
 * Class that operate on table 'tbl_team_setup'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2015-01-20 02:25
 */
class TblTeamSetupMySqlExtDAO extends TblTeamSetupMySqlDAO{

	static function getTeams($search){
		$txt = '
				SELECT 
					team_setup.id,
					team_setup.team_id,
					team_setup.description,
					team_setup.leader,
					count(team_member.id) as member,
					CONCAT(user.firstname," ",user.midname," ",user.lastname) as user_name,
					user.username
					
				FROM 
					tbl_team_setup team_setup
					
				INNER JOIN tbl_user user
					ON user.id = team_setup.leader
				
				LEFT JOIN tbl_team_member team_member
					ON team_member.team_id = team_setup.id
					
				WHERE
					team_setup.team_id LIKE "%'.$search.'%" OR 
					team_setup.description LIKE "%'.$search.'%" OR 
					CONCAT(user.firstname," ",user.midname," ",user.lastname) LIKE "%'.$search.'%" OR 
					user.username LIKE "%'.$search.'%"
					
				GROUP BY 
					team_setup.id
			';
		
		$sqlQuery = new SqlQuery($txt);
		
		return self::getTblTeamSetup2($sqlQuery);
	}
	
	protected static function getTblTeamSetup($sqlQuery){
		$tab = QueryExecutor::execute($sqlQuery);
		if(empty($tab)){ return false; }
		$results = array();
		foreach($tab as $each){
			$result = new TblTeamSetup();
			$result->id = $each['id'];
			$result->teamId = $each['team_id'];
			$result->description = $each['description'];
			$result->leader = $each['leader'];
			$results[] = $result;
		}
		return $results;
	}
	
	protected static function getTblTeamSetup2($sqlQuery){
		$tab = QueryExecutor::execute($sqlQuery);
		if(empty($tab)){ return false; }
		$results = array();
		foreach($tab as $each){
			$result = new TblTeamSetup();
			$result->id = $each['id'];
			$result->teamId = $each['team_id'];
			$result->description = $each['description'];
			$result->leader = $each['leader'];
			$result->member = $each['member'];
			$result->userName = $each['user_name'];
			$result->username = $each['username'];
			$results[] = $result;
		}
		return $results;
	}
	
}
?>