<?php
/**
 * Class that operate on table 'tbl_client_project'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2017-04-03 05:19
 */
class TblClientProjectMySqlDAO implements TblClientProjectDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @return TblClientProjectMySql 
	 */
	public function load($id){
		$sql = 'SELECT * FROM tbl_client_project WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($id);
		return $this->getRow($sqlQuery);
	}

	/**
	 * Get all records from table
	 */
	public function queryAll(){
		$sql = 'SELECT * FROM tbl_client_project';
		$sqlQuery = new SqlQuery($sql);
		return $this->getList($sqlQuery);
	}
	
	/**
	 * Get all records from table ordered by field
	 *
	 * @param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn){
		$sql = 'SELECT * FROM tbl_client_project ORDER BY '.$orderColumn;
		$sqlQuery = new SqlQuery($sql);
		return $this->getList($sqlQuery);
	}
	
	/**
 	 * Delete record from table
 	 * @param tblClientProject primary key
 	 */
	public function delete($id){
		$sql = 'DELETE FROM tbl_client_project WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($id);
		return $this->executeUpdate($sqlQuery);
	}
	
	/**
 	 * Insert record to table
 	 *
 	 * @param TblClientProjectMySql tblClientProject
 	 */
	public function insert($tblClientProject){
		$sql = 'INSERT INTO tbl_client_project (client_id, project_id, projectname, cost_center, department, grp_id, type, status, managed_by, date_start, estimated_end, budget_hrs, referred_by, initiated_by, closed_by, cl_client, referred_type, additional_budget, partner_budget, manager_budget, snr_manager_budget, jr_manager_budget, supervisor_budget, senior_budget, staff_budget, contract_price, engagement_type) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)';
		$sqlQuery = new SqlQuery($sql);
		
		$sqlQuery->setNumber($tblClientProject->clientId);
		$sqlQuery->set($tblClientProject->projectId);
		$sqlQuery->set($tblClientProject->projectname);
		$sqlQuery->setNumber($tblClientProject->costCenter);
		$sqlQuery->setNumber($tblClientProject->department);
		$sqlQuery->setNumber($tblClientProject->grpId);
		$sqlQuery->set($tblClientProject->type);
		$sqlQuery->set($tblClientProject->status);
		$sqlQuery->set($tblClientProject->managedBy);
		$sqlQuery->set($tblClientProject->dateStart);
		$sqlQuery->set($tblClientProject->estimatedEnd);
		$sqlQuery->set($tblClientProject->budgetHrs);
		$sqlQuery->set($tblClientProject->referredBy);
		$sqlQuery->set($tblClientProject->initiatedBy);
		$sqlQuery->set($tblClientProject->closedBy);
		$sqlQuery->setNumber($tblClientProject->clClient);
		$sqlQuery->setNumber($tblClientProject->referredType);
		$sqlQuery->setNumber($tblClientProject->additionalBudget);
		$sqlQuery->setNumber($tblClientProject->partnerBudget);
		$sqlQuery->setNumber($tblClientProject->managerBudget);
		$sqlQuery->setNumber($tblClientProject->snrManagerBudget);
		$sqlQuery->setNumber($tblClientProject->jrManagerBudget);
		$sqlQuery->setNumber($tblClientProject->supervisorBudget);
		$sqlQuery->setNumber($tblClientProject->seniorBudget);
		$sqlQuery->setNumber($tblClientProject->staffBudget);
		$sqlQuery->setNumber($tblClientProject->contractPrice);
		$sqlQuery->set($tblClientProject->engagementType);

		$id = $this->executeInsert($sqlQuery);	
		$tblClientProject->id = $id;
		return $id;
	}
	
	/**
 	 * Update record in table
 	 *
 	 * @param TblClientProjectMySql tblClientProject
 	 */
	public function update($tblClientProject){
		$sql = 'UPDATE tbl_client_project SET client_id = ?, project_id = ?, projectname = ?, cost_center = ?, department = ?, grp_id = ?, type = ?, status = ?, managed_by = ?, date_start = ?, estimated_end = ?, budget_hrs = ?, referred_by = ?, initiated_by = ?, closed_by = ?, cl_client = ?, referred_type = ?, additional_budget = ?, partner_budget = ?, manager_budget = ?, snr_manager_budget = ?, jr_manager_budget = ?, supervisor_budget = ?, senior_budget = ?, staff_budget = ?, contract_price = ?, engagement_type = ? WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		
		$sqlQuery->setNumber($tblClientProject->clientId);
		$sqlQuery->set($tblClientProject->projectId);
		$sqlQuery->set($tblClientProject->projectname);
		$sqlQuery->setNumber($tblClientProject->costCenter);
		$sqlQuery->setNumber($tblClientProject->department);
		$sqlQuery->setNumber($tblClientProject->grpId);
		$sqlQuery->set($tblClientProject->type);
		$sqlQuery->set($tblClientProject->status);
		$sqlQuery->set($tblClientProject->managedBy);
		$sqlQuery->set($tblClientProject->dateStart);
		$sqlQuery->set($tblClientProject->estimatedEnd);
		$sqlQuery->set($tblClientProject->budgetHrs);
		$sqlQuery->set($tblClientProject->referredBy);
		$sqlQuery->set($tblClientProject->initiatedBy);
		$sqlQuery->set($tblClientProject->closedBy);
		$sqlQuery->setNumber($tblClientProject->clClient);
		$sqlQuery->setNumber($tblClientProject->referredType);
		$sqlQuery->setNumber($tblClientProject->additionalBudget);
		$sqlQuery->setNumber($tblClientProject->partnerBudget);
		$sqlQuery->setNumber($tblClientProject->managerBudget);
		$sqlQuery->setNumber($tblClientProject->snrManagerBudget);
		$sqlQuery->setNumber($tblClientProject->jrManagerBudget);
		$sqlQuery->setNumber($tblClientProject->supervisorBudget);
		$sqlQuery->setNumber($tblClientProject->seniorBudget);
		$sqlQuery->setNumber($tblClientProject->staffBudget);
		$sqlQuery->setNumber($tblClientProject->contractPrice);
		$sqlQuery->set($tblClientProject->engagementType);

		$sqlQuery->setNumber($tblClientProject->id);
		return $this->executeUpdate($sqlQuery);
	}

	/**
 	 * Delete all rows
 	 */
	public function clean(){
		$sql = 'DELETE FROM tbl_client_project';
		$sqlQuery = new SqlQuery($sql);
		return $this->executeUpdate($sqlQuery);
	}

	public function queryByClientId($value){
		$sql = 'SELECT * FROM tbl_client_project WHERE client_id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByProjectId($value){
		$sql = 'SELECT * FROM tbl_client_project WHERE project_id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByProjectname($value){
		$sql = 'SELECT * FROM tbl_client_project WHERE projectname = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByCostCenter($value){
		$sql = 'SELECT * FROM tbl_client_project WHERE cost_center = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByDepartment($value){
		$sql = 'SELECT * FROM tbl_client_project WHERE department = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByGrpId($value){
		$sql = 'SELECT * FROM tbl_client_project WHERE grp_id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByType($value){
		$sql = 'SELECT * FROM tbl_client_project WHERE type = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByStatus($value){
		$sql = 'SELECT * FROM tbl_client_project WHERE status = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByManagedBy($value){
		$sql = 'SELECT * FROM tbl_client_project WHERE managed_by = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByDateStart($value){
		$sql = 'SELECT * FROM tbl_client_project WHERE date_start = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByEstimatedEnd($value){
		$sql = 'SELECT * FROM tbl_client_project WHERE estimated_end = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByBudgetHrs($value){
		$sql = 'SELECT * FROM tbl_client_project WHERE budget_hrs = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByReferredBy($value){
		$sql = 'SELECT * FROM tbl_client_project WHERE referred_by = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByInitiatedBy($value){
		$sql = 'SELECT * FROM tbl_client_project WHERE initiated_by = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByClosedBy($value){
		$sql = 'SELECT * FROM tbl_client_project WHERE closed_by = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByClClient($value){
		$sql = 'SELECT * FROM tbl_client_project WHERE cl_client = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByReferredType($value){
		$sql = 'SELECT * FROM tbl_client_project WHERE referred_type = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByAdditionalBudget($value){
		$sql = 'SELECT * FROM tbl_client_project WHERE additional_budget = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByPartnerBudget($value){
		$sql = 'SELECT * FROM tbl_client_project WHERE partner_budget = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByManagerBudget($value){
		$sql = 'SELECT * FROM tbl_client_project WHERE manager_budget = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryBySnrManagerBudget($value){
		$sql = 'SELECT * FROM tbl_client_project WHERE snr_manager_budget = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByJrManagerBudget($value){
		$sql = 'SELECT * FROM tbl_client_project WHERE jr_manager_budget = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryBySupervisorBudget($value){
		$sql = 'SELECT * FROM tbl_client_project WHERE supervisor_budget = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryBySeniorBudget($value){
		$sql = 'SELECT * FROM tbl_client_project WHERE senior_budget = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByStaffBudget($value){
		$sql = 'SELECT * FROM tbl_client_project WHERE staff_budget = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByContractPrice($value){
		$sql = 'SELECT * FROM tbl_client_project WHERE contract_price = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByEngagementType($value){
		$sql = 'SELECT * FROM tbl_client_project WHERE engagement_type = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}


	public function deleteByClientId($value){
		$sql = 'DELETE FROM tbl_client_project WHERE client_id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByProjectId($value){
		$sql = 'DELETE FROM tbl_client_project WHERE project_id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByProjectname($value){
		$sql = 'DELETE FROM tbl_client_project WHERE projectname = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByCostCenter($value){
		$sql = 'DELETE FROM tbl_client_project WHERE cost_center = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByDepartment($value){
		$sql = 'DELETE FROM tbl_client_project WHERE department = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByGrpId($value){
		$sql = 'DELETE FROM tbl_client_project WHERE grp_id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByType($value){
		$sql = 'DELETE FROM tbl_client_project WHERE type = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByStatus($value){
		$sql = 'DELETE FROM tbl_client_project WHERE status = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByManagedBy($value){
		$sql = 'DELETE FROM tbl_client_project WHERE managed_by = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByDateStart($value){
		$sql = 'DELETE FROM tbl_client_project WHERE date_start = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByEstimatedEnd($value){
		$sql = 'DELETE FROM tbl_client_project WHERE estimated_end = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByBudgetHrs($value){
		$sql = 'DELETE FROM tbl_client_project WHERE budget_hrs = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByReferredBy($value){
		$sql = 'DELETE FROM tbl_client_project WHERE referred_by = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByInitiatedBy($value){
		$sql = 'DELETE FROM tbl_client_project WHERE initiated_by = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByClosedBy($value){
		$sql = 'DELETE FROM tbl_client_project WHERE closed_by = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByClClient($value){
		$sql = 'DELETE FROM tbl_client_project WHERE cl_client = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByReferredType($value){
		$sql = 'DELETE FROM tbl_client_project WHERE referred_type = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByAdditionalBudget($value){
		$sql = 'DELETE FROM tbl_client_project WHERE additional_budget = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByPartnerBudget($value){
		$sql = 'DELETE FROM tbl_client_project WHERE partner_budget = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByManagerBudget($value){
		$sql = 'DELETE FROM tbl_client_project WHERE manager_budget = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteBySnrManagerBudget($value){
		$sql = 'DELETE FROM tbl_client_project WHERE snr_manager_budget = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByJrManagerBudget($value){
		$sql = 'DELETE FROM tbl_client_project WHERE jr_manager_budget = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteBySupervisorBudget($value){
		$sql = 'DELETE FROM tbl_client_project WHERE supervisor_budget = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteBySeniorBudget($value){
		$sql = 'DELETE FROM tbl_client_project WHERE senior_budget = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByStaffBudget($value){
		$sql = 'DELETE FROM tbl_client_project WHERE staff_budget = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByContractPrice($value){
		$sql = 'DELETE FROM tbl_client_project WHERE contract_price = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByEngagementType($value){
		$sql = 'DELETE FROM tbl_client_project WHERE engagement_type = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}


	
	/**
	 * Read row
	 *
	 * @return TblClientProjectMySql 
	 */
	protected function readRow($row){
		$tblClientProject = new TblClientProject();
		
		$tblClientProject->id = $row['id'];
		$tblClientProject->clientId = $row['client_id'];
		$tblClientProject->projectId = $row['project_id'];
		$tblClientProject->projectname = $row['projectname'];
		$tblClientProject->costCenter = $row['cost_center'];
		$tblClientProject->department = $row['department'];
		$tblClientProject->grpId = $row['grp_id'];
		$tblClientProject->type = $row['type'];
		$tblClientProject->status = $row['status'];
		$tblClientProject->managedBy = $row['managed_by'];
		$tblClientProject->dateStart = $row['date_start'];
		$tblClientProject->estimatedEnd = $row['estimated_end'];
		$tblClientProject->budgetHrs = $row['budget_hrs'];
		$tblClientProject->referredBy = $row['referred_by'];
		$tblClientProject->initiatedBy = $row['initiated_by'];
		$tblClientProject->closedBy = $row['closed_by'];
		$tblClientProject->clClient = $row['cl_client'];
		$tblClientProject->referredType = $row['referred_type'];
		$tblClientProject->additionalBudget = $row['additional_budget'];
		$tblClientProject->partnerBudget = $row['partner_budget'];
		$tblClientProject->managerBudget = $row['manager_budget'];
		$tblClientProject->snrManagerBudget = $row['snr_manager_budget'];
		$tblClientProject->jrManagerBudget = $row['jr_manager_budget'];
		$tblClientProject->supervisorBudget = $row['supervisor_budget'];
		$tblClientProject->seniorBudget = $row['senior_budget'];
		$tblClientProject->staffBudget = $row['staff_budget'];
		$tblClientProject->contractPrice = $row['contract_price'];
		$tblClientProject->engagementType = $row['engagement_type'];

		return $tblClientProject;
	}
	
	protected function getList($sqlQuery){
		$tab = QueryExecutor::execute($sqlQuery);
		$ret = array();
		for($i=0;$i<count($tab);$i++){
			$ret[$i] = $this->readRow($tab[$i]);
		}
		return $ret;
	}
	
	/**
	 * Get row
	 *
	 * @return TblClientProjectMySql 
	 */
	protected function getRow($sqlQuery){
		$tab = QueryExecutor::execute($sqlQuery);
		if(count($tab)==0){
			return null;
		}
		return $this->readRow($tab[0]);		
	}
	
	/**
	 * Execute sql query
	 */
	protected function execute($sqlQuery){
		return QueryExecutor::execute($sqlQuery);
	}
	
		
	/**
	 * Execute sql query
	 */
	protected function executeUpdate($sqlQuery){
		return QueryExecutor::executeUpdate($sqlQuery);
	}

	/**
	 * Query for one row and one column
	 */
	protected function querySingleResult($sqlQuery){
		return QueryExecutor::queryForString($sqlQuery);
	}

	/**
	 * Insert row to table
	 */
	protected function executeInsert($sqlQuery){
		return QueryExecutor::executeInsert($sqlQuery);
	}
}
?>