<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2017-04-03 05:19
 */
interface TblSubordinateDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return TblSubordinate 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param tblSubordinate primary key
 	 */
	public function delete($id);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param TblSubordinate tblSubordinate
 	 */
	public function insert($tblSubordinate);
	
	/**
 	 * Update record in table
 	 *
 	 * @param TblSubordinate tblSubordinate
 	 */
	public function update($tblSubordinate);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryBySuperiorId($value);

	public function queryBySubordinateId($value);

	public function queryByDepartment($value);

	public function queryByStatus($value);


	public function deleteBySuperiorId($value);

	public function deleteBySubordinateId($value);

	public function deleteByDepartment($value);

	public function deleteByStatus($value);


}
?>