<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2017-04-03 05:19
 */
interface TblPlanTransactionDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return TblPlanTransaction 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param tblPlanTransaction primary key
 	 */
	public function delete($id);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param TblPlanTransaction tblPlanTransaction
 	 */
	public function insert($tblPlanTransaction);
	
	/**
 	 * Update record in table
 	 *
 	 * @param TblPlanTransaction tblPlanTransaction
 	 */
	public function update($tblPlanTransaction);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryByUserId($value);

	public function queryByCreatedId($value);

	public function queryByDate($value);

	public function queryByFromDate($value);

	public function queryByToDate($value);

	public function queryByType($value);

	public function queryByStatus($value);


	public function deleteByUserId($value);

	public function deleteByCreatedId($value);

	public function deleteByDate($value);

	public function deleteByFromDate($value);

	public function deleteByToDate($value);

	public function deleteByType($value);

	public function deleteByStatus($value);


}
?>