<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2017-04-03 05:19
 */
interface TblEngagementTypeDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return TblEngagementType 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param tblEngagementType primary key
 	 */
	public function delete($id);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param TblEngagementType tblEngagementType
 	 */
	public function insert($tblEngagementType);
	
	/**
 	 * Update record in table
 	 *
 	 * @param TblEngagementType tblEngagementType
 	 */
	public function update($tblEngagementType);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryByGrpId($value);

	public function queryByDescription($value);

	public function queryByCreatedAt($value);

	public function queryByUpdatedAt($value);


	public function deleteByGrpId($value);

	public function deleteByDescription($value);

	public function deleteByCreatedAt($value);

	public function deleteByUpdatedAt($value);


}
?>