<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2017-04-03 05:19
 */
interface ChatDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return Chat 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param chat primary key
 	 */
	public function delete($id);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param Chat chat
 	 */
	public function insert($chat);
	
	/**
 	 * Update record in table
 	 *
 	 * @param Chat chat
 	 */
	public function update($chat);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryByGroupId($value);

	public function queryBySender($value);

	public function queryByMsg($value);

	public function queryByDateSent($value);


	public function deleteByGroupId($value);

	public function deleteBySender($value);

	public function deleteByMsg($value);

	public function deleteByDateSent($value);


}
?>