<?php 
	$modules = DAOFactory::getTblModuleDAO()->queryAll();
	$users = DAOFactory::getTblUserModuleAccessDAO()->getUsers();
?>
<form id="userAccessForm" method="post">
	<div class="box-standard">
		<div class="row">
			<div class="col-lg-6 col-sm-6">
				<div class="page-header-standard"><i class="pe-7s-angle-right-circle pe-lg"></i> User Access</div>
			</div>
			<div class="col-lg-6 col-sm-6 text-right">
				<button type="button" class="btn btn-success sample"><i class="pe-7s-plus pe-lg"></i> Add User</button>
				<button type="submit" class="btn btn-success"><i class="pe-7s-paper-plane pe-lg"></i> Save</button>
			</div>
		</div>
	</div>
	<div class="box-standard">
		<div class="row">
			<div class="col-lg-12 col-sm-12">
				<div class="table-responsive">
					<table class="table table-standard" id="user_access_table">
						<thead>
							<tr>
								<th></th>
								<th>User</th>
								<?php foreach ($modules as $key => $value): ?>
								<th><?=$value->module?></th>
								<?php endforeach; ?>
							</tr>
						</thead>
						<tbody>
							<?php foreach ($users as $key => $value): ?>
								<tr>
									<td class="col-lg-1"><input type="checkbox" class="checkAllModule"></td>
									<?php $name = !empty($value['lname']) ? $value['fname'].' '.$value['mname'].' '.$value['lname'] : $value['username']?>
									<td><?= $name?><input type="hidden" name="user_id[]" value="<?= $value['id']?>"></td>
									<?php $userAccess = DAOFactory::getTblUserModuleAccessDAO()->userAccess($value['id'])?>
									<?php foreach ($userAccess as $key => $value1): ?>
									<td class="col-lg-1 checkModule">
										<input type="checkbox" name="chck<?=$value['id']?>[]" <?= ($value['id'] == $value1['user_id']) ? 'checked' : '' ?> value="<?=$value1['module_id']?>" >
									</td>
									<?php endforeach;?>
								</tr>
							<?php endforeach;?>
						</tbody>
					</table>	
				</div>
			</div>
		</div>
	</div>
</form>
<!-- <script src="<?=URL?>public/js/setup/blood_type.js"></script> -->
<form method="post" id="formUserAccess">
	
	<div id="sampleModal" class="modal fade" role="dialog">
		<div class="modal-dialog">
		<div class="modal-content">
			<div class="modal-header">
				<h4 class="modal-title">Add User</h4>
			</div>
			<div class="modal-body">
				<div class="form-group">
					User: 
					<select name="user" class="form-control" data-live-search="true">
					</select>
				</div>
				<div class="form-group">
					<table class="table table-standard table-bordered">
						<thead>
							<tr>
								<th class="text-center"><input type="checkbox" class="selectAll"></th>
								<th class="text-center"> Modules</th>
							</tr>
						</thead>
						<tbody>
							<?php foreach ($modules as $key => $value): ?>
							<tr>
								<td class="text-center"><input type="checkbox" name="module[]" value="<?=$value->id?>"></td>
								<td class="text-center"><?=$value->module?></td>
							</tr>
							<?php endforeach; ?>
						</tbody>
					</table>
				</div>
				<!-- <div class="form-group">
					Blood Type: <input type="text" required name="blood_type" class="form-control">
				</div>
				<div class="form-group">
					<input name="status" id="checkId" data-toggle="toggle" data-on="Enable" data-off="Disable" data-onstyle="success btn-xs" data-offstyle="danger btn-xs" type="checkbox" class="form-control checkboxOnOff btn-lg" />
				</div> -->
			</div>
			<div class="modal-footer">
				<button type="submit" id="btnSave" class="btn btn-success">Save</button>
				<button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
			</div>
		</div>

		</div>
	</div>
</form>
<script>
	$(function(){
		$('.sample').click(function(){
			showEmployee()
			$('#sampleModal').modal({
			  	backdrop: 'static', 
			    keyboard: false,
			    toggle: true
			 });
		})
		$('#formUserAccess').submit(function(){
			var form = $(this).serialize();
			saveAlert('You want to save this user?',function(){
				$.post(URL+'access/addUserAccess',form)
				.done(function(returnData){
					location.reload();
				});
				return false;
			})
			return false;
		})
		$('#userAccessForm').submit(function(){
			var form = $(this).serialize();
			saveAlert('You want to save the access?',function(){
				$.post(URL+'access/updateUserAccess',form)
				.done(function(returnData){
					location.reload();
				});
				return false;
			});
			return false;
		})
		$('.selectAll').change(function(){
			if(this.checked){
				$(this).closest('thead').siblings('tbody').find('input[type="checkbox"]').prop('checked', true);
			} else {
				$(this).closest('thead').siblings('tbody').find('input[type="checkbox"]').prop('checked', false);
			}
		})
		$('.checkAllModule').change(function(){
			if(this.checked){
				$(this).parent('td').parent('tr').find('.checkModule input[type="checkbox"]').prop('checked', true);
			} else {
				$(this).parent('td').parent('tr').find('.checkModule input[type="checkbox"]').prop('checked', false);
			}
		})
	})
	function showEmployee(){
		$.post(URL+'employee/showAllUsers')
		.done(function(returnData){
			var data = $.parseJSON(returnData);
			var append = '';
			$.each(data,function(key,a){
				var name = (a.lname==null) ? a.username : a.lname+", "+a.fname+" "+a.mname;
				append += "<option value='"+a.id+"'>"+name+"</option>";
			})
			$('select[name="user"]').html(append);
			$('select[name="user"]').selectpicker('refresh');


		})
	}
</script>