<?php
/**
 * Class that operate on table 'tbl_nbt_approve_history'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2018-02-23 09:46
 */
class TblNbtApproveHistoryMySqlDAO implements TblNbtApproveHistoryDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @return TblNbtApproveHistoryMySql 
	 */
	public function load($id){
		$sql = 'SELECT * FROM tbl_nbt_approve_history WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($id);
		return $this->getRow($sqlQuery);
	}

	/**
	 * Get all records from table
	 */
	public function queryAll(){
		$sql = 'SELECT * FROM tbl_nbt_approve_history';
		$sqlQuery = new SqlQuery($sql);
		return $this->getList($sqlQuery);
	}
	
	/**
	 * Get all records from table ordered by field
	 *
	 * @param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn){
		$sql = 'SELECT * FROM tbl_nbt_approve_history ORDER BY '.$orderColumn;
		$sqlQuery = new SqlQuery($sql);
		return $this->getList($sqlQuery);
	}
	
	/**
 	 * Delete record from table
 	 * @param tblNbtApproveHistory primary key
 	 */
	public function delete($id){
		$sql = 'DELETE FROM tbl_nbt_approve_history WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($id);
		return $this->executeUpdate($sqlQuery);
	}
	
	/**
 	 * Insert record to table
 	 *
 	 * @param TblNbtApproveHistoryMySql tblNbtApproveHistory
 	 */
	public function insert($tblNbtApproveHistory){
		$sql = 'INSERT INTO tbl_nbt_approve_history (subsync_id, subdomain, user_id, approver_id, from_date, to_date, status, created_by, modified_by, date_created, date_modified) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)';
		$sqlQuery = new SqlQuery($sql);
		
		$sqlQuery->setNumber($tblNbtApproveHistory->subsyncId);
		$sqlQuery->setNumber($tblNbtApproveHistory->subdomain);
		$sqlQuery->setNumber($tblNbtApproveHistory->userId);
		$sqlQuery->setNumber($tblNbtApproveHistory->approverId);
		$sqlQuery->set($tblNbtApproveHistory->fromDate);
		$sqlQuery->set($tblNbtApproveHistory->toDate);
		$sqlQuery->set($tblNbtApproveHistory->status);
		$sqlQuery->setNumber($tblNbtApproveHistory->createdBy);
		$sqlQuery->setNumber($tblNbtApproveHistory->modifiedBy);
		$sqlQuery->set($tblNbtApproveHistory->dateCreated);
		$sqlQuery->set($tblNbtApproveHistory->dateModified);

		$id = $this->executeInsert($sqlQuery);	
		$tblNbtApproveHistory->id = $id;
		return $id;
	}
	
	/**
 	 * Update record in table
 	 *
 	 * @param TblNbtApproveHistoryMySql tblNbtApproveHistory
 	 */
	public function update($tblNbtApproveHistory){
		$sql = 'UPDATE tbl_nbt_approve_history SET subsync_id = ?, subdomain = ?, user_id = ?, approver_id = ?, from_date = ?, to_date = ?, status = ?, created_by = ?, modified_by = ?, date_created = ?, date_modified = ? WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		
		$sqlQuery->setNumber($tblNbtApproveHistory->subsyncId);
		$sqlQuery->setNumber($tblNbtApproveHistory->subdomain);
		$sqlQuery->setNumber($tblNbtApproveHistory->userId);
		$sqlQuery->setNumber($tblNbtApproveHistory->approverId);
		$sqlQuery->set($tblNbtApproveHistory->fromDate);
		$sqlQuery->set($tblNbtApproveHistory->toDate);
		$sqlQuery->set($tblNbtApproveHistory->status);
		$sqlQuery->setNumber($tblNbtApproveHistory->createdBy);
		$sqlQuery->setNumber($tblNbtApproveHistory->modifiedBy);
		$sqlQuery->set($tblNbtApproveHistory->dateCreated);
		$sqlQuery->set($tblNbtApproveHistory->dateModified);

		$sqlQuery->setNumber($tblNbtApproveHistory->id);
		return $this->executeUpdate($sqlQuery);
	}

	/**
 	 * Delete all rows
 	 */
	public function clean(){
		$sql = 'DELETE FROM tbl_nbt_approve_history';
		$sqlQuery = new SqlQuery($sql);
		return $this->executeUpdate($sqlQuery);
	}

	public function queryBySubsyncId($value){
		$sql = 'SELECT * FROM tbl_nbt_approve_history WHERE subsync_id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryBySubdomain($value){
		$sql = 'SELECT * FROM tbl_nbt_approve_history WHERE subdomain = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByUserId($value){
		$sql = 'SELECT * FROM tbl_nbt_approve_history WHERE user_id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByApproverId($value){
		$sql = 'SELECT * FROM tbl_nbt_approve_history WHERE approver_id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByFromDate($value){
		$sql = 'SELECT * FROM tbl_nbt_approve_history WHERE from_date = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByToDate($value){
		$sql = 'SELECT * FROM tbl_nbt_approve_history WHERE to_date = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByStatus($value){
		$sql = 'SELECT * FROM tbl_nbt_approve_history WHERE status = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByCreatedBy($value){
		$sql = 'SELECT * FROM tbl_nbt_approve_history WHERE created_by = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByModifiedBy($value){
		$sql = 'SELECT * FROM tbl_nbt_approve_history WHERE modified_by = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByDateCreated($value){
		$sql = 'SELECT * FROM tbl_nbt_approve_history WHERE date_created = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByDateModified($value){
		$sql = 'SELECT * FROM tbl_nbt_approve_history WHERE date_modified = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}


	public function deleteBySubsyncId($value){
		$sql = 'DELETE FROM tbl_nbt_approve_history WHERE subsync_id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteBySubdomain($value){
		$sql = 'DELETE FROM tbl_nbt_approve_history WHERE subdomain = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByUserId($value){
		$sql = 'DELETE FROM tbl_nbt_approve_history WHERE user_id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByApproverId($value){
		$sql = 'DELETE FROM tbl_nbt_approve_history WHERE approver_id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByFromDate($value){
		$sql = 'DELETE FROM tbl_nbt_approve_history WHERE from_date = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByToDate($value){
		$sql = 'DELETE FROM tbl_nbt_approve_history WHERE to_date = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByStatus($value){
		$sql = 'DELETE FROM tbl_nbt_approve_history WHERE status = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByCreatedBy($value){
		$sql = 'DELETE FROM tbl_nbt_approve_history WHERE created_by = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByModifiedBy($value){
		$sql = 'DELETE FROM tbl_nbt_approve_history WHERE modified_by = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByDateCreated($value){
		$sql = 'DELETE FROM tbl_nbt_approve_history WHERE date_created = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByDateModified($value){
		$sql = 'DELETE FROM tbl_nbt_approve_history WHERE date_modified = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}


	
	/**
	 * Read row
	 *
	 * @return TblNbtApproveHistoryMySql 
	 */
	protected function readRow($row){
		$tblNbtApproveHistory = new TblNbtApproveHistory();
		
		$tblNbtApproveHistory->id = $row['id'];
		$tblNbtApproveHistory->subsyncId = $row['subsync_id'];
		$tblNbtApproveHistory->subdomain = $row['subdomain'];
		$tblNbtApproveHistory->userId = $row['user_id'];
		$tblNbtApproveHistory->approverId = $row['approver_id'];
		$tblNbtApproveHistory->fromDate = $row['from_date'];
		$tblNbtApproveHistory->toDate = $row['to_date'];
		$tblNbtApproveHistory->status = $row['status'];
		$tblNbtApproveHistory->createdBy = $row['created_by'];
		$tblNbtApproveHistory->modifiedBy = $row['modified_by'];
		$tblNbtApproveHistory->dateCreated = $row['date_created'];
		$tblNbtApproveHistory->dateModified = $row['date_modified'];

		return $tblNbtApproveHistory;
	}
	
	protected function getList($sqlQuery){
		$tab = QueryExecutor::execute($sqlQuery);
		$ret = array();
		for($i=0;$i<count($tab);$i++){
			$ret[$i] = $this->readRow($tab[$i]);
		}
		return $ret;
	}
	
	/**
	 * Get row
	 *
	 * @return TblNbtApproveHistoryMySql 
	 */
	protected function getRow($sqlQuery){
		$tab = QueryExecutor::execute($sqlQuery);
		if(count($tab)==0){
			return null;
		}
		return $this->readRow($tab[0]);		
	}
	
	/**
	 * Execute sql query
	 */
	protected function execute($sqlQuery){
		return QueryExecutor::execute($sqlQuery);
	}
	
		
	/**
	 * Execute sql query
	 */
	protected function executeUpdate($sqlQuery){
		return QueryExecutor::executeUpdate($sqlQuery);
	}

	/**
	 * Query for one row and one column
	 */
	protected function querySingleResult($sqlQuery){
		return QueryExecutor::queryForString($sqlQuery);
	}

	/**
	 * Insert row to table
	 */
	protected function executeInsert($sqlQuery){
		return QueryExecutor::executeInsert($sqlQuery);
	}
}
?>