<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2017-12-06 06:34
 */
interface TblTimeRequestDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return TblTimeRequest 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param tblTimeRequest primary key
 	 */
	public function delete($id);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param TblTimeRequest tblTimeRequest
 	 */
	public function insert($tblTimeRequest);
	
	/**
 	 * Update record in table
 	 *
 	 * @param TblTimeRequest tblTimeRequest
 	 */
	public function update($tblTimeRequest);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryByUserId($value);

	public function queryByApproverId($value);

	public function queryByDateRequested($value);

	public function queryByRequestType($value);

	public function queryByTimeRequested($value);

	public function queryByClient($value);

	public function queryByLocation($value);

	public function queryByReason($value);

	public function queryByStatus($value);

	public function queryByCreatedBy($value);

	public function queryByModifiedBy($value);

	public function queryByDateCreated($value);

	public function queryByDateModified($value);


	public function deleteByUserId($value);

	public function deleteByApproverId($value);

	public function deleteByDateRequested($value);

	public function deleteByRequestType($value);

	public function deleteByTimeRequested($value);

	public function deleteByClient($value);

	public function deleteByLocation($value);

	public function deleteByReason($value);

	public function deleteByStatus($value);

	public function deleteByCreatedBy($value);

	public function deleteByModifiedBy($value);

	public function deleteByDateCreated($value);

	public function deleteByDateModified($value);


}
?>