<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2018-08-16 04:03
 */
interface TblSjcQuestionDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return TblSjcQuestion 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param tblSjcQuestion primary key
 	 */
	public function delete($id);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param TblSjcQuestion tblSjcQuestion
 	 */
	public function insert($tblSjcQuestion);
	
	/**
 	 * Update record in table
 	 *
 	 * @param TblSjcQuestion tblSjcQuestion
 	 */
	public function update($tblSjcQuestion);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryByUserId($value);

	public function queryByAnswer($value);

	public function queryByDateCreated($value);

	public function queryByDateModified($value);


	public function deleteByUserId($value);

	public function deleteByAnswer($value);

	public function deleteByDateCreated($value);

	public function deleteByDateModified($value);


}
?>