$(function(){
	show();
	countTable('setup/countBloodType','BT-','#formBloodType','input[name="blood_type_no"]');
	$('.sample').click(function(){
		$('#sampleModal').modal({
		  	backdrop: 'static', 
		    keyboard: false,
		    toggle: true
		 });
	});
	$('#formBloodType').submit(function(){
		var data = $(this).serialize();
		saveAlert('You want to add this data?', function(){
			$.post(URL +'setup/saveBloodType', data)
			.done(function(returnData){
				if(returnData==''){
					toastr.success('Data Successfully Saved!');
					setTimeout(function(){
						location.reload();
					},1000)
				} else {
					toastr.error(returnData);
					$('#saveAlertModal').modal('hide');
				}
			});
			return false;
		})
		return false;
	});
	$('#bloodType_table').on('click','.updateBloodType',function(){
		$('#sampleModalUpdate').modal({
		  	backdrop: 'static', 
		    keyboard: false,
		    toggle: true
		 });
		var id = $(this).attr('bloodtypeId');
		var blood_type_no = $(this).closest('tr').find('td:nth-child(1)').html();
		var blood_type = $(this).closest('tr').find('td:nth-child(2)').html();
		var status = $(this).closest('tr').find('td:nth-child(3)').html();

		$('#updateBloodType').find('input[name="blood_type_id"]').val(id);
		$('#updateBloodType').find('input[name="blood_type_no"]').val(blood_type_no);
		$('#updateBloodType').find('input[name="blood_type"]').val(blood_type);

		if(status == 'enabled'){
			$('#updateBloodType').find('input[name="status"]').bootstrapToggle('on');
		}else{
			$('#updateBloodType').find('input[name="status"]').bootstrapToggle('off');
		}
	})
	$('#updateBloodType').submit(function(){
		var data = $(this).serialize();
		saveAlert('You want to update this data?',function(){
			$.post(URL+'setup/updateBloodType', data)
			.done(function(returnData){
				if(returnData == ''){
					toastr.success('Data Successfully Updated!');
					setTimeout(function(){
						location.reload();
					},1000)
				}else{
					toastr.error(returnData);
					$('#saveAlertModal').modal('hide');
				}
			})
			return false;
		})
		return false;
	})
});

function show(){
	tableLoader('#bloodType_table');
	$.post(URL+'setup/showBloodType')
	.done(function(returnData){
		var data = $.parseJSON(returnData);
		var append = "";
		$.each(data,function(key,a){
			append += "<tr>"+
							"<td>"+a.bloodTypeNo+"</td>"+
							"<td>"+a.bloodType+"</td>"+
							"<td>"+a.status+"</td>"+
							"<td>"+
								"<a bloodtypeId='"+a.id+"' class='updateBloodType btn-edit-standard'><i class='fa fa-pencil-square-o'></i></a>"+
							"</td>"+
						"</tr>";	
		});
		$('.bloodtypeData').html(append);
		$('#bloodType_table').DataTable({
			    "ordering": false
		});
	})
}