<?php
/**
 * Class that operate on table 'tbl_working_calendar'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2017-12-13 07:17
 */
class TblWorkingCalendarMySqlDAO implements TblWorkingCalendarDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @return TblWorkingCalendarMySql 
	 */
	public function load($id){
		$sql = 'SELECT * FROM tbl_working_calendar WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($id);
		return $this->getRow($sqlQuery);
	}

	/**
	 * Get all records from table
	 */
	public function queryAll(){
		$sql = 'SELECT * FROM tbl_working_calendar';
		$sqlQuery = new SqlQuery($sql);
		return $this->getList($sqlQuery);
	}
	
	/**
	 * Get all records from table ordered by field
	 *
	 * @param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn){
		$sql = 'SELECT * FROM tbl_working_calendar ORDER BY '.$orderColumn;
		$sqlQuery = new SqlQuery($sql);
		return $this->getList($sqlQuery);
	}
	
	/**
 	 * Delete record from table
 	 * @param tblWorkingCalendar primary key
 	 */
	public function delete($id){
		$sql = 'DELETE FROM tbl_working_calendar WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($id);
		return $this->executeUpdate($sqlQuery);
	}
	
	/**
 	 * Insert record to table
 	 *
 	 * @param TblWorkingCalendarMySql tblWorkingCalendar
 	 */
	public function insert($tblWorkingCalendar){
		$sql = 'INSERT INTO tbl_working_calendar (holiday_id, total_hours_per_day, remarks, working_type, working_date, fromTime, toTime, created_by, modified_by, date_created, date_modified) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)';
		$sqlQuery = new SqlQuery($sql);
		
		$sqlQuery->setNumber($tblWorkingCalendar->holidayId);
		$sqlQuery->set($tblWorkingCalendar->totalHoursPerDay);
		$sqlQuery->set($tblWorkingCalendar->remarks);
		$sqlQuery->set($tblWorkingCalendar->workingType);
		$sqlQuery->set($tblWorkingCalendar->workingDate);
		$sqlQuery->set($tblWorkingCalendar->fromTime);
		$sqlQuery->set($tblWorkingCalendar->toTime);
		$sqlQuery->setNumber($tblWorkingCalendar->createdBy);
		$sqlQuery->setNumber($tblWorkingCalendar->modifiedBy);
		$sqlQuery->set($tblWorkingCalendar->dateCreated);
		$sqlQuery->set($tblWorkingCalendar->dateModified);

		$id = $this->executeInsert($sqlQuery);	
		$tblWorkingCalendar->id = $id;
		return $id;
	}
	
	/**
 	 * Update record in table
 	 *
 	 * @param TblWorkingCalendarMySql tblWorkingCalendar
 	 */
	public function update($tblWorkingCalendar){
		$sql = 'UPDATE tbl_working_calendar SET holiday_id = ?, total_hours_per_day = ?, remarks = ?, working_type = ?, working_date = ?, fromTime = ?, toTime = ?, created_by = ?, modified_by = ?, date_created = ?, date_modified = ? WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		
		$sqlQuery->setNumber($tblWorkingCalendar->holidayId);
		$sqlQuery->set($tblWorkingCalendar->totalHoursPerDay);
		$sqlQuery->set($tblWorkingCalendar->remarks);
		$sqlQuery->set($tblWorkingCalendar->workingType);
		$sqlQuery->set($tblWorkingCalendar->workingDate);
		$sqlQuery->set($tblWorkingCalendar->fromTime);
		$sqlQuery->set($tblWorkingCalendar->toTime);
		$sqlQuery->setNumber($tblWorkingCalendar->createdBy);
		$sqlQuery->setNumber($tblWorkingCalendar->modifiedBy);
		$sqlQuery->set($tblWorkingCalendar->dateCreated);
		$sqlQuery->set($tblWorkingCalendar->dateModified);

		$sqlQuery->setNumber($tblWorkingCalendar->id);
		return $this->executeUpdate($sqlQuery);
	}

	/**
 	 * Delete all rows
 	 */
	public function clean(){
		$sql = 'DELETE FROM tbl_working_calendar';
		$sqlQuery = new SqlQuery($sql);
		return $this->executeUpdate($sqlQuery);
	}

	public function queryByHolidayId($value){
		$sql = 'SELECT * FROM tbl_working_calendar WHERE holiday_id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByTotalHoursPerDay($value){
		$sql = 'SELECT * FROM tbl_working_calendar WHERE total_hours_per_day = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByRemarks($value){
		$sql = 'SELECT * FROM tbl_working_calendar WHERE remarks = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByWorkingType($value){
		$sql = 'SELECT * FROM tbl_working_calendar WHERE working_type = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByWorkingDate($value){
		$sql = 'SELECT * FROM tbl_working_calendar WHERE working_date = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByFromTime($value){
		$sql = 'SELECT * FROM tbl_working_calendar WHERE fromTime = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByToTime($value){
		$sql = 'SELECT * FROM tbl_working_calendar WHERE toTime = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByCreatedBy($value){
		$sql = 'SELECT * FROM tbl_working_calendar WHERE created_by = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByModifiedBy($value){
		$sql = 'SELECT * FROM tbl_working_calendar WHERE modified_by = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByDateCreated($value){
		$sql = 'SELECT * FROM tbl_working_calendar WHERE date_created = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByDateModified($value){
		$sql = 'SELECT * FROM tbl_working_calendar WHERE date_modified = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}


	public function deleteByHolidayId($value){
		$sql = 'DELETE FROM tbl_working_calendar WHERE holiday_id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByTotalHoursPerDay($value){
		$sql = 'DELETE FROM tbl_working_calendar WHERE total_hours_per_day = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByRemarks($value){
		$sql = 'DELETE FROM tbl_working_calendar WHERE remarks = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByWorkingType($value){
		$sql = 'DELETE FROM tbl_working_calendar WHERE working_type = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByWorkingDate($value){
		$sql = 'DELETE FROM tbl_working_calendar WHERE working_date = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByFromTime($value){
		$sql = 'DELETE FROM tbl_working_calendar WHERE fromTime = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByToTime($value){
		$sql = 'DELETE FROM tbl_working_calendar WHERE toTime = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByCreatedBy($value){
		$sql = 'DELETE FROM tbl_working_calendar WHERE created_by = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByModifiedBy($value){
		$sql = 'DELETE FROM tbl_working_calendar WHERE modified_by = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByDateCreated($value){
		$sql = 'DELETE FROM tbl_working_calendar WHERE date_created = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByDateModified($value){
		$sql = 'DELETE FROM tbl_working_calendar WHERE date_modified = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}


	
	/**
	 * Read row
	 *
	 * @return TblWorkingCalendarMySql 
	 */
	protected function readRow($row){
		$tblWorkingCalendar = new TblWorkingCalendar();
		
		$tblWorkingCalendar->id = $row['id'];
		$tblWorkingCalendar->holidayId = $row['holiday_id'];
		$tblWorkingCalendar->totalHoursPerDay = $row['total_hours_per_day'];
		$tblWorkingCalendar->remarks = $row['remarks'];
		$tblWorkingCalendar->workingType = $row['working_type'];
		$tblWorkingCalendar->workingDate = $row['working_date'];
		$tblWorkingCalendar->fromTime = $row['fromTime'];
		$tblWorkingCalendar->toTime = $row['toTime'];
		$tblWorkingCalendar->createdBy = $row['created_by'];
		$tblWorkingCalendar->modifiedBy = $row['modified_by'];
		$tblWorkingCalendar->dateCreated = $row['date_created'];
		$tblWorkingCalendar->dateModified = $row['date_modified'];

		return $tblWorkingCalendar;
	}
	
	protected function getList($sqlQuery){
		$tab = QueryExecutor::execute($sqlQuery);
		$ret = array();
		for($i=0;$i<count($tab);$i++){
			$ret[$i] = $this->readRow($tab[$i]);
		}
		return $ret;
	}
	
	/**
	 * Get row
	 *
	 * @return TblWorkingCalendarMySql 
	 */
	protected function getRow($sqlQuery){
		$tab = QueryExecutor::execute($sqlQuery);
		if(count($tab)==0){
			return null;
		}
		return $this->readRow($tab[0]);		
	}
	
	/**
	 * Execute sql query
	 */
	protected function execute($sqlQuery){
		return QueryExecutor::execute($sqlQuery);
	}
	
		
	/**
	 * Execute sql query
	 */
	protected function executeUpdate($sqlQuery){
		return QueryExecutor::executeUpdate($sqlQuery);
	}

	/**
	 * Query for one row and one column
	 */
	protected function querySingleResult($sqlQuery){
		return QueryExecutor::queryForString($sqlQuery);
	}

	/**
	 * Insert row to table
	 */
	protected function executeInsert($sqlQuery){
		return QueryExecutor::executeInsert($sqlQuery);
	}
}
?>