<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2017-12-06 06:34
 */
interface TblKeyAccountsDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return TblKeyAccounts 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param tblKeyAccount primary key
 	 */
	public function delete($id);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param TblKeyAccounts tblKeyAccount
 	 */
	public function insert($tblKeyAccount);
	
	/**
 	 * Update record in table
 	 *
 	 * @param TblKeyAccounts tblKeyAccount
 	 */
	public function update($tblKeyAccount);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryByReferredBy($value);

	public function queryByInitiatedBy($value);

	public function queryByClosedBy($value);

	public function queryByManagedBy($value);

	public function queryByDateCreated($value);

	public function queryByDateModified($value);


	public function deleteByReferredBy($value);

	public function deleteByInitiatedBy($value);

	public function deleteByClosedBy($value);

	public function deleteByManagedBy($value);

	public function deleteByDateCreated($value);

	public function deleteByDateModified($value);


}
?>