<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2017-12-06 06:34
 */
interface TblNbtPerTbaDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return TblNbtPerTba 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param tblNbtPerTba primary key
 	 */
	public function delete($id);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param TblNbtPerTba tblNbtPerTba
 	 */
	public function insert($tblNbtPerTba);
	
	/**
 	 * Update record in table
 	 *
 	 * @param TblNbtPerTba tblNbtPerTba
 	 */
	public function update($tblNbtPerTba);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryByNbtId($value);

	public function queryByTbaPerEngId($value);

	public function queryByCreatedBy($value);

	public function queryByModifiedBy($value);

	public function queryByDateCreated($value);

	public function queryByDateModified($value);


	public function deleteByNbtId($value);

	public function deleteByTbaPerEngId($value);

	public function deleteByCreatedBy($value);

	public function deleteByModifiedBy($value);

	public function deleteByDateCreated($value);

	public function deleteByDateModified($value);


}
?>