<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2017-12-06 06:34
 */
interface TblHourCodeDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return TblHourCode 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param tblHourCode primary key
 	 */
	public function delete($id);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param TblHourCode tblHourCode
 	 */
	public function insert($tblHourCode);
	
	/**
 	 * Update record in table
 	 *
 	 * @param TblHourCode tblHourCode
 	 */
	public function update($tblHourCode);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryByHourCodeNo($value);

	public function queryByHourCode($value);

	public function queryByDescription($value);

	public function queryByStatus($value);

	public function queryByCreatedBy($value);

	public function queryByModifiedBy($value);

	public function queryByDateCreated($value);

	public function queryByDateModified($value);


	public function deleteByHourCodeNo($value);

	public function deleteByHourCode($value);

	public function deleteByDescription($value);

	public function deleteByStatus($value);

	public function deleteByCreatedBy($value);

	public function deleteByModifiedBy($value);

	public function deleteByDateCreated($value);

	public function deleteByDateModified($value);


}
?>