<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2019-05-27 08:17
 */
interface TblClientNewDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return TblClientNew 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param tblClientNew primary key
 	 */
	public function delete($id);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param TblClientNew tblClientNew
 	 */
	public function insert($tblClientNew);
	
	/**
 	 * Update record in table
 	 *
 	 * @param TblClientNew tblClientNew
 	 */
	public function update($tblClientNew);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryByClientNo($value);

	public function queryByClient($value);

	public function queryByType($value);

	public function queryByDateCreated($value);

	public function queryByDateModified($value);


	public function deleteByClientNo($value);

	public function deleteByClient($value);

	public function deleteByType($value);

	public function deleteByDateCreated($value);

	public function deleteByDateModified($value);


}
?>